/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.provider;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.sirius.properties.WidgetConditionalStyle;
import org.eclipse.sirius.properties.WidgetStyle;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.ToolFactory;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public final class Utils {
    public static final StyledString.Style KEYWORD_STYLE = StyledString.Style.newBuilder().setForegroundColor(URI.createURI((String)"color://rgb/125/9/82")).setFont(IItemFontProvider.BOLD_FONT).toStyle();

    private Utils() {
    }

    public static StyledString computeLabel(ItemProviderAdapter itemProviderAdapter, Object object, String defaultLabelKey) {
        StyledString styledString = new StyledString();
        if (object instanceof IdentifiedElement) {
            IdentifiedElement identifiedElement = (IdentifiedElement)object;
            styledString = Utils.computeIdentifiedElementLabel(itemProviderAdapter, identifiedElement, defaultLabelKey);
        } else if (object instanceof WidgetConditionalStyle) {
            WidgetConditionalStyle widgetConditionalStyle = (WidgetConditionalStyle)object;
            styledString = Utils.computeWidgetConditionalStyleLabel(itemProviderAdapter, widgetConditionalStyle, defaultLabelKey);
        } else if (object instanceof WidgetStyle) {
            WidgetStyle widgetStyle = (WidgetStyle)object;
            styledString = Utils.computeWidgetStyleLabel(itemProviderAdapter, widgetStyle, defaultLabelKey);
        }
        return styledString;
    }

    private static StyledString computeIdentifiedElementLabel(ItemProviderAdapter itemProviderAdapter, IdentifiedElement identifiedElement, String defaultLabelKey) {
        String label = Optional.ofNullable(identifiedElement.getLabel()).orElse("");
        if (label.isEmpty()) {
            label = Optional.ofNullable(identifiedElement.getName()).filter(id -> !id.isEmpty()).orElseGet(() -> itemProviderAdapter.getString(defaultLabelKey));
        }
        StyledString styledString = new StyledString(label);
        EStructuralFeature eStructuralFeature = identifiedElement.eClass().getEStructuralFeature("extends");
        if (eStructuralFeature instanceof EReference && identifiedElement.eIsSet(eStructuralFeature)) {
            Object extendsValue = identifiedElement.eGet(eStructuralFeature);
            styledString.append(" extends ", KEYWORD_STYLE);
            styledString.append(Utils.computeSimpleLabel(itemProviderAdapter, extendsValue));
        }
        return styledString;
    }

    private static StyledString computeWidgetConditionalStyleLabel(ItemProviderAdapter itemProviderAdapter, WidgetConditionalStyle widgetConditionalStyle, String defaultLabelKey) {
        String label = Optional.ofNullable(widgetConditionalStyle.getPreconditionExpression()).orElse("");
        if (label.isEmpty()) {
            label = itemProviderAdapter.getString(defaultLabelKey);
        }
        return new StyledString(label);
    }

    private static StyledString computeWidgetStyleLabel(ItemProviderAdapter itemProviderAdapter, WidgetStyle widgetStyle, String defaultLabelKey) {
        String label = Optional.ofNullable(widgetStyle.getLabelFontNameExpression()).orElse("");
        if (label.isEmpty()) {
            label = itemProviderAdapter.getString(defaultLabelKey);
        }
        return new StyledString(label);
    }

    private static String computeSimpleLabel(ItemProviderAdapter itemProviderAdapter, Object object) {
        if (object instanceof IdentifiedElement) {
            IdentifiedElement identifiedElement = (IdentifiedElement)object;
            String label = Optional.ofNullable(identifiedElement.getLabel()).orElse("");
            if (label.isEmpty()) {
                label = Optional.ofNullable(identifiedElement.getName()).filter(id -> !id.isEmpty()).orElseGet(() -> itemProviderAdapter.getString("_UI_" + identifiedElement.eClass().getName() + "_type"));
            }
            return label;
        }
        return "";
    }

    public static void addNoopNavigationOperations(Object child) {
        if (child instanceof EObject) {
            EObject obj = (EObject)child;
            for (EReference ref : obj.eClass().getEAllReferences()) {
                if (!ref.isContainment() || ref.getEReferenceType() != ToolPackage.Literals.INITIAL_OPERATION) continue;
                InitialOperation begin = ToolFactory.eINSTANCE.createInitialOperation();
                ChangeContext noop = ToolFactory.eINSTANCE.createChangeContext();
                noop.setBrowseExpression("var:self");
                begin.setFirstModelOperations((ModelOperation)noop);
                obj.eSet((EStructuralFeature)ref, (Object)begin);
            }
        }
    }
}

