/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.commands.MemoryMapWidget;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelManager;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.osgi.service.prefs.Preferences;

public class TCFMemoryMapTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_ID = "org.eclipse.tcf.launch.memoryMapTab";
    private MemoryMapWidget widget;

    public void createControl(Composite parent) {
        TCFNode node = this.getSelectedNode();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.widget = this.createWidget(composite, node);
        this.widget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TCFMemoryMapTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)composite);
    }

    protected MemoryMapWidget createWidget(Composite composite, TCFNode node) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tcf.debug.ui");
        prefs = prefs.node(TCFMemoryMapTab.class.getCanonicalName());
        return new MemoryMapWidget(composite, node, (Preferences)prefs);
    }

    protected final MemoryMapWidget getWidget() {
        return this.widget;
    }

    public boolean updateContext() {
        TCFNode node;
        if (this.widget != null && (node = this.getSelectedNode()) != null) {
            return this.widget.setTCFNode(node);
        }
        return false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy cfg) {
    }

    public void initializeFrom(ILaunchConfiguration cfg) {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.widget.loadData(cfg);
    }

    public void performApply(ILaunchConfigurationWorkingCopy cfg) {
        try {
            this.widget.saveData(cfg);
        }
        catch (Throwable x) {
            this.setErrorMessage("Cannot update memory map: " + x);
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
        }
        super.dispose();
    }

    public String getName() {
        return "Symbol Files";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/memory-map");
    }

    public String getId() {
        return TAB_ID;
    }

    private TCFNode getSelectedNode() {
        TCFNode node = null;
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable instanceof TCFLaunch) {
            node = TCFModelManager.getRootNodeSync((Launch)adaptable);
        } else if (adaptable != null) {
            node = (TCFNode)adaptable.getAdapter(TCFNode.class);
        }
        return node;
    }
}

