/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.ISysMonitor;

class TestSysMonitor
implements ITCFTest {
    private final TCFTestSuite test_suite;
    private final ISysMonitor sys_mon;
    private final HashMap<String, ISysMonitor.SysMonitorContext> procs = new HashMap();

    TestSysMonitor(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.sys_mon = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
    }

    @Override
    public void start() {
        if (this.sys_mon == null) {
            this.test_suite.done(this, null);
        } else {
            this.sys_mon.getChildren(null, new ISysMonitor.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    if (error != null) {
                        TestSysMonitor.this.exit(error);
                    } else if (context_ids == null || context_ids.length == 0) {
                        TestSysMonitor.this.exit(new Exception("ISysMonitor.getChildren(null) returned empty list"));
                    } else {
                        final HashSet<IToken> cmds = new HashSet<IToken>();
                        String[] stringArray = context_ids;
                        int n = context_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            final String id = stringArray[n2];
                            cmds.add(TestSysMonitor.this.sys_mon.getContext(id, new ISysMonitor.DoneGetContext(){

                                public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                                    cmds.remove(token);
                                    if (error != null) {
                                        if (!(error instanceof IErrorReport)) {
                                            TestSysMonitor.this.exit(error);
                                            return;
                                        }
                                    } else {
                                        TestSysMonitor.this.procs.put(id, context);
                                    }
                                    if (cmds.isEmpty()) {
                                        TestSysMonitor.this.getEnvironment();
                                    }
                                }
                            }));
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    private void getEnvironment() {
        final HashSet<IToken> cmds = new HashSet<IToken>();
        for (String id : this.procs.keySet()) {
            cmds.add(this.sys_mon.getEnvironment(id, new ISysMonitor.DoneGetEnvironment(){

                public void doneGetEnvironment(IToken token, Exception error, String[] environment) {
                    cmds.remove(token);
                    if (error != null && !(error instanceof IErrorReport)) {
                        TestSysMonitor.this.exit(error);
                        return;
                    }
                    if (cmds.isEmpty()) {
                        TestSysMonitor.this.getCommandLine();
                    }
                }
            }));
        }
    }

    private void getCommandLine() {
        final HashSet<IToken> cmds = new HashSet<IToken>();
        for (String id : this.procs.keySet()) {
            cmds.add(this.sys_mon.getCommandLine(id, new ISysMonitor.DoneGetCommandLine(){

                public void doneGetCommandLine(IToken token, Exception error, String[] cmd_line) {
                    cmds.remove(token);
                    if (error != null && !(error instanceof IErrorReport)) {
                        TestSysMonitor.this.exit(error);
                        return;
                    }
                    if (cmds.isEmpty()) {
                        TestSysMonitor.this.exit(null);
                    }
                }
            }));
        }
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.test_suite.done(this, x);
    }

    @Override
    public boolean canResume(String id) {
        return true;
    }
}

