/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicInformationSection
extends BaseTitledSection {
    ISysMonitor.SysMonitorContext context;
    String nodeName;
    String[] nodeCmdLine;
    String nodeType;
    private Text nameText;
    private Text cmdLineText;
    private Text typeText;
    private Text stateText;
    private Text userText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.nameText = this.createWrapTextField(null, Messages.BasicInformationSection_Name);
        this.cmdLineText = this.createTextField((Control)this.nameText, Messages.BasicInformationSection_CmdLine);
        this.typeText = this.createTextField((Control)this.cmdLineText, Messages.BasicInformationSection_Type);
        this.stateText = this.createTextField((Control)this.typeText, Messages.BasicInformationSection_State);
        this.userText = this.createTextField((Control)this.stateText, Messages.BasicInformationSection_User);
    }

    protected void updateInput(IPeerNodeProvider input) {
        Assert.isTrue((boolean)(input instanceof IProcessContextNode));
        final IProcessContextNode node = (IProcessContextNode)input;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BasicInformationSection.this.context = node.getSysMonitorContext();
                BasicInformationSection.this.nodeName = node.getName();
                BasicInformationSection.this.nodeType = node.getType().toString();
                BasicInformationSection.this.nodeCmdLine = (String[])node.getProperty("cmdline");
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    public void refresh() {
        SWTControlUtil.setText((Control)this.nameText, (String)(this.nodeName != null ? this.nodeName : ""));
        SWTControlUtil.setText((Control)this.typeText, (String)(this.nodeType != null ? this.nodeType : ""));
        SWTControlUtil.setText((Control)this.cmdLineText, (String)(this.nodeCmdLine != null ? BasicInformationSection.makeString(this.nodeCmdLine) : ""));
        SWTControlUtil.setText((Control)this.stateText, (String)(this.context != null && this.context.getState() != null ? this.context.getState() : ""));
        SWTControlUtil.setText((Control)this.userText, (String)(this.context != null && this.context.getUserName() != null ? this.context.getUserName() : ""));
        super.refresh();
    }

    protected String getText() {
        return Messages.BasicInformationSection_Title;
    }

    public static final String makeString(String[] cmdline) {
        Assert.isNotNull((Object)cmdline);
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = cmdline;
        int n = cmdline.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            buffer.append(arg.contains(" ") ? "\"" + arg + "\"" : arg);
            buffer.append(" ");
            ++n2;
        }
        return buffer.toString();
    }
}

