/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.categories;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Category
extends ExecutableExtension
implements ICategory,
IDisposable,
IPersistableElement {
    private ImageDescriptor descriptor = null;
    private Image image = null;
    private int rank = -1;
    private Expression expression;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] children;
        String attrRank;
        super.setInitializationData(config, propertyName, data);
        String attrIcon = config.getAttribute("icon");
        if (attrIcon != null) {
            this.descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)config.getNamespaceIdentifier(), (String)attrIcon);
            if (this.descriptor != null) {
                this.image = JFaceResources.getResources().createImageWithDefault(this.descriptor);
            }
        }
        if ((attrRank = config.getAttribute("rank")) != null) {
            try {
                this.rank = Integer.valueOf(attrRank);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((children = config.getChildren("enablement")) != null && children.length > 0) {
            this.expression = ExpressionConverter.getDefault().perform(children[0]);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPersistableElement.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void saveState(IMemento memento) {
        memento.putString("id", this.getId());
    }

    public String getFactoryId() {
        return "org.eclipse.tcf.te.ui.views.categoryFactory";
    }

    public void dispose() {
        if (this.descriptor != null) {
            JFaceResources.getResources().destroyImage(this.descriptor);
            this.descriptor = null;
        }
        this.image = null;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public Object[] getChildren() {
        return null;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public boolean belongsTo(Object element) {
        ICategorizable categorizable = null;
        if (element instanceof IAdaptable) {
            categorizable = (ICategorizable)((IAdaptable)element).getAdapter(ICategorizable.class);
        }
        if (categorizable == null) {
            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter(element, ICategorizable.class);
        }
        return categorizable != null ? Managers.getCategoryManager().belongsTo(this.getId(), categorizable.getId()) : false;
    }

    @Override
    public boolean isEnabled() {
        boolean enabled = true;
        if (this.expression != null) {
            IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            Assert.isNotNull((Object)handlerSvc);
            IEvaluationContext currentState = handlerSvc.getCurrentState();
            EvaluationContext ctx = new EvaluationContext(currentState, (Object)this);
            try {
                enabled = this.expression.evaluate((IEvaluationContext)ctx).equals(EvaluationResult.TRUE);
            }
            catch (CoreException e) {
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return enabled;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getLabel());
        buffer.append(" [");
        buffer.append(this.getId());
        buffer.append("] {rank=");
        buffer.append(this.getRank());
        buffer.append(", enabled=");
        buffer.append(this.isEnabled());
        buffer.append("}");
        return buffer.toString();
    }
}

