/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.cdtserial.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;
import org.eclipse.tm.terminal.connector.cdtserial.activator.Activator;
import org.eclipse.tm.terminal.connector.cdtserial.connector.SerialSettings;
import org.eclipse.tm.terminal.connector.cdtserial.nls.Messages;

public class SerialConnector
extends TerminalConnectorImpl {
    private SerialSettings settings = new SerialSettings();
    SerialPort serialPort;
    private static Set<String> openPorts = new HashSet<String>();

    public static boolean isOpen(String portName) {
        return openPorts.contains(portName);
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.serialPort.getOutputStream();
    }

    public SerialSettings getSettings() {
        return this.settings;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public String getSettingsSummary() {
        return this.settings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }

    public void connect(final ITerminalControl control) {
        super.connect(control);
        control.setState(TerminalState.CONNECTING);
        this.serialPort = new SerialPort(this.settings.getPortName());
        try {
            this.serialPort.setBaudRateValue(this.settings.getBaudRateValue());
            this.serialPort.setByteSize(this.settings.getByteSize());
            this.serialPort.setParity(this.settings.getParity());
            this.serialPort.setStopBits(this.settings.getStopBits());
            this.serialPort.open();
        }
        catch (IOException e) {
            Activator.log(e);
            String error = NLS.bind((String)Messages.SerialConnector_FailedToOpen, (Object)this.settings.getPortName(), (Object)e.getLocalizedMessage());
            try {
                control.getRemoteToTerminalOutputStream().write(error.getBytes());
            }
            catch (IOException e1) {
                Activator.log(e);
            }
            control.setState(TerminalState.CLOSED);
            return;
        }
        openPorts.add(this.serialPort.getPortName());
        new Thread(){

            @Override
            public void run() {
                InputStream targetIn = SerialConnector.this.serialPort.getInputStream();
                byte[] buff = new byte[256];
                try {
                    int n;
                    while ((n = targetIn.read(buff, 0, buff.length)) >= 0) {
                        if (n == 0) continue;
                        control.getRemoteToTerminalOutputStream().write(buff, 0, n);
                    }
                    SerialConnector.this.disconnect();
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            }
        }.start();
        control.setState(TerminalState.CONNECTED);
    }

    protected void doDisconnect() {
        if (this.serialPort != null && this.serialPort.isOpen()) {
            openPorts.remove(this.serialPort.getPortName());
            try {
                this.serialPort.close();
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        this.serialPort = null;
    }
}

