/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.chart.ui.dialog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartModel;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartSeries;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartType;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.tmf.chart.ui.dialog.Messages;
import org.eclipse.tracecompass.internal.tmf.chart.ui.type.BarChartTypeDefinition;
import org.eclipse.tracecompass.internal.tmf.chart.ui.type.IChartTypeDefinition;
import org.eclipse.tracecompass.internal.tmf.chart.ui.type.ScatterChartTypeDefinition;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;
import org.eclipse.ui.PlatformUI;

public class ChartMakerDialog
extends Dialog {
    private static final Image DELETE_IMAGE = (Image)NonNullUtils.checkNotNull((Object)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
    private final IDataChartProvider<?> fDataProvider;
    private final TableViewer fTypeTable;
    private final TableViewer fSeriesTable;
    private final TableViewer fSelectionXTable;
    private final CheckboxTableViewer fSelectionYTable;
    private final Button fAddButton;
    private final Label fWarningLabel;
    private final Button fXLogscaleButton;
    private final Button fYLogscaleButton;
    private final List<ChartSeries> fSelectedSeries = new ArrayList<ChartSeries>();
    private Composite fComposite;
    private @Nullable IChartTypeDefinition fType;
    private @Nullable IDataChartDescriptor<?, ?> fXFilter;
    private @Nullable IDataChartDescriptor<?, ?> fYFilter;
    private @Nullable ChartData fDataSeries;
    private @Nullable ChartModel fChartModel;

    public ChartMakerDialog(Shell parent, IDataChartProvider<?> model) {
        super(parent);
        this.fComposite = parent;
        this.fDataProvider = model;
        this.fTypeTable = new TableViewer((Composite)parent, 67584);
        this.fSeriesTable = new TableViewer((Composite)parent, 67584);
        this.fSelectionXTable = new TableViewer((Composite)parent, 68112);
        this.fSelectionYTable = (CheckboxTableViewer)NonNullUtils.checkNotNull((Object)CheckboxTableViewer.newCheckList((Composite)parent, (int)2576));
        this.fAddButton = new Button((Composite)parent, 0);
        this.fXLogscaleButton = new Button((Composite)parent, 32);
        this.fYLogscaleButton = new Button((Composite)parent, 32);
        this.fWarningLabel = new Label((Composite)parent, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public @Nullable ChartData getDataSeries() {
        return this.fDataSeries;
    }

    public @Nullable ChartModel getChartModel() {
        return this.fChartModel;
    }

    public Point getInitialSize() {
        return new Point(800, 600);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public Composite createDialogArea(@Nullable Composite parent) {
        this.fComposite = (Composite)NonNullUtils.checkNotNull((Object)((Composite)super.createDialogArea(parent)));
        this.getShell().setText(Messages.ChartMakerDialog_Title);
        GridLayout baseLayout = new GridLayout();
        baseLayout.numColumns = 2;
        GridData genericFillGridData = new GridData();
        genericFillGridData.horizontalAlignment = 4;
        genericFillGridData.verticalAlignment = 4;
        genericFillGridData.grabExcessHorizontalSpace = true;
        genericFillGridData.grabExcessVerticalSpace = true;
        this.fComposite.setLayout((Layout)baseLayout);
        this.createTypeTable();
        this.createSelectedSeriesGroup(genericFillGridData);
        this.createSeriesCreatorGroup(genericFillGridData);
        this.createOptionsGroup();
        return this.fComposite;
    }

    private void createTypeTable() {
        GridData typeGridData = new GridData();
        typeGridData.verticalSpan = 3;
        typeGridData.horizontalAlignment = 4;
        typeGridData.verticalAlignment = 4;
        typeGridData.grabExcessHorizontalSpace = false;
        typeGridData.grabExcessVerticalSpace = true;
        TableViewerColumn typeColumn = new TableViewerColumn(this.fTypeTable, 0);
        typeColumn.getColumn().setWidth(50);
        typeColumn.setLabelProvider((CellLabelProvider)new TypeLabelProvider());
        ArrayList<IChartTypeDefinition> types = new ArrayList<IChartTypeDefinition>();
        types.add(new BarChartTypeDefinition());
        types.add(new ScatterChartTypeDefinition());
        this.fTypeTable.getTable().setParent(this.fComposite);
        this.fTypeTable.getTable().setLayoutData((Object)typeGridData);
        this.fTypeTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fTypeTable.addSelectionChangedListener((ISelectionChangedListener)new TypeSelectionListener());
        this.fTypeTable.setInput(types);
    }

    private void createSelectedSeriesGroup(GridData genericFillGridData) {
        GridLayout genericGridLayout = new GridLayout();
        TableViewerColumn dummyColumn = new TableViewerColumn(this.fSeriesTable, 0);
        dummyColumn.setLabelProvider((CellLabelProvider)new SeriesDummyLabelProvider());
        TableViewerColumn xSelectionColumn = new TableViewerColumn(this.fSeriesTable, 0);
        xSelectionColumn.getColumn().setText(Messages.ChartMakerDialog_XSeries);
        xSelectionColumn.getColumn().setAlignment(0x1000000);
        xSelectionColumn.getColumn().setResizable(false);
        xSelectionColumn.setLabelProvider((CellLabelProvider)new SeriesXLabelProvider());
        TableViewerColumn ySelectionColumn = new TableViewerColumn(this.fSeriesTable, 0);
        ySelectionColumn.getColumn().setText(Messages.ChartMakerDialog_YSeries);
        ySelectionColumn.getColumn().setAlignment(0x1000000);
        ySelectionColumn.getColumn().setResizable(false);
        ySelectionColumn.setLabelProvider((CellLabelProvider)new SeriesYLabelProvider());
        TableViewerColumn removeColumn = new TableViewerColumn(this.fSeriesTable, 0);
        removeColumn.getColumn().setResizable(false);
        removeColumn.setLabelProvider((CellLabelProvider)new SeriesRemoveLabelProvider());
        TableColumnLayout seriesLayout = new TableColumnLayout();
        seriesLayout.setColumnData((Widget)dummyColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(0));
        seriesLayout.setColumnData((Widget)xSelectionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        seriesLayout.setColumnData((Widget)ySelectionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
        seriesLayout.setColumnData((Widget)removeColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(34));
        Group seriesGroup = new Group(this.fComposite, 2052);
        seriesGroup.setText(Messages.ChartMakerDialog_SelectedSeries);
        seriesGroup.setLayout((Layout)genericGridLayout);
        seriesGroup.setLayoutData((Object)genericFillGridData);
        Composite seriesComposite = new Composite((Composite)seriesGroup, 0);
        seriesComposite.setLayout((Layout)seriesLayout);
        seriesComposite.setLayoutData((Object)genericFillGridData);
        this.fSeriesTable.getTable().setParent(seriesComposite);
        this.fSeriesTable.getTable().setHeaderVisible(true);
        this.fSeriesTable.getTable().addListener(41, (Listener)new SeriesRowResize());
        this.fSeriesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fSeriesTable.setInput(this.fSelectedSeries);
    }

    private void createSeriesCreatorGroup(GridData genericFillGridData) {
        GridLayout creatorLayout = new GridLayout();
        creatorLayout.numColumns = 2;
        creatorLayout.makeColumnsEqualWidth = true;
        Group creatorGroup = new Group(this.fComposite, 2048);
        creatorGroup.setText(Messages.ChartMakerDialog_SeriesCreator);
        creatorGroup.setLayout((Layout)creatorLayout);
        creatorGroup.setLayoutData((Object)genericFillGridData);
        GridData creatorLabelGridData = new GridData();
        creatorLabelGridData.horizontalAlignment = 0x1000000;
        creatorLabelGridData.verticalAlignment = 1024;
        Label creatorLabelX = new Label((Composite)creatorGroup, 0);
        creatorLabelX.setText(Messages.ChartMakerDialog_XAxis);
        creatorLabelX.setLayoutData((Object)creatorLabelGridData);
        Label creatorLabelY = new Label((Composite)creatorGroup, 0);
        creatorLabelY.setText(Messages.ChartMakerDialog_YAxis);
        creatorLabelY.setLayoutData((Object)creatorLabelGridData);
        TableViewerColumn creatorXColumn = new TableViewerColumn(this.fSelectionXTable, 0);
        creatorXColumn.getColumn().setResizable(false);
        creatorXColumn.setLabelProvider((CellLabelProvider)new DataDescriptorLabelProvider());
        TableColumnLayout creatorXLayout = new TableColumnLayout();
        creatorXLayout.setColumnData((Widget)creatorXColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        Composite creatorXComposite = new Composite((Composite)creatorGroup, 0);
        creatorXComposite.setLayout((Layout)creatorXLayout);
        creatorXComposite.setLayoutData((Object)genericFillGridData);
        this.fSelectionXTable.getTable().setParent(creatorXComposite);
        this.fSelectionXTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fSelectionXTable.setInput((Object)this.fDataProvider.getDataDescriptors());
        this.fSelectionXTable.setFilters(new ViewerFilter[]{new CreatorXFilter()});
        this.fSelectionXTable.addSelectionChangedListener((ISelectionChangedListener)new CreatorXSelectedEvent());
        TableViewerColumn creatorYColumn = new TableViewerColumn((TableViewer)this.fSelectionYTable, 0);
        creatorYColumn.getColumn().setResizable(false);
        creatorYColumn.setLabelProvider((CellLabelProvider)new DataDescriptorLabelProvider());
        TableColumnLayout creatorYLayout = new TableColumnLayout();
        creatorYLayout.setColumnData((Widget)creatorYColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        Composite creatorYComposite = new Composite((Composite)creatorGroup, 0);
        creatorYComposite.setLayout((Layout)creatorYLayout);
        creatorYComposite.setLayoutData((Object)genericFillGridData);
        this.fSelectionYTable.getTable().setParent(creatorYComposite);
        this.fSelectionYTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fSelectionYTable.setInput((Object)this.fDataProvider.getDataDescriptors());
        this.fSelectionYTable.setFilters(new ViewerFilter[]{new CreatorYFilter()});
        this.fSelectionYTable.addCheckStateListener((ICheckStateListener)new CreatorYSelectedEvent());
        this.fWarningLabel.setParent((Composite)creatorGroup);
        this.fWarningLabel.setText(Messages.ChartMakerDialog_SelectionRestrictionWarning);
        this.fWarningLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.fWarningLabel.setVisible(false);
        GridData creatorButtonGridData = new GridData();
        creatorButtonGridData.horizontalAlignment = 131072;
        creatorButtonGridData.widthHint = 30;
        creatorButtonGridData.heightHint = 30;
        Image addImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
        this.fAddButton.setParent((Composite)creatorGroup);
        this.fAddButton.setLayoutData((Object)creatorButtonGridData);
        this.fAddButton.setImage(addImage);
        this.fAddButton.addListener(13, (Listener)new AddButtonClickedEvent());
    }

    private void createOptionsGroup() {
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.numColumns = 2;
        GridData configOptionsGridData = new GridData();
        configOptionsGridData.horizontalAlignment = 4;
        configOptionsGridData.grabExcessHorizontalSpace = true;
        Group optionsGroup = new Group(this.fComposite, 2048);
        optionsGroup.setText(Messages.ChartMakerDialog_Options);
        optionsGroup.setLayout((Layout)optionsLayout);
        optionsGroup.setLayoutData((Object)configOptionsGridData);
        this.fXLogscaleButton.setParent((Composite)optionsGroup);
        this.fXLogscaleButton.setText(Messages.ChartMakerDialog_LogScaleX);
        this.fYLogscaleButton.setParent((Composite)optionsGroup);
        this.fYLogscaleButton.setText(Messages.ChartMakerDialog_LogScaleY);
    }

    public void okPressed() {
        this.fDataSeries = new ChartData(this.fDataProvider, this.fSelectedSeries);
        ChartType type = (ChartType)NonNullUtils.checkNotNull((Object)((IChartTypeDefinition)NonNullUtils.checkNotNull((Object)this.fType)).getType());
        String title = this.fDataProvider.getName();
        boolean xlog = this.fXLogscaleButton.getSelection();
        boolean ylog = this.fYLogscaleButton.getSelection();
        this.fChartModel = new ChartModel(type, title, xlog, ylog);
        super.okPressed();
    }

    private boolean checkIfSeriesCompatible(IChartTypeDefinition typeA, IChartTypeDefinition typeB) {
        for (ChartSeries series : this.fSelectedSeries) {
            if (typeA.checkIfXDescriptorValid(series.getX(), null) != typeB.checkIfXDescriptorValid(series.getX(), null)) {
                return false;
            }
            if (typeA.checkIfYDescriptorValid(series.getY(), null) == typeB.checkIfYDescriptorValid(series.getY(), null)) continue;
            return false;
        }
        return true;
    }

    private boolean checkIfButtonReady() {
        if (this.fSelectionXTable.getSelection().isEmpty()) {
            return false;
        }
        return this.fSelectionYTable.getCheckedElements().length != 0;
    }

    private boolean checkIfSeriesPresent(ChartSeries test) {
        for (ChartSeries series : this.fSelectedSeries) {
            if (series.getX() != test.getX() || series.getY() != test.getY()) continue;
            return true;
        }
        return false;
    }

    private @Nullable ChartSeries findRemoveButtonOwner(Button button) {
        for (ChartSeries series : this.fSelectedSeries) {
            ChartSeriesDialog line = (ChartSeriesDialog)series;
            if (line.getButton() != button) continue;
            return line;
        }
        return null;
    }

    private void removeIncompatibleSeries(IChartTypeDefinition type) {
        Iterator<ChartSeries> iterator = this.fSelectedSeries.iterator();
        while (iterator.hasNext()) {
            ChartSeriesDialog series = (ChartSeriesDialog)iterator.next();
            if (type.checkIfXDescriptorValid(series.getX(), null) && type.checkIfYDescriptorValid(series.getY(), null)) continue;
            series.dispose();
            iterator.remove();
        }
    }

    private void unselectIncompatibleSeries(IChartTypeDefinition type) {
        IDataChartDescriptor descriptorX = (IDataChartDescriptor)this.fSelectionXTable.getStructuredSelection().getFirstElement();
        if (descriptorX != null && !type.checkIfXDescriptorValid(descriptorX, this.fXFilter)) {
            this.fSelectionXTable.getTable().deselectAll();
        }
        Object[] objectArray = this.fSelectionYTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IDataChartDescriptor descriptorY = (IDataChartDescriptor)NonNullUtils.checkNotNull((Object)element);
            if (!type.checkIfYDescriptorValid(descriptorY, this.fYFilter)) {
                this.fSelectionYTable.setChecked(element, false);
            }
            ++n2;
        }
    }

    private void configureLogscaleCheckboxes() {
        if (((IChartTypeDefinition)NonNullUtils.checkNotNull((Object)this.fType)).checkIfXLogscalePossible(this.fXFilter)) {
            this.fXLogscaleButton.setEnabled(true);
        } else {
            this.fXLogscaleButton.setEnabled(false);
            this.fXLogscaleButton.setSelection(false);
        }
        if (((IChartTypeDefinition)NonNullUtils.checkNotNull((Object)this.fType)).checkIfYLogscalePossible(this.fYFilter)) {
            this.fYLogscaleButton.setEnabled(true);
        } else {
            this.fYLogscaleButton.setEnabled(false);
            this.fYLogscaleButton.setSelection(false);
        }
    }

    private boolean tryResetXFilter() {
        if (!this.fSelectedSeries.isEmpty()) {
            return false;
        }
        this.fXFilter = null;
        return true;
    }

    private boolean tryResetYFilter() {
        if (!this.fSelectedSeries.isEmpty()) {
            return false;
        }
        if (this.fSelectionYTable.getCheckedElements().length != 0) {
            return false;
        }
        this.fYFilter = null;
        return true;
    }

    private class AddButtonClickedEvent
    implements Listener {
        private AddButtonClickedEvent() {
        }

        public void handleEvent(@Nullable Event event) {
            IDataChartDescriptor descriptorX = (IDataChartDescriptor)NonNullUtils.checkNotNull((Object)ChartMakerDialog.this.fSelectionXTable.getStructuredSelection().getFirstElement());
            Object[] descriptorsY = ChartMakerDialog.this.fSelectionYTable.getCheckedElements();
            int i = 0;
            while (i < descriptorsY.length) {
                IDataChartDescriptor descriptorY = (IDataChartDescriptor)descriptorsY[i];
                ChartSeriesDialog series = new ChartSeriesDialog(descriptorX, (IDataChartDescriptor)NonNullUtils.checkNotNull((Object)descriptorY));
                if (!ChartMakerDialog.this.checkIfSeriesPresent(series)) {
                    ChartMakerDialog.this.fSelectedSeries.add(series);
                }
                ++i;
            }
            if (ChartMakerDialog.this.fXFilter == null) {
                ChartMakerDialog.this.fXFilter = descriptorX;
            }
            ChartMakerDialog.this.fSeriesTable.refresh();
            Display.getDefault().asyncExec(() -> ChartMakerDialog.this.fSeriesTable.refresh());
            ChartMakerDialog.this.fSelectionXTable.refresh();
            ChartMakerDialog.this.getButton(0).setEnabled(true);
            ChartMakerDialog.this.fWarningLabel.setVisible(true);
            ChartMakerDialog.this.configureLogscaleCheckboxes();
        }
    }

    private class ChartSeriesDialog
    extends ChartSeries {
        private final Button fButton;

        private ChartSeriesDialog(IDataChartDescriptor<?, ?> descriptorX, IDataChartDescriptor<?, ?> descriptorY) {
            super(descriptorX, descriptorY);
            Button button = new Button((Composite)ChartMakerDialog.this.fSeriesTable.getControl(), 8);
            button.setImage(DELETE_IMAGE);
            button.addListener(13, (Listener)new SeriesRemoveButtonEvent());
            this.fButton = button;
        }

        private Button getButton() {
            return this.fButton;
        }

        public void dispose() {
            this.fButton.dispose();
        }
    }

    private class CreatorXFilter
    extends ViewerFilter {
        private CreatorXFilter() {
        }

        public boolean select(@Nullable Viewer viewer, @Nullable Object parentElement, @Nullable Object element) {
            IChartTypeDefinition type = ChartMakerDialog.this.fType;
            if (type == null) {
                return false;
            }
            IDataChartDescriptor descriptor = (IDataChartDescriptor)NonNullUtils.checkNotNull((Object)element);
            return type.checkIfXDescriptorValid(descriptor, ChartMakerDialog.this.fXFilter);
        }
    }

    private class CreatorXSelectedEvent
    implements ISelectionChangedListener {
        private CreatorXSelectedEvent() {
        }

        public void selectionChanged(@Nullable SelectionChangedEvent event) {
            ChartMakerDialog.this.fAddButton.setEnabled(ChartMakerDialog.this.checkIfButtonReady());
        }
    }

    private class CreatorYFilter
    extends ViewerFilter {
        private CreatorYFilter() {
        }

        public boolean select(@Nullable Viewer viewer, @Nullable Object parentElement, @Nullable Object element) {
            IChartTypeDefinition type = ChartMakerDialog.this.fType;
            if (type == null) {
                return false;
            }
            IDataChartDescriptor descriptor = (IDataChartDescriptor)NonNullUtils.checkNotNull((Object)element);
            return type.checkIfYDescriptorValid(descriptor, ChartMakerDialog.this.fYFilter);
        }
    }

    private class CreatorYSelectedEvent
    implements ICheckStateListener {
        private CreatorYSelectedEvent() {
        }

        public void checkStateChanged(@Nullable CheckStateChangedEvent event) {
            if (event == null) {
                return;
            }
            if (event.getChecked()) {
                if (ChartMakerDialog.this.fYFilter == null) {
                    IDataChartDescriptor descriptor;
                    ChartMakerDialog.this.fYFilter = descriptor = (IDataChartDescriptor)event.getElement();
                }
            } else {
                ChartMakerDialog.this.tryResetYFilter();
            }
            ChartMakerDialog.this.fSelectionYTable.refresh();
            ChartMakerDialog.this.fAddButton.setEnabled(ChartMakerDialog.this.checkIfButtonReady());
            ChartMakerDialog.this.configureLogscaleCheckboxes();
        }
    }

    private class DataDescriptorLabelProvider
    extends ColumnLabelProvider {
        private DataDescriptorLabelProvider() {
        }

        public String getText(@Nullable Object element) {
            IDataChartDescriptor descriptor = (IDataChartDescriptor)NonNullUtils.checkNotNull((Object)element);
            return descriptor.getLabel();
        }
    }

    private class SeriesDummyLabelProvider
    extends ColumnLabelProvider {
        private SeriesDummyLabelProvider() {
        }

        public @Nullable String getText(@Nullable Object element) {
            return null;
        }
    }

    private class SeriesRemoveButtonEvent
    implements Listener {
        private SeriesRemoveButtonEvent() {
        }

        public void handleEvent(@Nullable Event event) {
            if (event == null) {
                return;
            }
            Button button = (Button)NonNullUtils.checkNotNull((Object)event.widget);
            button.dispose();
            ChartSeries series = ChartMakerDialog.this.findRemoveButtonOwner(button);
            ChartMakerDialog.this.fSelectedSeries.remove(series);
            ChartMakerDialog.this.fSeriesTable.refresh();
            ChartMakerDialog.this.tryResetXFilter();
            ChartMakerDialog.this.fSelectionXTable.refresh();
            ChartMakerDialog.this.tryResetYFilter();
            ChartMakerDialog.this.fSelectionYTable.refresh();
            if (ChartMakerDialog.this.fSelectedSeries.isEmpty()) {
                ChartMakerDialog.this.getButton(0).setEnabled(false);
                ChartMakerDialog.this.fWarningLabel.setVisible(false);
            }
            ChartMakerDialog.this.configureLogscaleCheckboxes();
        }
    }

    private class SeriesRemoveLabelProvider
    extends ColumnLabelProvider {
        private SeriesRemoveLabelProvider() {
        }

        public @Nullable String getText(@Nullable Object element) {
            return null;
        }

        public void update(@Nullable ViewerCell cell) {
            if (cell == null) {
                return;
            }
            ChartSeriesDialog series = (ChartSeriesDialog)((Object)cell.getViewerRow().getElement());
            Button button = series.getButton();
            TableItem item = (TableItem)cell.getItem();
            TableEditor editor = new TableEditor(item.getParent());
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.setEditor((Control)button, item, cell.getColumnIndex());
            editor.layout();
        }
    }

    private class SeriesRowResize
    implements Listener {
        private SeriesRowResize() {
        }

        public void handleEvent(@Nullable Event event) {
            if (event == null) {
                return;
            }
            event.height = 27;
        }
    }

    private class SeriesXLabelProvider
    extends ColumnLabelProvider {
        private SeriesXLabelProvider() {
        }

        public String getText(@Nullable Object element) {
            ChartSeries series = (ChartSeries)NonNullUtils.checkNotNull((Object)((ChartSeries)element));
            return series.getX().getLabel();
        }
    }

    private class SeriesYLabelProvider
    extends ColumnLabelProvider {
        private SeriesYLabelProvider() {
        }

        public String getText(@Nullable Object element) {
            ChartSeries series = (ChartSeries)NonNullUtils.checkNotNull((Object)((ChartSeries)element));
            return series.getY().getLabel();
        }
    }

    private class TypeLabelProvider
    extends ColumnLabelProvider {
        private TypeLabelProvider() {
        }

        public @Nullable String getText(@Nullable Object element) {
            IChartTypeDefinition type = (IChartTypeDefinition)NonNullUtils.checkNotNull((Object)((IChartTypeDefinition)element));
            return type.getType().name();
        }

        public Image getImage(@Nullable Object element) {
            IChartTypeDefinition type = (IChartTypeDefinition)NonNullUtils.checkNotNull((Object)((IChartTypeDefinition)element));
            return new Image((Device)ChartMakerDialog.this.fComposite.getDisplay(), type.getImageData());
        }
    }

    private class TypeSelectionListener
    implements ISelectionChangedListener {
        private TypeSelectionListener() {
        }

        public void selectionChanged(@Nullable SelectionChangedEvent event) {
            IStructuredSelection selection = ChartMakerDialog.this.fTypeTable.getStructuredSelection();
            IChartTypeDefinition type = (IChartTypeDefinition)selection.getFirstElement();
            if (type == null) {
                return;
            }
            if (!ChartMakerDialog.this.fSelectedSeries.isEmpty() && !ChartMakerDialog.this.checkIfSeriesCompatible((IChartTypeDefinition)NonNullUtils.checkNotNull((Object)ChartMakerDialog.this.fType), type)) {
                String warning = Messages.ChartMakerDialog_WarningConfirm;
                String message = String.format(Messages.ChartMakerDialog_WarningIncompatibleSeries, type.getType().toString().toLowerCase());
                boolean choice = MessageDialog.openConfirm((Shell)ChartMakerDialog.this.fComposite.getShell(), (String)warning, (String)message);
                if (!choice) {
                    ChartMakerDialog.this.fTypeTable.setSelection((ISelection)new StructuredSelection((Object)ChartMakerDialog.this.fType));
                    return;
                }
                ChartMakerDialog.this.removeIncompatibleSeries(type);
                ChartMakerDialog.this.fSeriesTable.refresh();
            }
            ChartMakerDialog.this.fType = type;
            ChartMakerDialog.this.unselectIncompatibleSeries(ChartMakerDialog.this.fType);
            if (ChartMakerDialog.this.tryResetXFilter()) {
                ChartMakerDialog.this.fSelectionXTable.refresh();
            }
            if (ChartMakerDialog.this.tryResetYFilter()) {
                ChartMakerDialog.this.fSelectionYTable.refresh();
            }
            ChartMakerDialog.this.fAddButton.setEnabled(ChartMakerDialog.this.checkIfButtonReady());
            ChartMakerDialog.this.configureLogscaleCheckboxes();
        }
    }
}

