/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.localsearch.matcher.CallWithAdornment;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.AggregatorCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.BinaryTransitiveClosureCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckConstant;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckPositivePatternCall;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CountCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.ExpressionCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.ExpressionEvalCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.InequalityCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.NACOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.AggregatorExtend;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.CountOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExpressionEval;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendBinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendConstant;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendPositivePatternCall;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.IOperationCompiler;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.CompilerHelper;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PApply;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PStart;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternCallBasedDeferred;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryReflexiveTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;

public abstract class AbstractOperationCompiler
implements IOperationCompiler {
    protected static final String UNSUPPORTED_TYPE_MESSAGE = "Unsupported type: ";
    protected List<ISearchOperation> operations;
    protected Set<CallWithAdornment> dependencies = new HashSet<CallWithAdornment>();
    protected Map<PConstraint, Set<Integer>> variableBindings;
    private Map<PVariable, Integer> variableMappings;
    protected final IQueryRuntimeContext runtimeContext;

    protected abstract void createExtend(TypeConstraint var1, Map<PVariable, Integer> var2);

    protected abstract void createCheck(TypeConstraint var1, Map<PVariable, Integer> var2);

    protected abstract void createCheck(TypeFilterConstraint var1, Map<PVariable, Integer> var2);

    protected abstract void createUnaryTypeCheck(IInputKey var1, int var2);

    public AbstractOperationCompiler(IQueryRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    @Override
    public List<ISearchOperation> compile(SubPlan plan, Set<PParameter> boundParameters) {
        this.variableMappings = CompilerHelper.createVariableMapping(plan);
        this.variableBindings = CompilerHelper.cacheVariableBindings(plan, this.variableMappings, boundParameters);
        this.operations = new ArrayList<ISearchOperation>();
        List<POperation> operationList = CompilerHelper.createOperationsList(plan);
        for (POperation pOperation : operationList) {
            this.compile(pOperation, this.variableMappings);
        }
        return this.operations;
    }

    private void compile(POperation pOperation, Map<PVariable, Integer> variableMapping) {
        if (pOperation instanceof PApply) {
            PApply pApply = (PApply)pOperation;
            PConstraint pConstraint = pApply.getPConstraint();
            if (this.isCheck(pConstraint, variableMapping)) {
                this.createCheckDispatcher(pConstraint, variableMapping);
            } else {
                this.createExtendDispatcher(pConstraint, variableMapping);
            }
        } else if (!(pOperation instanceof PStart) && !(pOperation instanceof PProject)) {
            throw new QueryProcessingException("PStart, PApply or PProject was expected, received: " + String.valueOf(pOperation.getClass()), null, "Unexpected POperation type", null);
        }
    }

    private void createCheckDispatcher(PConstraint pConstraint, Map<PVariable, Integer> variableMapping) {
        if (pConstraint instanceof Inequality) {
            this.createCheck((Inequality)pConstraint, variableMapping);
        } else if (pConstraint instanceof PositivePatternCall) {
            this.createCheck((PositivePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof NegativePatternCall) {
            this.createCheck((NegativePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof AggregatorConstraint) {
            this.createCheck((AggregatorConstraint)pConstraint, variableMapping);
        } else if (pConstraint instanceof PatternMatchCounter) {
            this.createCheck((PatternMatchCounter)pConstraint, variableMapping);
        } else if (pConstraint instanceof ExpressionEvaluation) {
            this.createCheck((ExpressionEvaluation)pConstraint, variableMapping);
        } else if (pConstraint instanceof TypeFilterConstraint) {
            this.createCheck((TypeFilterConstraint)pConstraint, variableMapping);
        } else if (!(pConstraint instanceof ExportedParameter)) {
            if (pConstraint instanceof BinaryTransitiveClosure) {
                this.createCheck((BinaryTransitiveClosure)pConstraint, variableMapping);
            } else if (pConstraint instanceof BinaryReflexiveTransitiveClosure) {
                this.createCheck((BinaryReflexiveTransitiveClosure)pConstraint, variableMapping);
            } else if (pConstraint instanceof ConstantValue) {
                this.createCheck((ConstantValue)pConstraint, variableMapping);
            } else if (pConstraint instanceof TypeConstraint) {
                this.createCheck((TypeConstraint)pConstraint, variableMapping);
            } else {
                String msg = "Unsupported Check constraint: " + pConstraint.toString();
                throw new QueryProcessingException(msg, null, msg, null);
            }
        }
    }

    protected void createExtendDispatcher(PConstraint pConstraint, Map<PVariable, Integer> variableMapping) {
        if (pConstraint instanceof PositivePatternCall) {
            this.createExtend((PositivePatternCall)pConstraint, variableMapping);
        } else if (pConstraint instanceof AggregatorConstraint) {
            this.createExtend((AggregatorConstraint)pConstraint, variableMapping);
        } else if (pConstraint instanceof PatternMatchCounter) {
            this.createExtend((PatternMatchCounter)pConstraint, variableMapping);
        } else if (pConstraint instanceof ExpressionEvaluation) {
            this.createExtend((ExpressionEvaluation)pConstraint, variableMapping);
        } else if (!(pConstraint instanceof ExportedParameter)) {
            if (pConstraint instanceof ConstantValue) {
                this.createExtend((ConstantValue)pConstraint, variableMapping);
            } else if (pConstraint instanceof TypeConstraint) {
                this.createExtend((TypeConstraint)pConstraint, variableMapping);
            } else if (pConstraint instanceof BinaryTransitiveClosure) {
                this.createExtend((BinaryTransitiveClosure)pConstraint, variableMapping);
            } else if (pConstraint instanceof BinaryReflexiveTransitiveClosure) {
                this.createExtend((BinaryReflexiveTransitiveClosure)pConstraint, variableMapping);
            } else {
                String msg = "Unsupported Extend constraint: " + pConstraint.toString();
                throw new QueryProcessingException(msg, null, msg, null);
            }
        }
    }

    private boolean isCheck(PConstraint pConstraint, Map<PVariable, Integer> variableMapping) {
        if (pConstraint instanceof NegativePatternCall) {
            return true;
        }
        if (pConstraint instanceof PositivePatternCall) {
            List callVariables = pConstraint.getAffectedVariables().stream().filter(input -> input.getReferringConstraints().size() > 1).map(variableMapping::get).collect(Collectors.toList());
            return this.variableBindings.get(pConstraint).containsAll(callVariables);
        }
        if (pConstraint instanceof AggregatorConstraint) {
            PVariable outputvar = ((AggregatorConstraint)pConstraint).getResultVariable();
            return this.variableBindings.get(pConstraint).contains(variableMapping.get(outputvar));
        }
        if (pConstraint instanceof PatternMatchCounter) {
            PVariable outputvar = ((PatternMatchCounter)pConstraint).getResultVariable();
            return this.variableBindings.get(pConstraint).contains(variableMapping.get(outputvar));
        }
        if (pConstraint instanceof ExpressionEvaluation) {
            PVariable outputvar = ((ExpressionEvaluation)pConstraint).getOutputVariable();
            return outputvar == null || this.variableBindings.get(pConstraint).contains(variableMapping.get(outputvar));
        }
        Set affectedVariables = pConstraint.getAffectedVariables();
        HashSet<Integer> varIndices = new HashSet<Integer>();
        for (PVariable variable : affectedVariables) {
            varIndices.add(variableMapping.get(variable));
        }
        return this.variableBindings.get(pConstraint).containsAll(varIndices);
    }

    @Override
    public Set<CallWithAdornment> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Map<PVariable, Integer> getVariableMappings() {
        return this.variableMappings;
    }

    protected void createCheck(PatternMatchCounter counter, Map<PVariable, Integer> variableMapping) {
        CallInformation information = CallInformation.create((PatternCallBasedDeferred)counter, variableMapping, this.variableBindings.get(counter));
        this.operations.add(new CountCheck(information, variableMapping.get(counter.getResultVariable())));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createCheck(PositivePatternCall pCall, Map<PVariable, Integer> variableMapping) {
        CallInformation information = CallInformation.create(pCall, variableMapping, this.variableBindings.get(pCall));
        this.operations.add(new CheckPositivePatternCall(information));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createCheck(ConstantValue constant, Map<PVariable, Integer> variableMapping) {
        int position = variableMapping.get(constant.getVariablesTuple().get(0));
        this.operations.add(new CheckConstant(position, constant.getSupplierKey()));
    }

    protected void createCheck(BinaryTransitiveClosure binaryTransitiveClosure, Map<PVariable, Integer> variableMapping) {
        int sourcePosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(1));
        CallInformation information = CallInformation.create(binaryTransitiveClosure, variableMapping, Stream.of(Integer.valueOf(sourcePosition)).collect(Collectors.toSet()));
        this.operations.add(new BinaryTransitiveClosureCheck(information, sourcePosition, targetPosition, false));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createCheck(BinaryReflexiveTransitiveClosure binaryTransitiveClosure, Map<PVariable, Integer> variableMapping) {
        int sourcePosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(1));
        CallInformation information = CallInformation.create(binaryTransitiveClosure, variableMapping, Stream.of(Integer.valueOf(sourcePosition)).collect(Collectors.toSet()));
        this.createUnaryTypeCheck(binaryTransitiveClosure.getUniverseType(), sourcePosition);
        this.operations.add(new BinaryTransitiveClosureCheck(information, sourcePosition, targetPosition, true));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createCheck(ExpressionEvaluation expressionEvaluation, Map<PVariable, Integer> variableMapping) {
        Iterable inputParameterNames = expressionEvaluation.getEvaluator().getInputParameterNames();
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        for (String pVariableName : inputParameterNames) {
            PVariable pVariable = expressionEvaluation.getPSystem().getVariableByNameChecked((Object)pVariableName);
            nameMap.put(pVariableName, variableMapping.get(pVariable));
        }
        if (expressionEvaluation.getOutputVariable() == null) {
            this.operations.add(new ExpressionCheck(expressionEvaluation.getEvaluator(), nameMap));
        } else {
            this.operations.add(new ExpressionEvalCheck(expressionEvaluation.getEvaluator(), nameMap, expressionEvaluation.isUnwinding(), variableMapping.get(expressionEvaluation.getOutputVariable())));
        }
    }

    protected void createCheck(AggregatorConstraint aggregator, Map<PVariable, Integer> variableMapping) {
        CallInformation information = CallInformation.create((PatternCallBasedDeferred)aggregator, variableMapping, this.variableBindings.get(aggregator));
        this.operations.add(new AggregatorCheck(information, aggregator, variableMapping.get(aggregator.getResultVariable())));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createCheck(NegativePatternCall negativePatternCall, Map<PVariable, Integer> variableMapping) {
        CallInformation information = CallInformation.create((PatternCallBasedDeferred)negativePatternCall, variableMapping, this.variableBindings.get(negativePatternCall));
        this.operations.add(new NACOperation(information));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createCheck(Inequality inequality, Map<PVariable, Integer> variableMapping) {
        this.operations.add(new InequalityCheck(variableMapping.get(inequality.getWho()), variableMapping.get(inequality.getWithWhom())));
    }

    protected void createExtend(PositivePatternCall pCall, Map<PVariable, Integer> variableMapping) {
        CallInformation information = CallInformation.create(pCall, variableMapping, this.variableBindings.get(pCall));
        this.operations.add(new ExtendPositivePatternCall(information));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createExtend(BinaryTransitiveClosure binaryTransitiveClosure, Map<PVariable, Integer> variableMapping) {
        int sourcePosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(1));
        boolean sourceBound = this.variableBindings.get(binaryTransitiveClosure).contains(sourcePosition);
        boolean targetBound = this.variableBindings.get(binaryTransitiveClosure).contains(targetPosition);
        CallInformation information = CallInformation.create(binaryTransitiveClosure, variableMapping, this.variableBindings.get(binaryTransitiveClosure));
        if (sourceBound && !targetBound) {
            this.operations.add(new ExtendBinaryTransitiveClosure.Forward(information, sourcePosition, targetPosition, false));
            this.dependencies.add(information.getCallWithAdornment());
        } else if (!sourceBound && targetBound) {
            this.operations.add(new ExtendBinaryTransitiveClosure.Backward(information, sourcePosition, targetPosition, false));
            this.dependencies.add(information.getCallWithAdornment());
        } else {
            String msg = "Binary transitive closure not supported with two unbound parameters";
            throw new QueryProcessingException(msg, null, msg, (Object)binaryTransitiveClosure.getPSystem().getPattern());
        }
    }

    protected void createExtend(BinaryReflexiveTransitiveClosure binaryTransitiveClosure, Map<PVariable, Integer> variableMapping) {
        int sourcePosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(0));
        int targetPosition = variableMapping.get(binaryTransitiveClosure.getVariablesTuple().get(1));
        boolean sourceBound = this.variableBindings.get(binaryTransitiveClosure).contains(sourcePosition);
        boolean targetBound = this.variableBindings.get(binaryTransitiveClosure).contains(targetPosition);
        CallInformation information = CallInformation.create(binaryTransitiveClosure, variableMapping, this.variableBindings.get(binaryTransitiveClosure));
        if (sourceBound && !targetBound) {
            this.createUnaryTypeCheck(binaryTransitiveClosure.getUniverseType(), sourcePosition);
            this.operations.add(new ExtendBinaryTransitiveClosure.Forward(information, sourcePosition, targetPosition, true));
            this.dependencies.add(information.getCallWithAdornment());
        } else if (!sourceBound && targetBound) {
            this.createUnaryTypeCheck(binaryTransitiveClosure.getUniverseType(), targetPosition);
            this.operations.add(new ExtendBinaryTransitiveClosure.Backward(information, sourcePosition, targetPosition, true));
            this.dependencies.add(information.getCallWithAdornment());
        } else {
            String msg = "Binary reflective transitive closure not supported with two unbound parameters";
            throw new QueryProcessingException(msg, null, msg, (Object)binaryTransitiveClosure.getPSystem().getPattern());
        }
    }

    protected void createExtend(ConstantValue constant, Map<PVariable, Integer> variableMapping) {
        int position = variableMapping.get(constant.getVariablesTuple().get(0));
        this.operations.add(new ExtendConstant(position, constant.getSupplierKey()));
    }

    protected void createExtend(ExpressionEvaluation expressionEvaluation, Map<PVariable, Integer> variableMapping) {
        Iterable inputParameterNames = expressionEvaluation.getEvaluator().getInputParameterNames();
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        for (String pVariableName : inputParameterNames) {
            PVariable pVariable = expressionEvaluation.getPSystem().getVariableByNameChecked((Object)pVariableName);
            nameMap.put(pVariableName, variableMapping.get(pVariable));
        }
        if (expressionEvaluation.getOutputVariable() == null) {
            this.operations.add(new ExpressionCheck(expressionEvaluation.getEvaluator(), nameMap));
        } else {
            this.operations.add(new ExpressionEval(expressionEvaluation.getEvaluator(), nameMap, expressionEvaluation.isUnwinding(), variableMapping.get(expressionEvaluation.getOutputVariable())));
        }
    }

    protected void createExtend(AggregatorConstraint aggregator, Map<PVariable, Integer> variableMapping) {
        CallInformation information = CallInformation.create((PatternCallBasedDeferred)aggregator, variableMapping, this.variableBindings.get(aggregator));
        this.operations.add(new AggregatorExtend(information, aggregator, variableMapping.get(aggregator.getResultVariable())));
        this.dependencies.add(information.getCallWithAdornment());
    }

    protected void createExtend(PatternMatchCounter patternMatchCounter, Map<PVariable, Integer> variableMapping) {
        CallInformation information = CallInformation.create((PatternCallBasedDeferred)patternMatchCounter, variableMapping, this.variableBindings.get(patternMatchCounter));
        this.operations.add(new CountOperation(information, variableMapping.get(patternMatchCounter.getResultVariable())));
        this.dependencies.add(information.getCallWithAdornment());
    }
}

