/**
 * Copyright (c) 2010-2016, Gabor Bergmann, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.testing.core;

import com.google.common.base.Function;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;

/**
 * A variant of {@link QueryPerformanceTest}, where an ensemble of queries is measured together, instead of as individual queries.
 * 
 * @author Gabor Bergmann
 */
@SuppressWarnings("all")
public abstract class QueryGroupPerformanceTest extends QueryPerformanceTest {
  @Override
  public void measureEntireGroup() {
    final IQueryGroup group = this.getQueryGroup();
    final long usedHeapBefore = this.wipeAndMeasure();
    final Function<AdvancedViatraQueryEngine, ViatraQueryMatcher<?>> _function = (AdvancedViatraQueryEngine it) -> {
      group.prepare(it);
      return null;
    };
    this.performMeasurements("*group*", (-1), usedHeapBefore, _function);
  }
}
