/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.IObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.ISynchronizeProcessor;
import org.eclipse.wb.internal.core.databinding.model.SynchronizeManager;
import org.eclipse.wb.internal.core.databinding.model.presentation.JavaInfoObservePresentation;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.model.variable.ExposedFieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ExposedPropertyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.components.ComponentsObserveTypeContainer;
import org.eclipse.wb.internal.swing.databinding.model.components.JavaInfoReferenceProvider;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;

public class ComponentObserveInfo
extends ObserveInfo {
    private final BeanSupport m_beanSupport;
    private final ObserveInfo m_parent;
    private JavaInfo m_javaInfo;
    private List<ComponentObserveInfo> m_children;
    private List<ObserveInfo> m_properties;
    private final JavaInfoObservePresentation m_presentation;
    private ObserveCreationType m_creationType;

    public ComponentObserveInfo(BeanSupport beanSupport, JavaInfo javaInfo) throws Exception {
        this(beanSupport, null, javaInfo);
    }

    public ComponentObserveInfo(BeanSupport beanSupport, ObserveInfo parent, JavaInfo javaInfo) throws Exception {
        super(new ClassGenericType(javaInfo.getDescription().getComponentClass(), null, null), new JavaInfoReferenceProvider(javaInfo));
        this.m_beanSupport = beanSupport;
        this.m_parent = parent;
        this.m_javaInfo = javaInfo;
        this.m_presentation = new JavaInfoObservePresentation((ObjectInfo)this.m_javaInfo);
        this.m_creationType = ComponentsObserveTypeContainer.getCreationType(this.getObjectClass());
        if (JavaInfoReferenceProvider.getReference(this.m_javaInfo) == null) {
            this.m_properties = Collections.emptyList();
        }
    }

    public final ObserveType getType() {
        return ObserveType.WIDGETS;
    }

    @Override
    public ObserveCreationType getCreationType() {
        return this.m_creationType;
    }

    private void setJavaInfo(JavaInfo javaInfo) throws Exception {
        this.m_javaInfo = javaInfo;
        this.setObjectType(new ClassGenericType(javaInfo.getDescription().getComponentClass(), null, null));
        JavaInfoReferenceProvider referenceProvider = (JavaInfoReferenceProvider)this.getReferenceProvider();
        referenceProvider.setJavaInfo(this.m_javaInfo);
        this.m_presentation.setJavaInfo((ObjectInfo)this.m_javaInfo);
        this.m_creationType = ComponentsObserveTypeContainer.getCreationType(this.getObjectClass());
        this.m_properties = JavaInfoReferenceProvider.getReference(this.m_javaInfo) == null ? Collections.emptyList() : null;
    }

    public void update() throws Exception {
        List javaInfos = SynchronizeManager.getChildren((ObjectInfo)this.m_javaInfo, JavaInfo.class);
        this.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        SynchronizeManager.synchronizeObjects(this.m_children, (List)javaInfos, (ISynchronizeProcessor)new ISynchronizeProcessor<JavaInfo, ComponentObserveInfo>(){

            public boolean handleObject(ComponentObserveInfo object) {
                return true;
            }

            public JavaInfo getKeyObject(ComponentObserveInfo component) {
                return component.m_javaInfo;
            }

            public boolean equals(JavaInfo key0, JavaInfo key1) {
                return key0 == key1;
            }

            public ComponentObserveInfo findObject(Map<JavaInfo, ComponentObserveInfo> javaInfoToComponent, JavaInfo javaInfo) throws Exception {
                VariableSupport variableSupport = javaInfo.getVariableSupport();
                for (Map.Entry<JavaInfo, ComponentObserveInfo> entry : javaInfoToComponent.entrySet()) {
                    if (entry.getKey().getVariableSupport() != variableSupport) continue;
                    ComponentObserveInfo component = entry.getValue();
                    component.setJavaInfo(javaInfo);
                    return component;
                }
                return null;
            }

            public ComponentObserveInfo createObject(JavaInfo javaInfo) throws Exception {
                return new ComponentObserveInfo(ComponentObserveInfo.this.m_beanSupport, ComponentObserveInfo.this, javaInfo);
            }

            public void update(ComponentObserveInfo component) throws Exception {
                component.update();
            }
        });
    }

    @Override
    public void createBinding(BindingInfo binding) throws Exception {
        super.createBinding(binding);
        this.ensureConvertToField();
    }

    protected void ensureConvertToField() throws Exception {
        VariableSupport variableSupport = this.m_javaInfo.getVariableSupport();
        if (variableSupport.canConvertLocalToField()) {
            variableSupport.convertLocalToField();
        }
        if (variableSupport instanceof ExposedPropertyVariableSupport || variableSupport instanceof ExposedFieldVariableSupport) {
            ComponentObserveInfo parent = (ComponentObserveInfo)this.m_parent;
            parent.ensureConvertToField();
        }
    }

    public final IObserveInfo getParent() {
        return this.m_parent;
    }

    public final List<IObserveInfo> getChildren(IObserveInfo.ChildrenContext context) {
        if (context == IObserveInfo.ChildrenContext.ChildrenForMasterTable) {
            if (this.m_children == null) {
                try {
                    this.m_children = new ArrayList<ComponentObserveInfo>();
                    List childrenInfos = SynchronizeManager.getChildren((ObjectInfo)this.m_javaInfo, JavaInfo.class);
                    for (JavaInfo childInfo : childrenInfos) {
                        this.m_children.add(new ComponentObserveInfo(this.m_beanSupport, this, childInfo));
                    }
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                    this.m_children = Collections.emptyList();
                }
            }
            return CoreUtils.cast(this.m_children);
        }
        if (context == IObserveInfo.ChildrenContext.ChildrenForPropertiesTable) {
            if (this.m_properties == null) {
                this.m_properties = this.m_beanSupport.createProperties(this, this.getObjectType());
            }
            return CoreUtils.cast(this.m_properties);
        }
        return Collections.emptyList();
    }

    public ComponentObserveInfo resolve(Expression expression) throws Exception {
        if (AstNodeUtils.isVariable((ASTNode)expression) ? AstNodeUtils.getVariableName((ASTNode)expression).equals(JavaInfoReferenceProvider.getReference(this.m_javaInfo)) : this.m_javaInfo.isRepresentedBy((ASTNode)expression)) {
            return this;
        }
        this.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        for (ComponentObserveInfo child : this.m_children) {
            ComponentObserveInfo resultInfo = child.resolve(expression);
            if (resultInfo == null) continue;
            return resultInfo;
        }
        return null;
    }

    public ComponentObserveInfo resolve(JavaInfo javaInfo) throws Exception {
        if (this.m_javaInfo == javaInfo) {
            return this;
        }
        this.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        for (ComponentObserveInfo child : this.m_children) {
            ComponentObserveInfo resultInfo = child.resolve(javaInfo);
            if (resultInfo == null) continue;
            return resultInfo;
        }
        return null;
    }

    public ComponentObserveInfo resolve(String reference) throws Exception {
        if (reference.equals(this.getReference())) {
            return this;
        }
        this.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable);
        for (ComponentObserveInfo child : this.m_children) {
            ComponentObserveInfo resultInfo = child.resolve(reference);
            if (resultInfo == null) continue;
            return resultInfo;
        }
        return null;
    }

    public IObservePresentation getPresentation() {
        return this.m_presentation;
    }
}

