/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.reflect;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeFactory;

public class CachingReflectionTypeFactory
extends ReflectionTypeFactory {
    private static final Logger log = Logger.getLogger(CachingReflectionTypeFactory.class);
    private final ReflectionTypeFactory delegate;
    private final Map<Class<?>, JvmDeclaredType> typeCache = Maps.newHashMap();

    public CachingReflectionTypeFactory(ReflectionTypeFactory delegate) {
        super(delegate.getUriHelper());
        this.delegate = delegate;
    }

    @Override
    public JvmDeclaredType createType(Class<?> clazz) {
        try {
            JvmDeclaredType cachedResult = this.get(clazz);
            return (JvmDeclaredType)EcoreUtil2.cloneWithProxies((EObject)cachedResult);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return this.delegate.createType(clazz);
        }
    }

    private JvmDeclaredType get(Class<?> key) {
        JvmDeclaredType cachedResult = this.typeCache.get(key);
        if (cachedResult == null) {
            cachedResult = this.load(key);
            this.typeCache.put(key, cachedResult);
        }
        return cachedResult;
    }

    private JvmDeclaredType load(Class<?> key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Hit:" + key.getCanonicalName()));
        }
        return this.delegate.createType(key);
    }
}

