/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ContainerSpec;
import org.mandas.docker.client.messages.swarm.Driver;
import org.mandas.docker.client.messages.swarm.ImmutableTaskSpec;
import org.mandas.docker.client.messages.swarm.NetworkAttachmentConfig;
import org.mandas.docker.client.messages.swarm.Placement;
import org.mandas.docker.client.messages.swarm.ResourceRequirements;
import org.mandas.docker.client.messages.swarm.RestartPolicy;

@JsonDeserialize(builder=ImmutableTaskSpec.Builder.class)
@Value.Immutable
public interface TaskSpec {
    @JsonProperty(value="ContainerSpec")
    @Nullable
    public ContainerSpec containerSpec();

    @JsonProperty(value="Resources")
    @Nullable
    public ResourceRequirements resources();

    @JsonProperty(value="RestartPolicy")
    @Nullable
    public RestartPolicy restartPolicy();

    @JsonProperty(value="Placement")
    @Nullable
    public Placement placement();

    @JsonProperty(value="Networks")
    @Nullable
    public List<NetworkAttachmentConfig> networks();

    @JsonProperty(value="LogDriver")
    @Nullable
    public Driver logDriver();

    public static Builder builder() {
        return ImmutableTaskSpec.builder();
    }

    public static interface Builder {
        public Builder containerSpec(ContainerSpec var1);

        public Builder resources(ResourceRequirements var1);

        public Builder restartPolicy(RestartPolicy var1);

        public Builder placement(Placement var1);

        public Builder networks(NetworkAttachmentConfig ... var1);

        public Builder networks(Iterable<? extends NetworkAttachmentConfig> var1);

        public Builder logDriver(Driver var1);

        public TaskSpec build();
    }
}

