/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

public class Es6RewriteArrowFunction
extends NodeTraversal.AbstractPreOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final String ARGUMENTS_VAR = "$jscomp$arguments";
    private static final String THIS_VAR = "$jscomp$this";

    public Es6RewriteArrowFunction(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                if (!n.isArrowFunction()) break;
                this.visitArrowFunction(t, n);
            }
        }
        return true;
    }

    private void visitArrowFunction(NodeTraversal t, Node n) {
        n.setIsArrowFunction(false);
        n.makeNonIndexable();
        Node body = n.getLastChild();
        if (!body.isBlock()) {
            body.detachFromParent();
            body = IR.block(IR.returnNode(body)).useSourceInfoIfMissingFromForTree(body);
            n.addChildToBack(body);
        }
        UpdateThisAndArgumentsReferences updater = new UpdateThisAndArgumentsReferences();
        NodeTraversal.traverseEs6(this.compiler, body, updater);
        this.addVarDecls(t, updater.changedThis, updater.changedArguments);
        this.compiler.reportCodeChange();
    }

    private void addVarDecls(NodeTraversal t, boolean addThis, boolean addArguments) {
        Node name;
        Node scopeRoot;
        Scope scope = t.getScope().getClosestHoistScope();
        if (scope.isDeclared(THIS_VAR, false)) {
            addThis = false;
        }
        if (scope.isDeclared(ARGUMENTS_VAR, false)) {
            addArguments = false;
        }
        if ((scopeRoot = scope.getRootNode()).isSyntheticBlock() && scopeRoot.getFirstChild().isScript()) {
            scopeRoot = scopeRoot.getFirstChild();
        }
        CompilerInput input = this.compiler.getInput(scopeRoot.getInputId());
        if (addArguments) {
            name = IR.name(ARGUMENTS_VAR);
            Node argumentsVar = IR.constNode(name, IR.name("arguments"));
            JSDocInfoBuilder jsdoc = new JSDocInfoBuilder(false);
            jsdoc.recordType(new JSTypeExpression(new Node(306, IR.string("Arguments")), "<Es6RewriteArrowFunction>"));
            argumentsVar.setJSDocInfo(jsdoc.build());
            argumentsVar.useSourceInfoIfMissingFromForTree(scopeRoot);
            scopeRoot.addChildToFront(argumentsVar);
            scope.declare(ARGUMENTS_VAR, name, input);
        }
        if (addThis) {
            name = IR.name(THIS_VAR);
            Node thisVar = IR.constNode(name, IR.thisNode());
            thisVar.useSourceInfoIfMissingFromForTree(scopeRoot);
            scopeRoot.addChildToFront(thisVar);
            scope.declare(THIS_VAR, name, input);
        }
    }

    private static class UpdateThisAndArgumentsReferences
    implements NodeTraversal.Callback {
        private boolean changedThis = false;
        private boolean changedArguments = false;

        private UpdateThisAndArgumentsReferences() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                Node name = IR.name(Es6RewriteArrowFunction.THIS_VAR).srcref(n);
                parent.replaceChild(n, name);
                this.changedThis = true;
            } else if (n.isName() && n.getString().equals("arguments")) {
                Node name = IR.name(Es6RewriteArrowFunction.ARGUMENTS_VAR).srcref(n);
                parent.replaceChild(n, name);
                this.changedArguments = true;
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction() || n.isArrowFunction();
        }
    }
}

