/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm;

import io.github.toolfactory.jvm.Driver;
import io.github.toolfactory.jvm.Info;
import io.github.toolfactory.jvm.function.catalog.AllocateInstanceFunction;
import io.github.toolfactory.jvm.function.catalog.BuiltinClassLoaderClassSupplier;
import io.github.toolfactory.jvm.function.catalog.ClassLoaderDelegateClassSupplier;
import io.github.toolfactory.jvm.function.catalog.ConstructorInvokeFunction;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.ConvertToBuiltinClassLoaderFunction;
import io.github.toolfactory.jvm.function.catalog.DeepConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.DefineHookClassFunction;
import io.github.toolfactory.jvm.function.catalog.GetClassByNameFunction;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredConstructorsFunction;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldsFunction;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredMethodsFunction;
import io.github.toolfactory.jvm.function.catalog.GetFieldValueFunction;
import io.github.toolfactory.jvm.function.catalog.GetLoadedClassesRetrieverFunction;
import io.github.toolfactory.jvm.function.catalog.GetLoadedPackagesFunction;
import io.github.toolfactory.jvm.function.catalog.GetPackageFunction;
import io.github.toolfactory.jvm.function.catalog.GetResourcesFunction;
import io.github.toolfactory.jvm.function.catalog.MethodInvokeFunction;
import io.github.toolfactory.jvm.function.catalog.SetAccessibleFunction;
import io.github.toolfactory.jvm.function.catalog.SetFieldValueFunction;
import io.github.toolfactory.jvm.function.catalog.StopThreadFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.function.template.Supplier;
import io.github.toolfactory.jvm.function.template.ThrowingBiConsumer;
import io.github.toolfactory.jvm.function.template.ThrowingBiFunction;
import io.github.toolfactory.jvm.function.template.ThrowingFunction;
import io.github.toolfactory.jvm.function.template.ThrowingQuadFunction;
import io.github.toolfactory.jvm.function.template.ThrowingTriFunction;
import io.github.toolfactory.jvm.function.template.TriConsumer;
import io.github.toolfactory.jvm.util.CleanableSupplier;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class DriverAbst
implements Driver {
    protected ThrowExceptionFunction exceptionThrower;
    protected ThrowingFunction<Class<?>, Object, Throwable> allocateInstanceInvoker;
    protected BiFunction<Object, Field, Object> fieldValueRetriever;
    protected TriConsumer<Object, Field, Object> fieldValueSetter;
    protected ThrowingBiFunction<Class<?>, byte[], Class<?>, Throwable> hookClassDefiner;
    protected ThrowingFunction<Class<?>, MethodHandles.Lookup, Throwable> consulterRetriever;
    protected ThrowingFunction<Class<?>, Field[], Throwable> declaredFieldsRetriever;
    protected ThrowingFunction<Class<?>, Method[], Throwable> declaredMethodsRetriever;
    protected ThrowingFunction<Class<?>, Constructor<?>[], Throwable> declaredConstructorsRetriever;
    protected ThrowingBiConsumer<AccessibleObject, Boolean, Throwable> accessibleSetter;
    protected ThrowingBiFunction<Constructor<?>, Object[], Object, Throwable> constructorInvoker;
    protected ThrowingBiFunction<ClassLoader, String, Package, Throwable> packageRetriever;
    protected ThrowingTriFunction<Method, Object, Object[], Object, Throwable> methodInvoker;
    protected ThrowingQuadFunction<String, Boolean, ClassLoader, Class<?>, Class<?>, Throwable> classByNameRetriever;
    protected GetResourcesFunction resourcesRetriver;
    protected Supplier<Class<?>> builtinClassLoaderClassSupplier;
    protected Supplier<Class<?>> classLoaderDelegateClassSupplier;
    protected Function<ClassLoader, CleanableSupplier<Collection<Class<?>>>> loadedClassesRetrieverSupplier;
    protected Function<ClassLoader, Map<String, ?>> loadedPackagesRetriever;
    protected ThrowingFunction<ClassLoader, ClassLoader, Throwable> classLoaderToBuiltinClassLoaderConverter;
    protected ThrowingBiConsumer<Thread, Throwable, Throwable> threadStopper;

    @Override
    public <D extends Driver> D init() {
        Map<Object, Object> initializationContext = this.functionsToMap();
        try {
            if (this.exceptionThrower == null) {
                this.exceptionThrower = this.getOrBuildExceptionThrower(initializationContext);
            }
            if (this.allocateInstanceInvoker == null) {
                this.allocateInstanceInvoker = this.getOrBuildAllocateInstanceInvoker(initializationContext);
            }
            if (this.fieldValueRetriever == null) {
                this.fieldValueRetriever = this.getOrBuildFieldValueRetriever(initializationContext);
            }
            if (this.fieldValueSetter == null) {
                this.fieldValueSetter = this.getOrBuildFieldValueSetter(initializationContext);
            }
            if (this.hookClassDefiner == null) {
                this.hookClassDefiner = this.getOrBuildHookClassDefiner(initializationContext);
            }
            if (this.declaredFieldsRetriever == null) {
                this.declaredFieldsRetriever = this.getOrBuildDeclaredFieldsRetriever(initializationContext);
            }
            if (this.declaredMethodsRetriever == null) {
                this.declaredMethodsRetriever = this.getOrBuildDeclaredMethodsRetriever(initializationContext);
            }
            if (this.declaredConstructorsRetriever == null) {
                this.declaredConstructorsRetriever = this.getOrBuildDeclaredConstructorsRetriever(initializationContext);
            }
            if (this.accessibleSetter == null) {
                this.accessibleSetter = this.getOrBuildAccessibleSetter(initializationContext);
            }
            if (this.constructorInvoker == null) {
                this.constructorInvoker = this.getOrBuildConstructorInvoker(initializationContext);
            }
            if (this.methodInvoker == null) {
                this.methodInvoker = this.getOrBuildMethodInvoker(initializationContext);
            }
            if (this.packageRetriever == null) {
                this.packageRetriever = this.getOrBuildPackageRetriever(initializationContext);
            }
            if (this.classByNameRetriever == null) {
                this.classByNameRetriever = this.getOrBuildClassByNameRetriever(initializationContext);
            }
            if (this.resourcesRetriver == null) {
                this.resourcesRetriver = this.getOrBuildResourcesRetriever(initializationContext);
            }
            if (this.builtinClassLoaderClassSupplier == null) {
                this.builtinClassLoaderClassSupplier = this.getOrBuildBuiltinClassLoaderClassSupplier(initializationContext);
            }
            if (this.classLoaderDelegateClassSupplier == null) {
                this.classLoaderDelegateClassSupplier = this.getOrBuildClassLoaderDelegateClassSupplier(initializationContext);
            }
            if (this.consulterRetriever == null) {
                this.consulterRetriever = this.getOrBuildDeepConsulterRetriever(initializationContext);
            }
            if (this.loadedClassesRetrieverSupplier == null) {
                this.loadedClassesRetrieverSupplier = this.getOrBuildLoadedClassesRetrieverFunction(initializationContext);
            }
            if (this.loadedPackagesRetriever == null) {
                this.loadedPackagesRetriever = this.getOrBuildLoadedPackagesRetriever(initializationContext);
            }
            if (this.classLoaderToBuiltinClassLoaderConverter == null) {
                this.classLoaderToBuiltinClassLoaderConverter = this.getOrBuildClassLoaderToBuiltinClassLoaderConverter(initializationContext);
            }
            if (this.threadStopper == null) {
                this.threadStopper = this.getOrBuildThreadStopper(initializationContext);
            }
        }
        catch (Throwable exc) {
            this.throwException(new Driver.InitializeException("Could not initialize " + this.getClass().getSimpleName(), exc));
        }
        return (D)this;
    }

    protected <D extends Driver> D refresh(Map<Object, Object> initializationContext) {
        try {
            if (this.exceptionThrower == null) {
                this.exceptionThrower = this.getExceptionThrower(initializationContext);
            }
            if (this.allocateInstanceInvoker == null) {
                this.allocateInstanceInvoker = this.getAllocateInstanceInvoker(initializationContext);
            }
            if (this.fieldValueRetriever == null) {
                this.fieldValueRetriever = this.getFieldValueRetriever(initializationContext);
            }
            if (this.fieldValueSetter == null) {
                this.fieldValueSetter = this.getFieldValueSetter(initializationContext);
            }
            if (this.hookClassDefiner == null) {
                this.hookClassDefiner = this.getHookClassDefiner(initializationContext);
            }
            if (this.declaredFieldsRetriever == null) {
                this.declaredFieldsRetriever = this.getDeclaredFieldsRetriever(initializationContext);
            }
            if (this.declaredMethodsRetriever == null) {
                this.declaredMethodsRetriever = this.getDeclaredMethodsRetriever(initializationContext);
            }
            if (this.declaredConstructorsRetriever == null) {
                this.declaredConstructorsRetriever = this.getDeclaredConstructorsRetriever(initializationContext);
            }
            if (this.accessibleSetter == null) {
                this.accessibleSetter = this.getAccessibleSetter(initializationContext);
            }
            if (this.constructorInvoker == null) {
                this.constructorInvoker = this.getConstructorInvoker(initializationContext);
            }
            if (this.methodInvoker == null) {
                this.methodInvoker = this.getMethodInvoker(initializationContext);
            }
            if (this.packageRetriever == null) {
                this.packageRetriever = this.getPackageRetriever(initializationContext);
            }
            if (this.classByNameRetriever == null) {
                this.classByNameRetriever = this.getOrBuildClassByNameRetriever(initializationContext);
            }
            if (this.resourcesRetriver == null) {
                this.resourcesRetriver = this.getOrBuildResourcesRetriever(initializationContext);
            }
            if (this.builtinClassLoaderClassSupplier == null) {
                this.builtinClassLoaderClassSupplier = this.getBuiltinClassLoaderClassSupplier(initializationContext);
            }
            if (this.classLoaderDelegateClassSupplier == null) {
                this.classLoaderDelegateClassSupplier = this.getClassLoaderDelegateClassSupplier(initializationContext);
            }
            if (this.consulterRetriever == null) {
                this.consulterRetriever = this.getDeepConsulterRetriever(initializationContext);
            }
            if (this.loadedClassesRetrieverSupplier == null) {
                this.loadedClassesRetrieverSupplier = this.getLoadedClassesRetrieverFunction(initializationContext);
            }
            if (this.loadedPackagesRetriever == null) {
                this.loadedPackagesRetriever = this.getLoadedPackagesRetriever(initializationContext);
            }
            if (this.classLoaderToBuiltinClassLoaderConverter == null) {
                this.classLoaderToBuiltinClassLoaderConverter = this.getClassLoaderToBuiltinClassLoaderConverter(initializationContext);
            }
            if (this.threadStopper == null) {
                this.threadStopper = this.getThreadStopper(initializationContext);
            }
            this.putNewObjectProviderIfAbsent(initializationContext);
        }
        catch (Throwable exc) {
            this.throwException(new Driver.InitializeException("Could not initialize " + this.getClass().getSimpleName(), exc));
        }
        return (D)this;
    }

    protected Map<Object, Object> functionsToMap() {
        HashMap<Object, Object> initializationContext = new HashMap<Object, Object>();
        this.putIfNotNull(initializationContext, this.getThrowExceptionFunctionClass(), this.exceptionThrower);
        this.putIfNotNull(initializationContext, this.getAllocateInstanceFunctionClass(), this.allocateInstanceInvoker);
        this.putIfNotNull(initializationContext, this.getGetFieldValueFunctionClass(), this.fieldValueRetriever);
        this.putIfNotNull(initializationContext, this.getSetFieldValueFunctionClass(), this.fieldValueSetter);
        this.putIfNotNull(initializationContext, this.getDefineHookClassFunctionClass(), this.hookClassDefiner);
        this.putIfNotNull(initializationContext, this.getGetDeclaredFieldsFunctionClass(), this.declaredFieldsRetriever);
        this.putIfNotNull(initializationContext, this.getGetDeclaredMethodsFunctionClass(), this.declaredMethodsRetriever);
        this.putIfNotNull(initializationContext, this.getGetDeclaredConstructorsFunctionClass(), this.declaredConstructorsRetriever);
        this.putIfNotNull(initializationContext, this.getSetAccessibleFunctionClass(), this.accessibleSetter);
        this.putIfNotNull(initializationContext, this.getConstructorInvokeFunctionClass(), this.constructorInvoker);
        this.putIfNotNull(initializationContext, this.getMethodInvokeFunctionClass(), this.methodInvoker);
        this.putIfNotNull(initializationContext, this.getGetPackageFunctionClass(), this.packageRetriever);
        this.putIfNotNull(initializationContext, this.getGetClassByNameFunctionClass(), this.classByNameRetriever);
        this.putIfNotNull(initializationContext, this.getGetResourcesFunctionClass(), this.resourcesRetriver);
        this.putIfNotNull(initializationContext, this.getBuiltinClassLoaderClassSupplierClass(), this.builtinClassLoaderClassSupplier);
        this.putIfNotNull(initializationContext, this.getClassLoaderDelegateClassSupplierClass(), this.classLoaderDelegateClassSupplier);
        this.putIfNotNull(initializationContext, this.getDeepConsulterSupplyFunctionClass(), this.consulterRetriever);
        this.putIfNotNull(initializationContext, this.getGetLoadedClassesRetrieverFunctionClass(), this.loadedClassesRetrieverSupplier);
        this.putIfNotNull(initializationContext, this.getGetLoadedPackagesFunctionClass(), this.loadedPackagesRetriever);
        this.putIfNotNull(initializationContext, this.getConvertToBuiltinClassLoaderFunctionClass(), this.classLoaderToBuiltinClassLoaderConverter);
        this.putIfNotNull(initializationContext, this.getStopThreadFunctionClass(), this.threadStopper);
        this.putNewObjectProviderIfAbsent(initializationContext);
        return initializationContext;
    }

    protected ObjectProvider putNewObjectProviderIfAbsent(Map<Object, Object> context) {
        ObjectProvider.putIfAbsent(context, new Supplier<ObjectProvider>(){

            @Override
            public ObjectProvider get() {
                return new ObjectProvider(Info.CRITICAL_VERSIONS);
            }
        });
        return ObjectProvider.get(context);
    }

    protected abstract Class<? extends ThrowExceptionFunction> getThrowExceptionFunctionClass();

    protected abstract Class<? extends AllocateInstanceFunction> getAllocateInstanceFunctionClass();

    protected abstract Class<? extends GetFieldValueFunction> getGetFieldValueFunctionClass();

    protected abstract Class<? extends SetFieldValueFunction> getSetFieldValueFunctionClass();

    protected abstract Class<? extends DefineHookClassFunction> getDefineHookClassFunctionClass();

    protected abstract Class<? extends ConsulterSupplyFunction> getConsulterSupplyFunctionClass();

    protected abstract Class<? extends GetDeclaredFieldsFunction> getGetDeclaredFieldsFunctionClass();

    protected abstract Class<? extends GetDeclaredMethodsFunction> getGetDeclaredMethodsFunctionClass();

    protected abstract Class<? extends GetDeclaredConstructorsFunction> getGetDeclaredConstructorsFunctionClass();

    protected abstract Class<? extends SetAccessibleFunction> getSetAccessibleFunctionClass();

    protected abstract Class<? extends ConstructorInvokeFunction> getConstructorInvokeFunctionClass();

    protected abstract Class<? extends MethodInvokeFunction> getMethodInvokeFunctionClass();

    protected abstract Class<? extends GetPackageFunction> getGetPackageFunctionClass();

    protected abstract Class<? extends GetClassByNameFunction> getGetClassByNameFunctionClass();

    protected abstract Class<? extends GetResourcesFunction> getGetResourcesFunctionClass();

    protected abstract Class<? extends BuiltinClassLoaderClassSupplier> getBuiltinClassLoaderClassSupplierClass();

    protected abstract Class<? extends ClassLoaderDelegateClassSupplier> getClassLoaderDelegateClassSupplierClass();

    protected abstract Class<? extends DeepConsulterSupplyFunction> getDeepConsulterSupplyFunctionClass();

    protected abstract Class<? extends GetLoadedClassesRetrieverFunction> getGetLoadedClassesRetrieverFunctionClass();

    protected abstract Class<? extends GetLoadedPackagesFunction> getGetLoadedPackagesFunctionClass();

    protected abstract Class<? extends ConvertToBuiltinClassLoaderFunction> getConvertToBuiltinClassLoaderFunctionClass();

    protected abstract Class<? extends StopThreadFunction> getStopThreadFunctionClass();

    protected ThrowExceptionFunction getOrBuildExceptionThrower(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getThrowExceptionFunctionClass(), initializationContext);
    }

    protected AllocateInstanceFunction getOrBuildAllocateInstanceInvoker(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getAllocateInstanceFunctionClass(), initializationContext);
    }

    protected GetFieldValueFunction getOrBuildFieldValueRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetFieldValueFunctionClass(), initializationContext);
    }

    protected SetFieldValueFunction getOrBuildFieldValueSetter(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getSetFieldValueFunctionClass(), initializationContext);
    }

    protected DefineHookClassFunction getOrBuildHookClassDefiner(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getDefineHookClassFunctionClass(), initializationContext);
    }

    protected ConsulterSupplyFunction getOrBuildConsulterRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getConsulterSupplyFunctionClass(), initializationContext);
    }

    protected GetDeclaredFieldsFunction getOrBuildDeclaredFieldsRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetDeclaredFieldsFunctionClass(), initializationContext);
    }

    protected GetDeclaredMethodsFunction getOrBuildDeclaredMethodsRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetDeclaredMethodsFunctionClass(), initializationContext);
    }

    protected GetDeclaredConstructorsFunction getOrBuildDeclaredConstructorsRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetDeclaredConstructorsFunctionClass(), initializationContext);
    }

    protected SetAccessibleFunction getOrBuildAccessibleSetter(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getSetAccessibleFunctionClass(), initializationContext);
    }

    protected ConstructorInvokeFunction getOrBuildConstructorInvoker(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getConstructorInvokeFunctionClass(), initializationContext);
    }

    protected MethodInvokeFunction getOrBuildMethodInvoker(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getMethodInvokeFunctionClass(), initializationContext);
    }

    protected GetPackageFunction getOrBuildPackageRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetPackageFunctionClass(), initializationContext);
    }

    protected GetClassByNameFunction getOrBuildClassByNameRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetClassByNameFunctionClass(), initializationContext);
    }

    protected GetResourcesFunction getOrBuildResourcesRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetResourcesFunctionClass(), initializationContext);
    }

    protected BuiltinClassLoaderClassSupplier getOrBuildBuiltinClassLoaderClassSupplier(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getBuiltinClassLoaderClassSupplierClass(), initializationContext);
    }

    protected ClassLoaderDelegateClassSupplier getOrBuildClassLoaderDelegateClassSupplier(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getClassLoaderDelegateClassSupplierClass(), initializationContext);
    }

    protected DeepConsulterSupplyFunction getOrBuildDeepConsulterRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getDeepConsulterSupplyFunctionClass(), initializationContext);
    }

    protected GetLoadedClassesRetrieverFunction getOrBuildLoadedClassesRetrieverFunction(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetLoadedClassesRetrieverFunctionClass(), initializationContext);
    }

    protected GetLoadedPackagesFunction getOrBuildLoadedPackagesRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getGetLoadedPackagesFunctionClass(), initializationContext);
    }

    protected ConvertToBuiltinClassLoaderFunction getOrBuildClassLoaderToBuiltinClassLoaderConverter(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getConvertToBuiltinClassLoaderFunctionClass(), initializationContext);
    }

    protected StopThreadFunction getOrBuildThreadStopper(Map<Object, Object> initializationContext) {
        return ObjectProvider.get(initializationContext).getOrBuildObject(this.getStopThreadFunctionClass(), initializationContext);
    }

    protected ThrowExceptionFunction getExceptionThrower(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getThrowExceptionFunctionClass(), initializationContext);
    }

    protected AllocateInstanceFunction getAllocateInstanceInvoker(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getAllocateInstanceFunctionClass(), initializationContext);
    }

    protected GetFieldValueFunction getFieldValueRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetFieldValueFunctionClass(), initializationContext);
    }

    protected SetFieldValueFunction getFieldValueSetter(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getSetFieldValueFunctionClass(), initializationContext);
    }

    protected DefineHookClassFunction getHookClassDefiner(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getDefineHookClassFunctionClass(), initializationContext);
    }

    protected ConsulterSupplyFunction getConsulterRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getConsulterSupplyFunctionClass(), initializationContext);
    }

    protected GetDeclaredFieldsFunction getDeclaredFieldsRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetDeclaredFieldsFunctionClass(), initializationContext);
    }

    protected GetDeclaredMethodsFunction getDeclaredMethodsRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetDeclaredMethodsFunctionClass(), initializationContext);
    }

    protected GetDeclaredConstructorsFunction getDeclaredConstructorsRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetDeclaredConstructorsFunctionClass(), initializationContext);
    }

    protected SetAccessibleFunction getAccessibleSetter(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getSetAccessibleFunctionClass(), initializationContext);
    }

    protected ConstructorInvokeFunction getConstructorInvoker(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getConstructorInvokeFunctionClass(), initializationContext);
    }

    protected MethodInvokeFunction getMethodInvoker(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getMethodInvokeFunctionClass(), initializationContext);
    }

    protected GetPackageFunction getPackageRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetPackageFunctionClass(), initializationContext);
    }

    protected GetClassByNameFunction getClassByNameRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetClassByNameFunctionClass(), initializationContext);
    }

    protected GetResourcesFunction getResourcesRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetResourcesFunctionClass(), initializationContext);
    }

    protected BuiltinClassLoaderClassSupplier getBuiltinClassLoaderClassSupplier(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getBuiltinClassLoaderClassSupplierClass(), initializationContext);
    }

    protected ClassLoaderDelegateClassSupplier getClassLoaderDelegateClassSupplier(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getClassLoaderDelegateClassSupplierClass(), initializationContext);
    }

    protected DeepConsulterSupplyFunction getDeepConsulterRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getDeepConsulterSupplyFunctionClass(), initializationContext);
    }

    protected GetLoadedClassesRetrieverFunction getLoadedClassesRetrieverFunction(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetLoadedClassesRetrieverFunctionClass(), initializationContext);
    }

    protected GetLoadedPackagesFunction getLoadedPackagesRetriever(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getGetLoadedPackagesFunctionClass(), initializationContext);
    }

    protected ConvertToBuiltinClassLoaderFunction getClassLoaderToBuiltinClassLoaderConverter(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getConvertToBuiltinClassLoaderFunctionClass(), initializationContext);
    }

    protected StopThreadFunction getThreadStopper(Map<Object, Object> initializationContext) {
        return ObjectProvider.getObject(this.getStopThreadFunctionClass(), initializationContext);
    }

    protected void putIfNotNull(Map<Object, Object> map, Class<?> cls, Object object) {
        if (object != null) {
            map.put(cls.getName(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T throwException(Throwable exception) {
        ThrowExceptionFunction exceptionThrower = this.exceptionThrower;
        try {
            return exceptionThrower.apply(exception);
        }
        catch (NullPointerException exc) {
            if (exceptionThrower != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.exceptionThrower == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.exceptionThrower = this.getOrBuildExceptionThrower(initContext);
                    this.refresh(initContext);
                }
            }
            return this.exceptionThrower.apply(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T throwException(String message, Object ... placeHolderReplacements) {
        ThrowExceptionFunction exceptionThrower = this.exceptionThrower;
        try {
            return exceptionThrower.apply(3, message, placeHolderReplacements);
        }
        catch (NullPointerException exc) {
            if (exceptionThrower != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.exceptionThrower == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.exceptionThrower = this.getOrBuildExceptionThrower(initContext);
                    this.refresh(initContext);
                }
            }
            return this.exceptionThrower.apply(3, message, placeHolderReplacements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccessible(AccessibleObject object, boolean flag) {
        try {
            ThrowingBiConsumer<AccessibleObject, Boolean, Throwable> accessibleSetter = this.accessibleSetter;
            try {
                accessibleSetter.accept(object, flag);
            }
            catch (NullPointerException exc) {
                if (accessibleSetter != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.accessibleSetter == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.accessibleSetter = this.getOrBuildAccessibleSetter(initContext);
                        this.refresh(initContext);
                    }
                }
                this.accessibleSetter.accept(object, flag);
            }
        }
        catch (Throwable exc) {
            this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> defineHookClass(Class<?> clientClass, byte[] byteCode) {
        try {
            ThrowingBiFunction<Class<?>, byte[], Class<?>, Throwable> hookClassDefiner = this.hookClassDefiner;
            try {
                return hookClassDefiner.apply(clientClass, byteCode);
            }
            catch (NullPointerException exc) {
                if (hookClassDefiner != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.hookClassDefiner == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.hookClassDefiner = this.getOrBuildHookClassDefiner(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.hookClassDefiner.apply(clientClass, byteCode);
            }
        }
        catch (Throwable exc) {
            return (Class)this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(ClassLoader classLoader, String packageName) {
        try {
            ThrowingBiFunction<ClassLoader, String, Package, Throwable> packageRetriever = this.packageRetriever;
            try {
                return packageRetriever.apply(classLoader, packageName);
            }
            catch (NullPointerException exc) {
                if (packageRetriever != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.packageRetriever == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.packageRetriever = this.getOrBuildPackageRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.packageRetriever.apply(classLoader, packageName);
            }
        }
        catch (Throwable exc) {
            return (Package)this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CleanableSupplier<Collection<Class<?>>> getLoadedClassesRetriever(ClassLoader classLoader) {
        Function<ClassLoader, CleanableSupplier<Collection<Class<?>>>> loadedClassesRetrieverSupplier = this.loadedClassesRetrieverSupplier;
        try {
            return loadedClassesRetrieverSupplier.apply(classLoader);
        }
        catch (NullPointerException exc) {
            if (loadedClassesRetrieverSupplier != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.loadedClassesRetrieverSupplier == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.loadedClassesRetrieverSupplier = this.getOrBuildLoadedClassesRetrieverFunction(initContext);
                    this.refresh(initContext);
                }
            }
            return this.loadedClassesRetrieverSupplier.apply(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> retrieveLoadedPackages(ClassLoader classLoader) {
        Function<ClassLoader, Map<String, ?>> loadedPackagesRetriever = this.loadedPackagesRetriever;
        try {
            return loadedPackagesRetriever.apply(classLoader);
        }
        catch (NullPointerException exc) {
            if (loadedPackagesRetriever != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.loadedPackagesRetriever == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.loadedPackagesRetriever = this.getOrBuildLoadedPackagesRetriever(initContext);
                    this.refresh(initContext);
                }
            }
            return this.loadedPackagesRetriever.apply(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getFieldValue(Object target, Field field) {
        BiFunction<Object, Field, Object> fieldValueRetriever = this.fieldValueRetriever;
        if (target == null && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Target cannot be null when the field is not static");
        }
        try {
            return (T)fieldValueRetriever.apply(target, field);
        }
        catch (NullPointerException exc) {
            if (fieldValueRetriever != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.fieldValueRetriever == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.fieldValueRetriever = this.getOrBuildFieldValueRetriever(initContext);
                    this.refresh(initContext);
                }
            }
            return (T)this.fieldValueRetriever.apply(target, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFieldValue(Object target, Field field, Object value) {
        TriConsumer<Object, Field, Object> fieldValueSetter = this.fieldValueSetter;
        if (target == null && !Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("Target cannot be null when the field is not static");
        }
        try {
            fieldValueSetter.accept(target, field, value);
        }
        catch (NullPointerException exc) {
            if (fieldValueSetter != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.fieldValueSetter == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.fieldValueSetter = this.getOrBuildFieldValueSetter(initContext);
                    this.refresh(initContext);
                }
            }
            this.fieldValueSetter.accept(target, field, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T allocateInstance(Class<?> cls) {
        try {
            ThrowingFunction<Class<?>, Object, Throwable> allocateInstanceInvoker = this.allocateInstanceInvoker;
            try {
                return (T)allocateInstanceInvoker.apply(cls);
            }
            catch (NullPointerException exc) {
                if (allocateInstanceInvoker != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.allocateInstanceInvoker == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.allocateInstanceInvoker = this.getOrBuildAllocateInstanceInvoker(initContext);
                        this.refresh(initContext);
                    }
                }
                return (T)this.allocateInstanceInvoker.apply(cls);
            }
        }
        catch (Throwable exc) {
            return this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getClassByName(String className, Boolean initialize, ClassLoader classLoader, Class<?> caller) {
        try {
            ThrowingQuadFunction<String, Boolean, ClassLoader, Class<?>, Class<?>, Throwable> classByNameRetriever = this.classByNameRetriever;
            try {
                return classByNameRetriever.apply(className, initialize, classLoader, caller);
            }
            catch (NullPointerException exc) {
                if (classByNameRetriever != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.classByNameRetriever == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.classByNameRetriever = this.getOrBuildClassByNameRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.classByNameRetriever.apply(className, initialize, classLoader, caller);
            }
        }
        catch (Throwable exc) {
            return (Class)this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<URL> getResources(String resourceRelativePath, boolean findFirst, ClassLoader ... classLoaders) {
        try {
            GetResourcesFunction resourcesRetriver = this.resourcesRetriver;
            try {
                return (Collection)resourcesRetriver.apply(resourceRelativePath, findFirst, classLoaders);
            }
            catch (NullPointerException exc) {
                if (resourcesRetriver != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.resourcesRetriver == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.resourcesRetriver = this.getOrBuildResourcesRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return (Collection)this.resourcesRetriver.apply(resourceRelativePath, findFirst, classLoaders);
            }
        }
        catch (Throwable exc) {
            return (Collection)this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<URL> getResources(String resourceRelativePath, boolean findFirst, Collection<ClassLoader> classLoaders) {
        try {
            GetResourcesFunction resourcesRetriver = this.resourcesRetriver;
            try {
                return resourcesRetriver.apply(resourceRelativePath, findFirst, classLoaders);
            }
            catch (NullPointerException exc) {
                if (resourcesRetriver != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.resourcesRetriver == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.resourcesRetriver = this.getOrBuildResourcesRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.resourcesRetriver.apply(resourceRelativePath, findFirst, classLoaders);
            }
        }
        catch (Throwable exc) {
            return (Collection)this.throwException(exc);
        }
    }

    @Override
    public boolean isBuiltinClassLoader(ClassLoader classLoader) {
        Class<?> builtinClassLoaderClass = this.getBuiltinClassLoaderClass();
        return builtinClassLoaderClass != null && builtinClassLoaderClass.isAssignableFrom(classLoader.getClass());
    }

    @Override
    public boolean isClassLoaderDelegate(ClassLoader classLoader) {
        Class<?> classLoaderDelegateClass = this.getClassLoaderDelegateClass();
        return classLoaderDelegateClass != null && classLoaderDelegateClass.isAssignableFrom(classLoader.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getBuiltinClassLoaderClass() {
        Supplier<Class<?>> builtinClassLoaderClassSupplier = this.builtinClassLoaderClassSupplier;
        try {
            return builtinClassLoaderClassSupplier.get();
        }
        catch (NullPointerException exc) {
            if (builtinClassLoaderClassSupplier != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.builtinClassLoaderClassSupplier == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.builtinClassLoaderClassSupplier = this.getOrBuildBuiltinClassLoaderClassSupplier(initContext);
                    this.refresh(initContext);
                }
            }
            return this.builtinClassLoaderClassSupplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getClassLoaderDelegateClass() {
        Supplier<Class<?>> classLoaderDelegateClassSupplier = this.classLoaderDelegateClassSupplier;
        try {
            return classLoaderDelegateClassSupplier.get();
        }
        catch (NullPointerException exc) {
            if (classLoaderDelegateClassSupplier != null) {
                throw exc;
            }
            DriverAbst driverAbst = this;
            synchronized (driverAbst) {
                if (this.classLoaderDelegateClassSupplier == null) {
                    Map<Object, Object> initContext = this.functionsToMap();
                    this.classLoaderDelegateClassSupplier = this.getOrBuildClassLoaderDelegateClassSupplier(initContext);
                    this.refresh(initContext);
                }
            }
            return this.classLoaderDelegateClassSupplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodHandles.Lookup getConsulter(Class<?> cls) {
        try {
            ThrowingFunction<Class<?>, MethodHandles.Lookup, Throwable> consulterRetriever = this.consulterRetriever;
            try {
                return consulterRetriever.apply(cls);
            }
            catch (NullPointerException exc) {
                if (consulterRetriever != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.consulterRetriever == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.consulterRetriever = this.getOrBuildDeepConsulterRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.consulterRetriever.apply(cls);
            }
        }
        catch (Throwable exc) {
            return (MethodHandles.Lookup)this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(Object target, Method method, Object[] params) {
        try {
            ThrowingTriFunction<Method, Object, Object[], Object, Throwable> methodInvoker = this.methodInvoker;
            try {
                return (T)methodInvoker.apply(method, target, params);
            }
            catch (NullPointerException exc) {
                if (methodInvoker != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.methodInvoker == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.methodInvoker = this.getOrBuildMethodInvoker(initContext);
                        this.refresh(initContext);
                    }
                }
                return (T)this.methodInvoker.apply(method, target, params);
            }
        }
        catch (Throwable exc) {
            return this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T newInstance(Constructor<T> ctor, Object[] params) {
        try {
            ThrowingBiFunction<Constructor<?>, Object[], Object, Throwable> constructorInvoker = this.constructorInvoker;
            try {
                return (T)constructorInvoker.apply(ctor, params);
            }
            catch (NullPointerException exc) {
                if (constructorInvoker != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.constructorInvoker == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.constructorInvoker = this.getOrBuildConstructorInvoker(initContext);
                        this.refresh(initContext);
                    }
                }
                return (T)this.constructorInvoker.apply(ctor, params);
            }
        }
        catch (Throwable exc) {
            return this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Field[] getDeclaredFields(Class<?> cls) {
        try {
            ThrowingFunction<Class<?>, Field[], Throwable> declaredFieldsRetriever = this.declaredFieldsRetriever;
            try {
                return declaredFieldsRetriever.apply(cls);
            }
            catch (NullPointerException exc) {
                if (declaredFieldsRetriever != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.declaredFieldsRetriever == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.declaredFieldsRetriever = this.getOrBuildDeclaredFieldsRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.declaredFieldsRetriever.apply(cls);
            }
        }
        catch (Throwable exc) {
            return (Field[])this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Constructor<T>[] getDeclaredConstructors(Class<T> cls) {
        try {
            ThrowingFunction<Class<?>, Constructor<?>[], Throwable> declaredConstructorsRetriever = this.declaredConstructorsRetriever;
            try {
                return declaredConstructorsRetriever.apply(cls);
            }
            catch (NullPointerException exc) {
                if (declaredConstructorsRetriever != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.declaredConstructorsRetriever == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.declaredConstructorsRetriever = this.getOrBuildDeclaredConstructorsRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.declaredConstructorsRetriever.apply(cls);
            }
        }
        catch (Throwable exc) {
            return (Constructor[])this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Method[] getDeclaredMethods(Class<?> cls) {
        try {
            ThrowingFunction<Class<?>, Method[], Throwable> declaredMethodsRetriever = this.declaredMethodsRetriever;
            try {
                return declaredMethodsRetriever.apply(cls);
            }
            catch (NullPointerException exc) {
                if (declaredMethodsRetriever != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.declaredMethodsRetriever == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.declaredMethodsRetriever = this.getOrBuildDeclaredMethodsRetriever(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.declaredMethodsRetriever.apply(cls);
            }
        }
        catch (Throwable exc) {
            return (Method[])this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated(since="9.4.0")
    public void stop(Thread thread) {
        try {
            ThrowingBiConsumer<Thread, Throwable, Throwable> threadStopper = this.threadStopper;
            try {
                threadStopper.accept(thread, new ThreadDeath());
            }
            catch (NullPointerException exc) {
                if (threadStopper != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.threadStopper == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.threadStopper = this.getOrBuildThreadStopper(initContext);
                        this.refresh(initContext);
                    }
                }
                this.threadStopper.accept(thread, new ThreadDeath());
            }
        }
        catch (Throwable exc) {
            this.throwException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader convertToBuiltinClassLoader(ClassLoader classLoader) {
        try {
            ThrowingFunction<ClassLoader, ClassLoader, Throwable> classLoaderToBuiltinClassLoaderConverter = this.classLoaderToBuiltinClassLoaderConverter;
            try {
                return classLoaderToBuiltinClassLoaderConverter.apply(classLoader);
            }
            catch (NullPointerException exc) {
                if (classLoaderToBuiltinClassLoaderConverter != null) {
                    throw exc;
                }
                DriverAbst driverAbst = this;
                synchronized (driverAbst) {
                    if (this.classLoaderToBuiltinClassLoaderConverter == null) {
                        Map<Object, Object> initContext = this.functionsToMap();
                        this.classLoaderToBuiltinClassLoaderConverter = this.getOrBuildClassLoaderToBuiltinClassLoaderConverter(initContext);
                        this.refresh(initContext);
                    }
                }
                return this.classLoaderToBuiltinClassLoaderConverter.apply(classLoader);
            }
        }
        catch (Throwable exc) {
            return (ClassLoader)this.throwException(exc);
        }
    }

    @Override
    public void close() {
        this.exceptionThrower = null;
        this.allocateInstanceInvoker = null;
        this.fieldValueRetriever = null;
        this.fieldValueSetter = null;
        this.hookClassDefiner = null;
        this.declaredFieldsRetriever = null;
        this.declaredMethodsRetriever = null;
        this.declaredConstructorsRetriever = null;
        this.accessibleSetter = null;
        this.constructorInvoker = null;
        this.methodInvoker = null;
        this.packageRetriever = null;
        this.classByNameRetriever = null;
        this.resourcesRetriver = null;
        this.builtinClassLoaderClassSupplier = null;
        this.classLoaderDelegateClassSupplier = null;
        this.consulterRetriever = null;
        this.loadedClassesRetrieverSupplier = null;
        this.loadedPackagesRetriever = null;
        this.classLoaderToBuiltinClassLoaderConverter = null;
        this.threadStopper = null;
    }
}

