/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFListDescription;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFOnClickController;
import org.eclipse.eef.core.api.controllers.IEEFListController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFListController
extends AbstractEEFOnClickController
implements IEEFListController {
    private final EEFListDescription description;
    private Consumer<Object> newValueConsumer;

    public EEFListController(IVariableManager variableManager, IInterpreter interpreter, EEFListDescription description, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    public void refresh() {
        super.refresh();
        String valueExpression = this.description.getValueExpression();
        Optional.ofNullable(this.newValueConsumer).ifPresent(consumer -> this.newEval().call(valueExpression, (Consumer<Object>)consumer));
    }

    @Override
    public void onNewValue(Consumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }

    @Override
    public IStatus action(EEFWidgetAction action, List<Object> elements) {
        return this.editingContextAdapter.performModelChange(() -> {
            String expression = action.getActionExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_WIDGET_ACTION__ACTION_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            variables.put("selection", elements);
            EvalFactory.of(this.interpreter, variables).logIfBlank(eAttribute).call(expression);
        });
    }

    @Override
    protected String getOnClickExpression() {
        return this.description.getOnClickExpression();
    }
}

