/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.reviews.DeliveryReview;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.impl.ReviewStatemachine;
import org.eclipse.emf.cdo.lm.reviews.ui.ClientReviewStatemachine;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.AbstractReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.InteractiveDeliveryMerger;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.util.LMMerger2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;

public class RebaseToTargetAction
extends AbstractReviewAction {
    public RebaseToTargetAction(IWorkbenchPage page, Review review) {
        super(page, "Rebase To Target" + INTERACTIVE, "Rebase the review to the target stream '" + review.getStream().getName() + "'", OM.getImageDescriptor("icons/RebaseToTarget.png"), "Rebase the review to the target stream '" + review.getStream().getName() + "'.", "icons/wizban/RebaseToTarget.png", review);
    }

    protected boolean isDialogNeeded() {
        return false;
    }

    @Override
    protected void preRun(Review review, ISystemDescriptor systemDescriptor) {
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent, Review review, ISystemDescriptor systemDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doRun(Review review, ISystemDescriptor systemDescriptor, IProgressMonitor monitor) throws Exception {
        DeliveryReview deliveryReview = (DeliveryReview)review;
        String moduleName = deliveryReview.getModule().getName();
        ReviewStatemachine.RebaseToTargetResult result = new ReviewStatemachine.RebaseToTargetResult();
        systemDescriptor.withModuleSession(moduleName, moduleSession -> {
            long lastStreamCommitTime;
            CDOBranchManager branchManager = moduleSession.getBranchManager();
            CDOCommitInfoManager commitInfoManager = moduleSession.getCommitInfoManager();
            CDOBranchRef reviewBranchRef = deliveryReview.getBranch();
            CDOBranch reviewBranch = reviewBranchRef.resolve(branchManager);
            long lastReviewCommitTime = commitInfoManager.getLastCommitOfBranch(reviewBranch, true);
            CDOBranchPoint lastReviewCommit = reviewBranch.getPoint(lastReviewCommitTime);
            CDOBranchRef streamBranchRef = deliveryReview.getStream().getBranch();
            CDOBranch streamBranch = streamBranchRef.resolve(branchManager);
            rebaseToTargetResult.targetCommit = lastStreamCommitTime = commitInfoManager.getLastCommitOfBranch(streamBranch, true);
            int rebaseCount = deliveryReview.getRebaseCount() + 1;
            CDOBranch rebaseBranch = streamBranch.createBranch("review-" + deliveryReview.getId() + "-" + rebaseCount, lastStreamCommitTime);
            rebaseToTargetResult.rebaseBranch = new CDOBranchRef(rebaseBranch);
            LMMerger2.LMMergeInfos infos = new LMMerger2.LMMergeInfos();
            infos.setSession(moduleSession);
            infos.setSourceBaseline((Baseline)deliveryReview);
            infos.setSourceBranchPoint(lastReviewCommit);
            infos.setTargetBaseline((FloatingBaseline)deliveryReview);
            infos.setTargetBranch(rebaseBranch);
            InteractiveDeliveryMerger merger = new InteractiveDeliveryMerger();
            rebaseToTargetResult.success = merger.mergeDelivery(infos) != -1L;
        });
        ClientReviewStatemachine.DELIVERIES.process(deliveryReview, (Enum)ReviewStatemachine.ReviewEvent.RebaseToTarget, result);
        RebaseToTargetAction.updateCheckouts(review, systemDescriptor, result.rebaseBranch);
    }

    private static void updateCheckouts(Review review, ISystemDescriptor systemDescriptor, CDOBranchRef rebaseBranchRef) {
        CDOID baselineID = review.cdoID();
        CDOBranchPointRef headRef = rebaseBranchRef.getHeadRef();
        IAssemblyDescriptor[] iAssemblyDescriptorArray = IAssemblyManager.INSTANCE.getDescriptors();
        int n = iAssemblyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAssemblyDescriptor assemblyDescriptor = iAssemblyDescriptorArray[n2];
            if (assemblyDescriptor.getSystemDescriptor() == systemDescriptor && assemblyDescriptor.getBaseline().cdoID() == baselineID) {
                assemblyDescriptor.getCheckout().setBranchPoint(headRef);
            }
            ++n2;
        }
    }
}

