/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.impl.SystemImpl;
import org.eclipse.emf.cdo.lm.internal.server.bundle.OM;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class AbstractLifecycleManager
extends Lifecycle
implements LMPackage.Literals {
    private static final String ACCEPTOR_NAME = "local";
    private static final boolean SECURITY_AVAILABLE;
    private static final boolean CREATE_TEST_USER;
    private IManagedContainer container;
    private IJVMAcceptor acceptor;
    private IJVMConnector connector;
    private String systemName;
    private InternalRepository systemRepository;
    private CDOSession systemSession;
    private CDOView systemView;
    private System system;
    private String moduleDefinitionPath;
    private final Map<String, InternalRepository> moduleRepositories = new HashMap<String, InternalRepository>();
    private final Map<String, CDOSession> moduleSessions = new HashMap<String, CDOSession>();
    private final IRepository.WriteAccessHandler writeAccessHandler = new IRepository.WriteAccessHandler(){

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            if (this.isMainBranch(commitContext)) {
                AbstractLifecycleManager.this.handleCommit(commitContext);
            }
        }

        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
            if (this.isMainBranch(commitContext)) {
                AbstractLifecycleManager.this.fireEvent((IEvent)new SystemCommitEvent(commitContext));
            }
        }

        private boolean isMainBranch(IStoreAccessor.CommitContext commitContext) {
            return commitContext.getBranchPoint().getBranch().isMainBranch();
        }
    };
    private final ConcurrentArray<SystemCommitHandler> systemCommitHandlers = new ConcurrentArray<SystemCommitHandler>(){

        protected SystemCommitHandler[] newArray(int length) {
            return new SystemCommitHandler[length];
        }
    };
    private Consumer<Process> processInitializer;
    private boolean credentialsBasedLogin;
    @ReflectUtil.ExcludeFromDump
    private IPasswordCredentials credentials;
    private SecuritySupport securitySupport = SecuritySupport.UNAVAILABLE;

    static {
        boolean securityAvailable;
        CREATE_TEST_USER = OMPlatform.INSTANCE.isProperty("AbstractLifecycleManager.CREATE_TEST_USER");
        try {
            securityAvailable = CommonPlugin.loadClass((String)"org.eclipse.emf.cdo.server.security", (String)"org.eclipse.emf.cdo.server.security.ISecurityManager") != null;
        }
        catch (Throwable ex) {
            securityAvailable = false;
        }
        SECURITY_AVAILABLE = securityAvailable;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public final IJVMConnector getConnector() {
        return this.connector;
    }

    public final System getSystem() {
        return this.system;
    }

    public InternalRepository getSystemRepository() {
        return this.systemRepository;
    }

    public void setSystemRepository(InternalRepository repository) {
        this.checkInactive();
        this.container = repository.getContainer();
        this.systemRepository = repository;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.checkInactive();
        SystemImpl.checkName((String)systemName);
        this.systemName = systemName;
    }

    public Consumer<Process> getProcessInitializer() {
        return this.processInitializer;
    }

    public void setProcessInitializer(Consumer<Process> processInitializer) {
        this.processInitializer = processInitializer;
    }

    public boolean isCredentialsBasedLogin() {
        return this.credentialsBasedLogin;
    }

    public void setCredentialsBasedLogin(boolean credentialsBasedLogin) {
        this.credentialsBasedLogin = credentialsBasedLogin;
    }

    public IPasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(IPasswordCredentials credentials) {
        this.credentials = credentials;
    }

    public String getModuleDefinitionPath() {
        return this.moduleDefinitionPath == null ? "module.md" : this.moduleDefinitionPath;
    }

    public void setModuleDefinitionPath(String moduleDefinitionPath) {
        this.checkInactive();
        this.moduleDefinitionPath = CDOURIUtil.sanitizePath((String)moduleDefinitionPath);
    }

    public final Map<String, InternalRepository> getModuleRepositories() {
        return this.moduleRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CDOSession getModuleSession(final String moduleName) {
        Map<String, CDOSession> map = this.moduleSessions;
        synchronized (map) {
            InternalRepository repository;
            CDOSession session = this.moduleSessions.get(moduleName);
            if (session == null && (repository = this.moduleRepositories.get(moduleName)) != null) {
                session = this.openModuleSession(repository);
                session.addListener((IListener)new LifecycleEventAdapter(){

                    protected void onDeactivated(ILifecycle lifecycle) {
                        if (AbstractLifecycleManager.this.isActive()) {
                            AbstractLifecycleManager.this.moduleSessions.remove(moduleName);
                        }
                    }
                });
                this.moduleSessions.put(moduleName, session);
            }
            return session;
        }
    }

    public void addSystemCommitHandler(SystemCommitHandler handler) {
        this.systemCommitHandlers.add((Object)handler);
    }

    public void removeSystemCommitHandler(SystemCommitHandler handler) {
        this.systemCommitHandlers.remove((Object)handler);
    }

    public String toString() {
        return super.toString() + "[system=" + this.systemName + "]";
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.systemRepository, "systemRepository");
        this.checkState(this.systemName, "systemName");
        String moduleDefinitionPath = this.getModuleDefinitionPath();
        IPasswordCredentials credentials = this.getCredentials();
        IRepositoryProtector protector = this.systemRepository.getProtector();
        if (protector != null && protector.getAuthorizationStrategy() != null) {
            this.securitySupport = new SecuritySupport.ProtectorBased(this.systemRepository, moduleDefinitionPath, credentials);
        } else if (SECURITY_AVAILABLE) {
            this.securitySupport = new SecuritySupport.RealmBased(this.systemRepository, moduleDefinitionPath, credentials);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        IRegistry properties = this.systemRepository.properties();
        properties.put((Object)"cdo.lm.server.lifecycle_manager", (Object)this);
        properties.put((Object)"cdo.lm.server.repository_type", (Object)"system");
        properties.put((Object)"cdo.lm.server.system_name", (Object)this.systemName);
        this.acceptor = JVMUtil.getAcceptor((IManagedContainer)this.container, (String)ACCEPTOR_NAME);
        this.connector = JVMUtil.getConnector((IManagedContainer)this.container, (String)ACCEPTOR_NAME);
        CDONet4jSessionConfiguration sessionConfiguration = this.createSessionConfiguration(this.systemRepository.getName());
        this.systemSession = sessionConfiguration.openNet4jSession();
        ArrayList moduleInfos = new ArrayList();
        this.initSystemRepository(this.systemSession, (moduleName, moduleTypeName) -> {
            boolean bl = moduleInfos.add(Pair.create((Object)moduleName, (Object)moduleTypeName));
        });
        this.systemView = this.systemSession.openView();
        CDOResource systemResource = this.systemView.getResource("/system");
        this.system = (System)systemResource.getContents().get(0);
        for (Pair info : moduleInfos) {
            String moduleName2 = (String)info.getElement1();
            String moduleTypeName2 = (String)info.getElement2();
            this.addModule(moduleName2, moduleTypeName2);
        }
        this.systemRepository.addHandler((IRepository.Handler)this.writeAccessHandler);
    }

    protected void doDeactivate() throws Exception {
        this.systemRepository.removeHandler((IRepository.Handler)this.writeAccessHandler);
        LifecycleUtil.deactivate((Object)this.systemSession);
        AbstractLifecycleManager.deactivate(this.moduleSessions);
        AbstractLifecycleManager.deactivate(this.moduleRepositories);
        LifecycleUtil.deactivate((Object)this.connector);
        LifecycleUtil.deactivate((Object)this.acceptor);
        super.doDeactivate();
    }

    protected void initSystemRepository(CDOSession session, BiConsumer<String, String> moduleInfoComsumer) throws Exception {
        try (CDOTransaction transaction = session.openTransaction();){
            System system = null;
            CDOResource resource = transaction.getOrCreateResource("/system");
            EList contents = resource.getContents();
            if (contents.isEmpty()) {
                OM.LOG.info("Initializing system resource");
                Process process = LMFactory.eINSTANCE.createProcess();
                process.setModuleDefinitionPath(this.getModuleDefinitionPath());
                process.setInitialModuleVersion(Version.createOSGi((int)0, (int)1, (int)0));
                this.initProcess(process);
                system = LMFactory.eINSTANCE.createSystem();
                system.setName(this.systemName);
                system.setProcess(process);
                contents.add((Object)system);
                transaction.setCommitComment("<initialize system>");
                transaction.commit();
            } else {
                String name;
                EObject root = (EObject)contents.get(0);
                if (root instanceof System && !Objects.equals(name = (system = (System)root).getName(), this.systemName)) {
                    throw new IllegalStateException("System name '" + name + "' does not match configured name '" + this.systemName + "'");
                }
            }
            if (system == null) {
                throw new IllegalStateException("System resource does not contain a system");
            }
            for (Module module : system.getModules()) {
                String moduleName = module.getName();
                ModuleType moduleType = module.getType();
                String moduleTypeName = moduleType == null ? null : moduleType.getName();
                moduleInfoComsumer.accept(moduleName, moduleTypeName);
            }
        }
    }

    protected void initProcess(Process process) {
        if (this.processInitializer != null) {
            this.processInitializer.accept(process);
        } else {
            Map<String, Boolean> dropTypes;
            List<String> moduleTypes = this.getInitialModuleTypes();
            if (!ObjectUtil.isEmpty(moduleTypes)) {
                moduleTypes.forEach(arg_0 -> ((Process)process).addModuleType(arg_0));
            }
            if (!ObjectUtil.isEmpty(dropTypes = this.getInitialDropTypes())) {
                dropTypes.forEach((arg_0, arg_1) -> ((Process)process).addDropType(arg_0, arg_1));
            }
        }
    }

    protected List<String> getInitialModuleTypes() {
        return Collections.emptyList();
    }

    protected Map<String, Boolean> getInitialDropTypes() {
        return Collections.emptyMap();
    }

    protected void handleCommit(IStoreAccessor.CommitContext commitContext) {
        SystemCommitHandler[] systemCommitHandlerArray = (SystemCommitHandler[])this.systemCommitHandlers.get();
        int n = systemCommitHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemCommitHandler handler = systemCommitHandlerArray[n2];
            handler.handleCommit(commitContext);
            ++n2;
        }
        InternalCDORevisionDelta[] dirtyObjectDeltas = commitContext.getDirtyObjectDeltas();
        if (dirtyObjectDeltas != null) {
            ArrayList<ModuleInfo> newModules = new ArrayList<ModuleInfo>();
            int i = 0;
            while (i < dirtyObjectDeltas.length) {
                InternalCDORevisionDelta revisionDelta = dirtyObjectDeltas[i];
                EClass eClass = revisionDelta.getEClass();
                if (eClass == SYSTEM) {
                    AbstractLifecycleManager.handleListDelta(commitContext, revisionDelta, SYSTEM__MODULES, addedModule -> this.handleModuleAddition((InternalCDORevision)addedModule, newModules::add), removeModuleDelta -> this.handleModuleDeletion(commitContext, revisionDelta, (CDORemoveFeatureDelta)removeModuleDelta));
                } else if (eClass == MODULE) {
                    CDOFeatureDelta featureDelta = revisionDelta.getFeatureDelta((EStructuralFeature)MODULE__NAME);
                    if (featureDelta != null) {
                        throw new CDOException("Renaming modules is not supported");
                    }
                } else if (eClass == STREAM) {
                    AbstractLifecycleManager.handleListDelta(commitContext, revisionDelta, STREAM__CONTENTS, addedContent -> this.handleBaselineAddition(commitContext, (InternalCDORevision)addedContent), removeFeatureDelta -> this.handleBaselineDeletion(commitContext, (CDORevisionDelta)revisionDelta, (CDORemoveFeatureDelta)removeFeatureDelta));
                }
                ++i;
            }
            this.createNewModuleInfos(commitContext, newModules);
        }
    }

    protected void handleModuleAddition(InternalCDORevision addedModule, Consumer<ModuleInfo> newModulesInfoConsumer) {
        String moduleName = (String)addedModule.get((EStructuralFeature)MODULE__NAME, 0);
        if (!this.isValidModuleName(moduleName)) {
            throw new CDOException("Module name is invalid: " + moduleName);
        }
        if (this.moduleRepositories.containsKey(moduleName)) {
            throw new CDOException("Module name is not unique: " + moduleName);
        }
        CDOID moduleTypeID = (CDOID)addedModule.getValue((EStructuralFeature)MODULE__TYPE);
        CDOID initialStreamID = null;
        CDOList streams = addedModule.getListOrNull((EStructuralFeature)MODULE__STREAMS);
        if (streams != null && !streams.isEmpty()) {
            initialStreamID = (CDOID)streams.get(0);
        }
        newModulesInfoConsumer.accept(new ModuleInfo(moduleName, moduleTypeID, initialStreamID));
    }

    protected void handleModuleDeletion(IStoreAccessor.CommitContext commitContext, InternalCDORevisionDelta systemRevisionDelta, CDORemoveFeatureDelta removeModuleDelta) {
        CDOID systemID = systemRevisionDelta.getID();
        int index = removeModuleDelta.getIndex();
        InternalCDORevision systemRevision = (InternalCDORevision)commitContext.getOldRevisions().get(systemID);
        CDOID removedID = (CDOID)systemRevision.get((EStructuralFeature)SYSTEM__MODULES, index);
        InternalCDORevision[] internalCDORevisionArray = ((InternalCommitContext)commitContext).getDetachedRevisions();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            if (revision.getID() == removedID) {
                String moduleName = (String)revision.get((EStructuralFeature)MODULE__NAME, 0);
                CDOSession session = this.moduleSessions.remove(moduleName);
                LifecycleUtil.deactivate((Object)session);
                InternalRepository repository = this.moduleRepositories.remove(moduleName);
                LifecycleUtil.deactivate((Object)repository);
                break;
            }
            ++n2;
        }
    }

    protected void handleBaselineAddition(IStoreAccessor.CommitContext commitContext, InternalCDORevision addedContent) {
        this.fireEvent((IEvent)new NewBaselineEvent(commitContext, (CDORevision)addedContent));
    }

    protected void handleBaselineDeletion(IStoreAccessor.CommitContext commitContext, CDORevisionDelta revisionDelta, CDORemoveFeatureDelta removeFeatureDelta) {
    }

    protected void createNewModuleInfos(IStoreAccessor.CommitContext commitContext, List<ModuleInfo> newModules) {
        for (ModuleInfo newModule : newModules) {
            try {
                String moduleName = newModule.getModuleName();
                CDOID moduleTypeID = newModule.getModuleTypeID();
                CDOID initialStreamID = newModule.getInitialStreamID();
                Process process = this.system.getProcess();
                Version initialModuleVersion = process.getInitialModuleVersion();
                ModuleType moduleType = moduleTypeID == null ? null : (ModuleType)this.systemView.getObject(moduleTypeID);
                String moduleTypeName = moduleType == null ? null : moduleType.getName();
                this.createNewModule(moduleName, moduleTypeName);
                CDOSession moduleSession = this.getModuleSession(moduleName);
                CDOTransaction moduleTransaction = moduleSession.openTransaction();
                long moduleCreationTime = moduleSession.getRepositoryInfo().getCreationTime();
                try {
                    if (moduleTransaction.hasResource(this.moduleDefinitionPath)) continue;
                    ModuleDefinition moduleDefinition = ModulesFactory.eINSTANCE.createModuleDefinition();
                    moduleDefinition.setName(moduleName);
                    moduleDefinition.setVersion(initialModuleVersion);
                    CDOResource moduleDefinitionResource = moduleTransaction.createResource(this.moduleDefinitionPath);
                    moduleDefinitionResource.getContents().add((Object)moduleDefinition);
                    moduleTransaction.commit();
                    commitContext.modify(context -> {
                        for (CDOIDAndVersion newObject : context.getChangeSetData().getNewObjects()) {
                            if (newObject.getID() != initialStreamID) continue;
                            InternalCDORevision streamRevision = (InternalCDORevision)newObject;
                            streamRevision.set((EStructuralFeature)STREAM__START_TIME_STAMP, 0, (Object)moduleCreationTime);
                        }
                    });
                }
                finally {
                    moduleTransaction.close();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void createNewModule(String moduleName, String moduleTypeName) throws Exception {
        this.addModule(moduleName, moduleTypeName);
    }

    protected boolean isValidModuleName(String moduleName) {
        return SystemImpl.isValidName((String)moduleName);
    }

    protected void addModule(final String moduleName, final String moduleTypeName) throws Exception {
        RunnableWithException.forkAndWait(() -> {
            OM.LOG.info("Adding module " + moduleName + " to system " + this.systemName);
            InternalRepository moduleRepository = this.createModuleRepository(moduleName);
            IRegistry properties = moduleRepository.properties();
            properties.put((Object)"cdo.lm.server.lifecycle_manager", (Object)this);
            properties.put((Object)"cdo.lm.server.repository_type", (Object)"module");
            properties.put((Object)"cdo.lm.server.system_name", (Object)this.systemName);
            properties.put((Object)"cdo.lm.server.module_name", (Object)moduleName);
            properties.put((Object)"cdo.lm.server.module_type_name", (Object)moduleTypeName);
            moduleRepository.addHandler((IRepository.Handler)new IRepository.WriteAccessHandler(){

                public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
                }

                public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
                    AbstractLifecycleManager.this.fireEvent((IEvent)new ModuleCommitEvent(moduleName, moduleTypeName, commitContext));
                }
            });
            CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)moduleRepository);
            this.securitySupport.addModuleRepository(moduleRepository, moduleName, moduleTypeName);
            this.moduleRepositories.put(moduleName, moduleRepository);
        });
    }

    protected abstract InternalRepository createModuleRepository(String var1) throws CoreException;

    protected CDONet4jSession openModuleSession(InternalRepository moduleRepository) {
        CDONet4jSessionConfiguration configuration = this.createSessionConfiguration(moduleRepository.getName());
        configuration.setSignalTimeout(Integer.MAX_VALUE);
        CDONet4jSession session = configuration.openNet4jSession();
        session.options().setCommitTimeout(Integer.MAX_VALUE);
        return session;
    }

    protected CDONet4jSessionConfiguration createSessionConfiguration(String repositoryName) {
        IPasswordCredentials credentials;
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector((IConnector)this.connector);
        configuration.setRepositoryName(repositoryName);
        if (!this.credentialsBasedLogin) {
            InternalRepository repository = this.getRepository(repositoryName);
            byte[] oneTimeLoginToken = repository.getSessionManager().generateOneTimeLoginToken();
            configuration.setOneTimeLoginToken(oneTimeLoginToken);
        }
        if ((credentials = this.securitySupport.getCredentials()) != null) {
            configuration.setCredentialsProvider((IPasswordCredentialsProvider)new PasswordCredentialsProvider(credentials));
        }
        return configuration;
    }

    private InternalRepository getRepository(String repositoryName) {
        if (this.systemRepository != null && this.systemRepository.getName().equals(repositoryName)) {
            return this.systemRepository;
        }
        return this.moduleRepositories.get(repositoryName);
    }

    private FloatingBaseline determineBaseline(String moduleName, CDOBranch branch) {
        CDOBranchRef branchRef = new CDOBranchRef(branch);
        FloatingBaseline[] result = new FloatingBaseline[1];
        Module module = this.system.getModule(moduleName);
        if (module != null) {
            module.forEachBaseline(baseline -> {
                FloatingBaseline floatingBaseline;
                if (baseline instanceof FloatingBaseline && (floatingBaseline = (FloatingBaseline)baseline).getBranch().equals((Object)branchRef)) {
                    floatingBaselineArray[0] = floatingBaseline;
                    return true;
                }
                return false;
            });
        }
        return result[0];
    }

    private <R> R executeAgainstModuleSession(IStoreAccessor.CommitContext commitContext, CDOID moduleID, final Function<CDOSession, R> function) {
        CDORevision module = commitContext.getRevision(moduleID);
        String moduleName = (String)module.data().get((EStructuralFeature)MODULE__NAME, 0);
        final CDOSession moduleSession = this.getModuleSession(moduleName);
        final Throwable[] exception = new Throwable[1];
        final AtomicReference result = new AtomicReference();
        Thread thread = new Thread(function.getClass().getName()){

            @Override
            public void run() {
                try {
                    Object value = function.apply(moduleSession);
                    result.set(value);
                }
                catch (Error | RuntimeException ex) {
                    exception[0] = ex;
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            thread.interrupt();
            throw WrappedException.wrap((Exception)ex);
        }
        if (exception[0] instanceof RuntimeException) {
            throw (RuntimeException)exception[0];
        }
        if (exception[0] instanceof Error) {
            throw (Error)exception[0];
        }
        return (R)result.get();
    }

    private static void handleListDelta(IStoreAccessor.CommitContext commitContext, InternalCDORevisionDelta revisionDelta, EReference reference, Consumer<InternalCDORevision> additionConsumer, Consumer<CDORemoveFeatureDelta> removalConsumer) {
        CDOListFeatureDelta listDelta = (CDOListFeatureDelta)revisionDelta.getFeatureDelta((EStructuralFeature)reference);
        if (listDelta != null) {
            for (CDOFeatureDelta featureDelta : listDelta.getListChanges()) {
                if (removalConsumer != null && featureDelta instanceof CDORemoveFeatureDelta) {
                    CDORemoveFeatureDelta removeDelta = (CDORemoveFeatureDelta)featureDelta;
                    removalConsumer.accept(removeDelta);
                    continue;
                }
                if (additionConsumer == null || !(featureDelta instanceof CDOAddFeatureDelta)) continue;
                CDOAddFeatureDelta addDelta = (CDOAddFeatureDelta)featureDelta;
                CDOID id = (CDOID)addDelta.getValue();
                InternalCDORevision revision = (InternalCDORevision)commitContext.getRevision(id);
                additionConsumer.accept(revision);
            }
        }
    }

    public static AbstractLifecycleManager of(IManagedContainer container, String systemName) {
        return AbstractLifecycleManager.of(container, (AbstractLifecycleManager lm) -> Objects.equals(lm.getSystemName(), systemName));
    }

    public static AbstractLifecycleManager of(IManagedContainer container, IRepository repository) {
        return AbstractLifecycleManager.of(container, (AbstractLifecycleManager lm) -> {
            if (lm.getSystemRepository() == repository) {
                return true;
            }
            for (InternalRepository moduleRepository : lm.getModuleRepositories().values()) {
                if (moduleRepository != repository) continue;
                return true;
            }
            return false;
        });
    }

    private static AbstractLifecycleManager of(IManagedContainer container, Predicate<AbstractLifecycleManager> predicate) {
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.lm.server.lifecycleManagers");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractLifecycleManager lifecycleManager;
            Object element = objectArray[n2];
            if (element instanceof AbstractLifecycleManager && predicate.test(lifecycleManager = (AbstractLifecycleManager)((Object)element))) {
                return lifecycleManager;
            }
            ++n2;
        }
        return null;
    }

    private static void deactivate(Map<String, ?> map) {
        for (Object value : map.values()) {
            LifecycleUtil.deactivate(value);
        }
        map.clear();
    }

    @Deprecated
    protected List<String> initSystemRepository(CDOSession session) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void handleModuleAddition(InternalCDORevision addedModule, List<Pair<String, CDOID>> newModules) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void createNewModules(IStoreAccessor.CommitContext commitContext, List<Pair<String, CDOID>> newModules) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void createNewModule(String moduleName) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void addModule(String moduleName) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static CDOBranchRef getBranch(CDORevision floatingBaseline) {
        throw new UnsupportedOperationException();
    }

    public static abstract class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.lm.server.lifecycleManagers";

        protected Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        public abstract AbstractLifecycleManager create(String var1) throws ProductCreationException;

        public static AbstractLifecycleManager get(IManagedContainer container, String type, String description) {
            return (AbstractLifecycleManager)((Object)container.getElementOrNull(PRODUCT_GROUP, type, description));
        }
    }

    public final class ModuleCommitEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final String moduleName;
        private final String moduleTypeName;
        private final IStoreAccessor.CommitContext commitContext;
        private transient FloatingBaseline commitBaseline;

        private ModuleCommitEvent(String moduleName, String moduleTypeName, IStoreAccessor.CommitContext commitContext) {
            super((INotifier)AbstractLifecycleManager.this);
            this.moduleName = moduleName;
            this.moduleTypeName = moduleTypeName;
            this.commitContext = commitContext;
        }

        public AbstractLifecycleManager getSource() {
            return (AbstractLifecycleManager)super.getSource();
        }

        public String getSystemName() {
            return this.getSource().getSystemName();
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getModuleTypeName() {
            return this.moduleTypeName;
        }

        public IStoreAccessor.CommitContext getCommitContext() {
            return this.commitContext;
        }

        public CDOBranch getCommitBranch() {
            return this.commitContext.getBranchPoint().getBranch();
        }

        public FloatingBaseline getCommitBaseline() {
            if (this.commitBaseline == null) {
                CDOBranch branch = this.getCommitBranch();
                this.commitBaseline = AbstractLifecycleManager.this.determineBaseline(this.moduleName, branch);
            }
            return this.commitBaseline;
        }

        protected String formatAdditionalParameters() {
            return "moduleName=" + this.moduleName + ", moduleTypeName=" + this.moduleTypeName + ", commitContext=" + String.valueOf(this.commitContext);
        }
    }

    public static final class ModuleInfo {
        private final String moduleName;
        private final CDOID moduleTypeID;
        private final CDOID initialStreamID;

        private ModuleInfo(String moduleName, CDOID moduleTypeID, CDOID initialStreamID) {
            this.moduleName = moduleName;
            this.moduleTypeID = moduleTypeID;
            this.initialStreamID = initialStreamID;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public CDOID getModuleTypeID() {
            return this.moduleTypeID;
        }

        public CDOID getInitialStreamID() {
            return this.initialStreamID;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ModuleInfo[moduleName=");
            builder.append(this.moduleName);
            builder.append(", moduleTypeID=");
            builder.append(this.moduleTypeID);
            builder.append(", initialStreamID=");
            builder.append(this.initialStreamID);
            builder.append("]");
            return builder.toString();
        }
    }

    public final class NewBaselineEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final IStoreAccessor.CommitContext commitContext;
        private final CDORevision newBaseline;

        private NewBaselineEvent(IStoreAccessor.CommitContext commitContext, CDORevision newBaseline) {
            super((INotifier)AbstractLifecycleManager.this);
            this.commitContext = commitContext;
            this.newBaseline = newBaseline;
        }

        public AbstractLifecycleManager getSource() {
            return (AbstractLifecycleManager)super.getSource();
        }

        public String getSystemName() {
            return this.getSource().getSystemName();
        }

        public IStoreAccessor.CommitContext getCommitContext() {
            return this.commitContext;
        }

        public CDORevision getNewBaseline() {
            return this.newBaseline;
        }

        protected String formatAdditionalParameters() {
            return "commitContext=" + String.valueOf(this.commitContext) + ", newBaseline=" + String.valueOf(this.newBaseline);
        }
    }

    private static interface SecuritySupport {
        public static final SecuritySupport UNAVAILABLE = new SecuritySupport(){

            @Override
            public IPasswordCredentials getCredentials() {
                return null;
            }

            @Override
            public void addModuleRepository(InternalRepository moduleRepository, String moduleName, String moduleTypeName) {
            }
        };

        public IPasswordCredentials getCredentials();

        public void addModuleRepository(InternalRepository var1, String var2, String var3);

        public static final class ProtectorBased
        implements SecuritySupport {
            private final IRepositoryProtector repositoryProtector;
            private final IPasswordCredentials passwordCredentials;

            public ProtectorBased(InternalRepository systemRepository, String moduleDefinitionPath, IPasswordCredentials credentials) {
                this.repositoryProtector = systemRepository.getProtector();
                this.passwordCredentials = credentials;
            }

            @Override
            public IPasswordCredentials getCredentials() {
                return this.passwordCredentials;
            }

            @Override
            public void addModuleRepository(InternalRepository moduleRepository, String moduleName, String moduleTypeName) {
                if (this.repositoryProtector != null) {
                    this.repositoryProtector.addSecondaryRepository((IRepository)moduleRepository);
                }
            }
        }

        public static final class RealmBased
        implements SecuritySupport {
            private static final String USER_NAME = "Lifecycle Manager";
            private static final String ROLE_NAME = "Lifecycle Management";
            private static final char[] KEY = new char[]{'c', 'd', 'o', ' ', 'r', 'o', 'c', 'k', 's', ' ', '(', 'e', 's', ')'};
            private final InternalSecurityManager securityManager;
            private final IPasswordCredentials passwordCredentials;

            public RealmBased(InternalRepository systemRepository, String moduleDefinitionPath, IPasswordCredentials credentials) {
                this.securityManager = (InternalSecurityManager)SecurityManagerUtil.getSecurityManager((IRepository)systemRepository);
                this.passwordCredentials = this.getOrCreateCredentials(systemRepository, credentials);
                if (this.securityManager != null) {
                    this.securityManager.modify(realm -> {
                        User stepper;
                        Role administrationRole;
                        User lmUser;
                        Role lmRole = realm.getRole(ROLE_NAME);
                        if (lmRole == null) {
                            lmRole = SecurityManagerUtil.addResourceRole((Realm)realm, (String)ROLE_NAME, (String)"/system", (boolean)true);
                            SecurityManagerUtil.addResourcePermissions((Role)lmRole, (String)moduleDefinitionPath, (boolean)false);
                        }
                        if ((lmUser = realm.getUser(this.passwordCredentials.getUserID())) == null) {
                            Role normalObjectsWriter;
                            lmUser = realm.addUser(this.passwordCredentials);
                            lmUser.getRoles().add((Object)lmRole);
                            Role allObjectsReader = realm.getRole("All Objects Reader");
                            if (allObjectsReader != null) {
                                lmUser.getRoles().add((Object)allObjectsReader);
                            }
                            if ((normalObjectsWriter = realm.getRole("Normal Objects Writer")) != null) {
                                lmUser.getRoles().add((Object)normalObjectsWriter);
                            }
                        }
                        if ((administrationRole = realm.getRole("Administration")) != null) {
                            SecurityManagerUtil.addResourcePermissions((Role)administrationRole, (String)"/system", (boolean)false);
                        }
                        if (CREATE_TEST_USER && (stepper = realm.getUser("Stepper")) == null) {
                            stepper = realm.addUser((IPasswordCredentials)new PasswordCredentials("Stepper", "xxx"));
                            stepper.getRoles().add((Object)lmRole);
                            stepper.getRoles().add((Object)realm.getRole("Administration"));
                        }
                    });
                }
            }

            @Override
            public IPasswordCredentials getCredentials() {
                return this.passwordCredentials;
            }

            @Override
            public void addModuleRepository(InternalRepository moduleRepository, String moduleName, String moduleTypeName) {
                if (this.securityManager != null) {
                    HashMap<String, String> authorizationContext = new HashMap<String, String>();
                    authorizationContext.put("moduleName", moduleName);
                    if (moduleTypeName != null) {
                        authorizationContext.put("moduleTypeName", moduleTypeName);
                    }
                    this.securityManager.addSecondaryRepository(moduleRepository, authorizationContext);
                }
            }

            private IPasswordCredentials getOrCreateCredentials(InternalRepository systemRepository, IPasswordCredentials credentials) {
                byte[] bytes;
                if (credentials != null) {
                    return credentials;
                }
                String uuid = systemRepository.getUUID();
                try {
                    bytes = SecurityUtil.pbeEncrypt((byte[])uuid.getBytes(), (char[])KEY, (String)"PBEWithMD5AndDES", (byte[])SecurityUtil.DEFAULT_SALT, (int)20);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    bytes = new String(KEY).getBytes();
                }
                String hex = HexUtil.bytesToHex((byte[])bytes);
                return new PasswordCredentials(USER_NAME, SecurityUtil.toCharArray((String)hex));
            }
        }
    }

    public final class SystemCommitEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final IStoreAccessor.CommitContext commitContext;

        private SystemCommitEvent(IStoreAccessor.CommitContext commitContext) {
            super((INotifier)AbstractLifecycleManager.this);
            this.commitContext = commitContext;
        }

        public AbstractLifecycleManager getSource() {
            return (AbstractLifecycleManager)super.getSource();
        }

        public String getSystemName() {
            return this.getSource().getSystemName();
        }

        public IStoreAccessor.CommitContext getCommitContext() {
            return this.commitContext;
        }

        protected String formatAdditionalParameters() {
            return "commitContext=" + String.valueOf(this.commitContext);
        }
    }

    public static interface SystemCommitHandler {
        public void handleCommit(IStoreAccessor.CommitContext var1) throws RuntimeException;
    }
}

