/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.contextbuttons;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.internal.contextbuttons.IContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.SpecialContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.StandardContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.IContextButtonManager;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.swt.SWT;

public class ContextButtonManagerForPad
implements IContextButtonManager {
    protected static final double MINIMUM_ZOOM_LEVEL = 0.75;
    private DiagramBehavior diagramBehavior;
    private Map<IFigure, EditPart> figure2EditPart = new HashMap<IFigure, EditPart>();
    private IFigure activeFigure;
    private ContextButtonPad activeContextButtonPad;
    private boolean contextButtonShowing;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            ContextButtonManagerForPad.this.handleZoomChanged();
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener.Stub(){

        public void mouseEntered(MouseEvent me) {
            this.reactOnMouse(me);
        }

        public void mouseMoved(MouseEvent me) {
            this.reactOnMouse(me);
        }

        private void reactOnMouse(MouseEvent me) {
            DiagramBehavior diagramBehavior = ContextButtonManagerForPad.this.getDiagramBehavior();
            if (diagramBehavior.isDirectEditingActive()) {
                return;
            }
            Tool activeTool = diagramBehavior.getEditDomain().getActiveTool();
            if (activeTool instanceof CreationTool || activeTool instanceof AbstractConnectionCreationTool) {
                return;
            }
            if ((me.getState() & SWT.MOD1) != 0) {
                ContextButtonManagerForPad.this.hideContextButtonsInstantly();
                return;
            }
            if (!ContextButtonManagerForPad.this.isContextButtonShowing()) {
                return;
            }
            Object source = me.getSource();
            ContextButtonManagerForPad.this.showContextButtonsInstantly((IFigure)source, me.getLocation());
        }
    };
    private IResourceRegistry resourceRegistry;

    public ContextButtonManagerForPad(DiagramBehavior diagramBehavior, IResourceRegistry resourceRegistry) {
        this.diagramBehavior = diagramBehavior;
        this.resourceRegistry = resourceRegistry;
        ZoomManager zoomMgr = (ZoomManager)this.getDiagramBehavior().getDiagramContainer().getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.addZoomListener(this.zoomListener);
        }
        this.contextButtonShowing = true;
    }

    public DiagramBehavior getDiagramBehavior() {
        return this.diagramBehavior;
    }

    private Map<IFigure, EditPart> getFigure2EditPart() {
        return this.figure2EditPart;
    }

    private void setActive(IFigure activeFigure, ContextButtonPad activeContextButtonPad) {
        this.activeFigure = activeFigure;
        this.activeContextButtonPad = activeContextButtonPad;
    }

    private IFigure getActiveFigure() {
        return this.activeFigure;
    }

    private ContextButtonPad getActiveContextButtonPad() {
        return this.activeContextButtonPad;
    }

    @Override
    public void register(GraphicalEditPart graphicalEditPart) {
        this.getFigure2EditPart().put(graphicalEditPart.getFigure(), (EditPart)graphicalEditPart);
        graphicalEditPart.getFigure().addMouseMotionListener(this.mouseMotionListener);
    }

    @Override
    public void deRegister(GraphicalEditPart graphicalEditPart) {
        if (graphicalEditPart.getFigure().equals(this.getActiveFigure())) {
            this.hideContextButtonsInstantly();
        }
        this.getFigure2EditPart().remove(graphicalEditPart.getFigure());
        graphicalEditPart.getFigure().removeMouseMotionListener(this.mouseMotionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hideContextButtonsInstantly() {
        if (this.getActiveContextButtonPad() != null) {
            ContextButtonManagerForPad contextButtonManagerForPad = this;
            synchronized (contextButtonManagerForPad) {
                ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getDiagramBehavior().getDiagramContainer().getGraphicalViewer().getRootEditPart();
                IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
                feedbackLayer.remove((IFigure)this.getActiveContextButtonPad());
                this.setActive(null, null);
            }
        }
    }

    private boolean replaceContextButtonPad(IFigure figure, Point mouseLocation) {
        if (this.getActiveFigure() == null) {
            return true;
        }
        if (figure.equals(this.getActiveFigure())) {
            return false;
        }
        IFigure parent = figure.getParent();
        while (parent != null) {
            if (parent.equals(this.getActiveFigure())) {
                return true;
            }
            parent = parent.getParent();
        }
        if (this.getActiveFigure().containsPoint(mouseLocation)) {
            return true;
        }
        return this.getActiveContextButtonPad() == null || !this.getActiveContextButtonPad().isMouseInOverlappingArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showContextButtonsInstantly(IFigure figure, Point mouse) {
        if (!this.replaceContextButtonPad(figure, mouse)) {
            return;
        }
        ContextButtonManagerForPad contextButtonManagerForPad = this;
        synchronized (contextButtonManagerForPad) {
            this.hideContextButtonsInstantly();
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getDiagramBehavior().getDiagramContainer().getGraphicalViewer().getRootEditPart();
            double zoom = rootEditPart.getZoomManager().getZoom();
            if (zoom < 0.75) {
                return;
            }
            IPictogramElementEditPart editPart = (IPictogramElementEditPart)this.getFigure2EditPart().get(figure);
            PictogramElement pe = editPart.getPictogramElement();
            if (pe instanceof Diagram) {
                return;
            }
            if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)pe)) {
                return;
            }
            PictogramElementContext context = new PictogramElementContext(pe);
            IToolBehaviorProvider toolBehaviorProvider = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            IContextButtonPadData contextButtonPadData = toolBehaviorProvider.getContextButtonPad((IPictogramElementContext)context);
            if (contextButtonPadData == null) {
                return;
            }
            if (contextButtonPadData.getDomainSpecificContextButtons().size() == 0 && contextButtonPadData.getGenericContextButtons().size() == 0 && contextButtonPadData.getCollapseContextButton() == null) {
                return;
            }
            if (!contextButtonPadData.getPadLocation().contains(mouse.x, mouse.y)) {
                return;
            }
            int declarationType = GFPreferences.getInstance().getContextButtonPadDeclaration();
            Object declaration = declarationType == 1 ? new SpecialContextButtonPadDeclaration(contextButtonPadData) : new StandardContextButtonPadDeclaration(contextButtonPadData);
            EditPart activeEditPart = this.getFigure2EditPart().get(figure);
            ContextButtonPad contextButtonPad = new ContextButtonPad(this, (IContextButtonPadDeclaration)declaration, zoom, this.getDiagramBehavior(), activeEditPart, this.resourceRegistry);
            this.setActive(figure, contextButtonPad);
            IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
            feedbackLayer.add((IFigure)contextButtonPad);
        }
    }

    @Override
    public void setContextButtonShowing(boolean enable) {
        this.contextButtonShowing = enable;
    }

    private boolean isContextButtonShowing() {
        return this.contextButtonShowing;
    }

    private void handleZoomChanged() {
        this.hideContextButtonsInstantly();
    }
}

