/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.remote.DefaultPreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.IC;
import org.eclipse.help.ui.internal.preferences.ICButtons;
import org.eclipse.help.ui.internal.preferences.ICPreferences;
import org.eclipse.help.ui.internal.preferences.ICTable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HelpContentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ICTable table;
    private ICButtons buttons;
    private Button searchLocalHelpOnly;
    private Button searchLocalHelpFirst;
    private Button searchLocalHelpLast;
    private Label descLabel;
    private final Listener changeListener = event -> {
        boolean isRemoteHelpEnabled = !this.searchLocalHelpOnly.getSelection();
        this.table.getTable().setEnabled(isRemoteHelpEnabled);
        this.buttons.setEnabled(isRemoteHelpEnabled);
    };

    public void init(IWorkbench workbench) {
    }

    public ICTable getTable() {
        return this.table;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        this.initializeDialogUnits((Control)parent);
        this.descLabel = new Label(parent, 0);
        this.descLabel.setText(Messages.HelpContentPage_title);
        Dialog.applyDialogFont((Control)this.descLabel);
        this.createSearchLocalHelpOnly(parent);
        this.createSearchLocalHelpFirst(parent);
        this.createSearchLocalHelpLast(parent);
        this.initializeTableEnablement(parent, this.searchLocalHelpOnly.getSelection());
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
        List<IC> ics = ICPreferences.getDefaultICs();
        this.table.setICs(ics);
        boolean remoteHelpOn = new DefaultPreferenceFileHandler().isRemoteHelpOn();
        boolean remoteHelpPreferred = new DefaultPreferenceFileHandler().isRemoteHelpPreferred();
        this.searchLocalHelpOnly.setSelection(!remoteHelpOn);
        this.searchLocalHelpFirst.setSelection(remoteHelpOn && !remoteHelpPreferred);
        this.searchLocalHelpLast.setSelection(remoteHelpOn && remoteHelpPreferred);
        this.changeListener.handleEvent(null);
    }

    public boolean performOk() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.putBoolean("remoteHelpOn", !this.searchLocalHelpOnly.getSelection());
        prefs.putBoolean("remoteHelpPreferred", this.searchLocalHelpLast.getSelection());
        List<IC> ics = this.table.getICs();
        ICPreferences.setICs(ics);
        RemoteHelp.notifyPreferenceChange();
        return super.performOk();
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private void createSearchLocalHelpOnly(Composite parent) {
        this.searchLocalHelpOnly = new Button(parent, 16);
        this.searchLocalHelpOnly.setText(Messages.SearchEmbeddedHelpOnly);
        this.searchLocalHelpOnly.addListener(13, this.changeListener);
        boolean isRemoteOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        this.searchLocalHelpOnly.setSelection(!isRemoteOn);
        Dialog.applyDialogFont((Control)this.searchLocalHelpOnly);
    }

    private void createSearchLocalHelpFirst(Composite parent) {
        this.searchLocalHelpFirst = new Button(parent, 16);
        this.searchLocalHelpFirst.setText(Messages.SearchEmbeddedHelpFirst);
        this.searchLocalHelpFirst.addListener(13, this.changeListener);
        boolean isRemoteOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        boolean isRemotePreferred = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpPreferred", false, null);
        this.searchLocalHelpFirst.setSelection(isRemoteOn && !isRemotePreferred);
        Dialog.applyDialogFont((Control)this.searchLocalHelpFirst);
    }

    private void createSearchLocalHelpLast(Composite parent) {
        this.searchLocalHelpLast = new Button(parent, 16);
        this.searchLocalHelpLast.setText(Messages.SearchEmbeddedHelpLast);
        this.searchLocalHelpLast.addListener(13, this.changeListener);
        boolean isRemoteOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        boolean isRemotePreferred = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpPreferred", false, null);
        this.searchLocalHelpLast.setSelection(isRemoteOn && isRemotePreferred);
        Dialog.applyDialogFont((Control)this.searchLocalHelpLast);
    }

    private void initializeTableEnablement(Composite parent, boolean isRemoteHelpDisabled) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        this.table = new ICTable(top);
        this.buttons = new ICButtons(top, this);
        this.changeListener.handleEvent(null);
    }
}

