/*******************************************************************************
 * Copyright (c) 2000, 2010 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jface.action.Action;

class ShowNextFailureAction extends Action {

	private TestRunnerViewPart fPart;

	public ShowNextFailureAction(TestRunnerViewPart part) {
		super(JUnitMessages.ShowNextFailureAction_label);
		setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/select_next.svg")); //$NON-NLS-1$
		setToolTipText(JUnitMessages.ShowNextFailureAction_tooltip);
		fPart= part;
	}

	@Override
	public void run() {
		fPart.selectNextFailure();
	}
}
