/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.metadataprocessors.internal.AbstractMetaDataEnabledType;
import org.eclipse.jst.jsf.metadataprocessors.internal.AttributeValueRuntimeTypeFactory;
import org.eclipse.jst.jsf.metadataprocessors.internal.AttributeValueRuntimeTypeRegistry;
import org.eclipse.jst.jsf.metadataprocessors.internal.IMetaDataEnabledFeatureExtension;
import org.eclipse.jst.jsf.metadataprocessors.internal.MetaDataEnabledFeatureExtension;

public class MetaDataEnabledFeatureRegistry {
    private static final String EXTPTID = "MetaDataEnabledFeatures";
    private Map<String, List<IMetaDataEnabledFeatureExtension>> featuresMap = new HashMap<String, List<IMetaDataEnabledFeatureExtension>>();
    private Map<String, Class> typeCacheMap = new HashMap<String, Class>();
    private static MetaDataEnabledFeatureRegistry INSTANCE;

    public static synchronized MetaDataEnabledFeatureRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataEnabledFeatureRegistry();
        }
        return INSTANCE;
    }

    private MetaDataEnabledFeatureRegistry() {
        this.readRegistry();
    }

    protected void readRegistry() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.jsf.core", EXTPTID);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    String bundleId = ext.getConfigurationElements()[j].getContributor().getName();
                    String id = ext.getConfigurationElements()[j].getAttribute("typeid");
                    String klass = ext.getConfigurationElements()[j].getAttribute("class");
                    this.registerFeature(bundleId, id, klass);
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Unable to read org.eclipse.jst.jsf.coreMetaDataEnabledFeatures registry");
        }
    }

    protected void registerFeature(String bundleID, String typeId, String klass) {
        MetaDataEnabledFeatureExtension aFeature = new MetaDataEnabledFeatureExtension(bundleID, typeId, klass);
        if (this.canCreateTypeForFeatureExtension(aFeature)) {
            if (!this.featuresMap.containsKey(typeId)) {
                ArrayList<MetaDataEnabledFeatureExtension> list = new ArrayList<MetaDataEnabledFeatureExtension>();
                list.add(aFeature);
                this.featuresMap.put(typeId, list);
            } else {
                List<IMetaDataEnabledFeatureExtension> list = this.featuresMap.get(typeId);
                if (list != null) {
                    list.add(aFeature);
                }
            }
        }
    }

    private boolean canCreateTypeForFeatureExtension(IMetaDataEnabledFeatureExtension feature) {
        if (!this.typeCacheMap.containsKey(feature.getTypeID())) {
            AbstractMetaDataEnabledType type = AttributeValueRuntimeTypeRegistry.getInstance().getType(feature.getTypeID());
            if (type != null) {
                Class typeClass = AttributeValueRuntimeTypeFactory.getInstance().getClassForType(type);
                this.typeCacheMap.put(feature.getTypeID(), typeClass);
            } else {
                return false;
            }
        }
        return this.typeCacheMap.get(feature.getTypeID()) != null;
    }

    public List<IMetaDataEnabledFeatureExtension> getFeatures(String typeId) {
        if (!this.featuresMap.containsKey(typeId)) {
            this.featuresMap.put(typeId, new ArrayList());
        }
        List<IMetaDataEnabledFeatureExtension> srcList = this.getExtensionsForId(typeId);
        ArrayList<IMetaDataEnabledFeatureExtension> ret = new ArrayList<IMetaDataEnabledFeatureExtension>(srcList.size());
        this.copy(ret, srcList);
        List<IMetaDataEnabledFeatureExtension> subs = this.getFeatureExtensionsForMatchingSubclass(typeId);
        for (IMetaDataEnabledFeatureExtension featureExt : subs) {
            if (ret.contains(featureExt)) continue;
            ret.add(featureExt);
        }
        return ret;
    }

    private void copy(List<IMetaDataEnabledFeatureExtension> destList, List<IMetaDataEnabledFeatureExtension> srcList) {
        Iterator<IMetaDataEnabledFeatureExtension> it = srcList.iterator();
        while (it.hasNext()) {
            destList.add(it.next());
        }
    }

    private List<IMetaDataEnabledFeatureExtension> getFeatureExtensionsForMatchingSubclass(String typeId) {
        AbstractMetaDataEnabledType type = AttributeValueRuntimeTypeRegistry.getInstance().getType(typeId);
        Class typeClass = AttributeValueRuntimeTypeFactory.getInstance().getClassForType(type);
        ArrayList<IMetaDataEnabledFeatureExtension> ret = new ArrayList<IMetaDataEnabledFeatureExtension>();
        for (String featureTypeId : this.typeCacheMap.keySet()) {
            Class featureTypeClass = this.typeCacheMap.get(featureTypeId);
            if (featureTypeClass == null || !featureTypeClass.isAssignableFrom(typeClass)) continue;
            ret.addAll(this.getExtensionsForId(featureTypeId));
        }
        return ret;
    }

    private List<IMetaDataEnabledFeatureExtension> getExtensionsForId(String featureTypeId) {
        List<IMetaDataEnabledFeatureExtension> list = this.featuresMap.get(featureTypeId);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }
}

