/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.actions.ActionsMessages;
import org.eclipse.jst.pagedesigner.editors.actions.SkinsMenuItemBuilder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.internal.Workbench;

public class ManageSkinsAction
extends Action {
    private static Menu lastMenu;

    public ManageSkinsAction() {
        super(ActionsMessages.getString("ManageSkinsAction.Text"), 4);
        this.setImageDescriptor(PDPlugin.getDefault().getImageDescriptor("skin.png"));
    }

    public void run() {
        IFile file;
        IProject project;
        IEditorInput editorInput;
        IEditorPart editorPart = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof HTMLEditor && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput && (project = (file = ((IFileEditorInput)editorInput).getFile()).getProject()) != null) {
            SelectionProvider selectionProvider = new SelectionProvider();
            selectionProvider.setSelection((ISelection)new StructuredSelection((Object)project));
            PropertyDialogAction propertyDialogAction = new PropertyDialogAction((IShellProvider)editorPart.getEditorSite(), (ISelectionProvider)selectionProvider);
            PreferenceDialog dialog = propertyDialogAction.createDialog();
            if (dialog != null) {
                dialog.setSelectedNode("org.eclipse.jst.pagedesigner.WPEPropertyPage");
                dialog = propertyDialogAction.createDialog();
                if (dialog != null) {
                    dialog.open();
                }
            }
        }
    }

    public IMenuCreator getMenuCreator() {
        return new MenuCreator();
    }

    private class MenuCreator
    implements IMenuCreator {
        private MenuCreator() {
        }

        public void dispose() {
            if (lastMenu != null) {
                lastMenu.dispose();
            }
        }

        public Menu getMenu(Control control) {
            this.dispose();
            lastMenu = new Menu(control);
            this.buildMenu(lastMenu);
            return lastMenu;
        }

        public Menu getMenu(Menu menu) {
            this.dispose();
            lastMenu = new Menu(menu);
            this.buildMenu(lastMenu);
            return lastMenu;
        }

        private void buildMenu(Menu menu) {
            IFile file;
            IProject project;
            IEditorInput editorInput;
            MenuItem menuItem = new MenuItem(lastMenu, 8);
            menuItem.setText(ActionsMessages.getString("ManageSkinsAction.Text"));
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    ManageSkinsAction.this.run();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }
            });
            IEditorPart editorPart = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editorPart instanceof HTMLEditor && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput && (project = (file = ((IFileEditorInput)editorInput).getFile()).getProject()) != null) {
                SkinsMenuItemBuilder skinsMenuItemBuilder = new SkinsMenuItemBuilder(project);
                skinsMenuItemBuilder.buildMenuItems(menu);
            }
        }
    }

    private class SelectionProvider
    implements ISelectionProvider {
        private ISelection selection;

        private SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }

        public ISelection getSelection() {
            return this.selection;
        }
    }
}

