/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnRename;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.columnRename.ColumnLabelPanel;
import org.eclipse.nebula.widgets.nattable.style.editor.AbstractStyleEditorDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnRenameDialog
extends AbstractStyleEditorDialog {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnRenameDialog.class);
    private ColumnLabelPanel columnLabelPanel;
    private final String columnLabel;
    private String renamedColumnLabel;

    public ColumnRenameDialog(Shell parent, String columnLabel, String renamedColumnLabel) {
        super(parent);
        this.columnLabel = columnLabel;
        this.renamedColumnLabel = renamedColumnLabel;
    }

    @Override
    protected void initComponents(final Shell shell) {
        GridLayout shellLayout = new GridLayout();
        shell.setLayout((Layout)shellLayout);
        shell.setText(Messages.getString("ColumnRenameDialog.shellTitle"));
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ColumnRenameDialog.this.doFormCancel(shell);
            }
        });
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData fillGridData = new GridData();
        fillGridData.grabExcessHorizontalSpace = true;
        fillGridData.horizontalAlignment = 4;
        panel.setLayoutData((Object)fillGridData);
        this.columnLabelPanel = new ColumnLabelPanel(panel, this.columnLabel, this.renamedColumnLabel);
        try {
            this.columnLabelPanel.edit(this.renamedColumnLabel);
        }
        catch (Exception e) {
            LOG.warn("Error on edit", (Throwable)e);
        }
    }

    @Override
    protected void doFormOK(Shell shell) {
        this.renamedColumnLabel = this.columnLabelPanel.getNewValue();
        shell.dispose();
    }

    @Override
    protected void doFormClear(Shell shell) {
        this.renamedColumnLabel = null;
        shell.dispose();
    }

    public String getNewColumnLabel() {
        return this.renamedColumnLabel;
    }
}

