/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.part;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public String getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public String getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(String visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(String visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static String getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLComponentDiagram".equals(view.getType())) {
                return "Package_ComponentDiagram";
            }
            return "";
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static String getVisualID(String type) {
        return type;
    }

    public static String getType(String visualID) {
        return visualID;
    }

    public static String getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        return "Package_ComponentDiagram";
    }

    public static String getNodeVisualID(View containerView, EObject domainElement) {
        block95: {
            String containerVisualID;
            if (domainElement == null) {
                return "";
            }
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLComponentDiagram".equals(containerModelID)) {
                return "";
            }
            if ("PapyrusUMLComponentDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_ComponentDiagram";
            } else {
                return "";
            }
            if (containerVisualID == null) break block95;
            switch (containerVisualID) {
                case "Package_ComponentDiagram": {
                    if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
                        return "Dependency_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape";
                    }
                    if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                        return "Model_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                        return "Interface_ClassifierShape";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape";
                    }
                    if (UMLPackage.eINSTANCE.getNamedElement().isSuperTypeOf(domainElement.eClass())) {
                        return "NamedElement_DefaultShape";
                    }
                    if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                    return "Interface_Shape";
                }
                case "Component_PackagedElementShape": {
                    if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                    return "Port_Shape";
                }
                case "Component_PackagedElementShape_CCN": {
                    if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                    return "Port_Shape";
                }
                case "Component_PackagedElementShape_CN": {
                    if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                    return "Port_Shape";
                }
                case "Property_Shape": {
                    if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                    return "Port_Shape";
                }
                case "Component_StructureCompartment": {
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape_CCN";
                    }
                    if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                    return "Property_Shape";
                }
                case "Model_PackagedElementCompartment": {
                    if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                        return "Interface_ClassifierShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                        return "Model_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CN";
                    }
                    if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                    return "Interface_Shape_CN";
                }
                case "Package_PackagedElementCompartment": {
                    if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                        return "Interface_ClassifierShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                        return "Model_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape_CN";
                    }
                    if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                    return "Interface_Shape_CN";
                }
                case "Model_PackagedElementCompartment_CN": {
                    if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                        return "Interface_ClassifierShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                        return "Model_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CN";
                    }
                    if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                    return "Interface_Shape_CN";
                }
                case "Package_PackagedElementCompartment_CN": {
                    if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                        return "Interface_ClassifierShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                        return "Model_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                        return "Package_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                        return "Comment_Shape_CN";
                    }
                    if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                        return "Constraint_Shape_CN";
                    }
                    if (!UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                    return "Interface_Shape_CN";
                }
                case "Component_StructureCompartment_CCN": {
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape_CCN";
                    }
                    if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                    return "Property_Shape";
                }
                case "Component_StructureCompartment_CN": {
                    if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                        return "Component_PackagedElementShape_CCN";
                    }
                    if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                    return "Property_Shape";
                }
                case "Interface_AttributeCompartment": {
                    if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                    return "Property_InterfaceAttributeLabel";
                }
                case "Interface_OperationCompartment": {
                    if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                        return "Operation_InterfaceOperationLabel";
                    }
                    if (!UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) break;
                    return "Reception_InterfaceReceptionLabel";
                }
                case "Interface_AttributeCompartment_CN": {
                    if (!UMLPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                    return "Property_InterfaceAttributeLabel";
                }
                case "Interface_OperationCompartment_CN": {
                    if (UMLPackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) {
                        return "Operation_InterfaceOperationLabel";
                    }
                    if (!UMLPackage.eINSTANCE.getReception().isSuperTypeOf(domainElement.eClass())) break;
                    return "Reception_InterfaceReceptionLabel";
                }
            }
        }
        return "";
    }

    public static boolean canCreateNode(View containerView, String nodeVisualID) {
        block200: {
            String containerVisualID;
            String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
            if (!"PapyrusUMLComponentDiagram".equals(containerModelID)) {
                return false;
            }
            if ("PapyrusUMLComponentDiagram".equals(containerModelID)) {
                containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
            } else if (containerView instanceof Diagram) {
                containerVisualID = "Package_ComponentDiagram";
            } else {
                return false;
            }
            if (containerVisualID == null) break block200;
            switch (containerVisualID) {
                case "Package_ComponentDiagram": {
                    if ("Dependency_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_PackagedElementShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interface_ClassifierShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("NamedElement_DefaultShape".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Dependency_Shape": {
                    if ("Dependency_MultiNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Dependency_FloatingNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_PackagedElementShape": {
                    if ("Component_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_FloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_StructureCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Port_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_Shape": {
                    if ("Model_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Model_PackagedElementCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_Shape": {
                    if ("Package_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Package_PackagedElementCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_ClassifierShape": {
                    if ("Interface_ClassifierNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interface_ClassifierFloatingNameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interface_AttributeCompartment".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_OperationCompartment".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape": {
                    if (!"Comment_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_Shape": {
                    if ("Constraint_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "NamedElement_DefaultShape": {
                    if (!"NamedElement_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_Shape": {
                    if ("Interface_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_FloatingNameLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Port_Shape": {
                    if ("Port_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Port_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_Shape_CN": {
                    if ("Model_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Model_PackagedElementCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_Shape_CN": {
                    if ("Package_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Package_PackagedElementCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_ClassifierShape_CN": {
                    if ("Interface_ClassifierNameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interface_ClassifierFloatingNameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Interface_AttributeCompartment_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_OperationCompartment_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_PackagedElementShape_CCN": {
                    if ("Component_NameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_FloatingNameLabel_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_StructureCompartment_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Port_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_PackagedElementShape_CN": {
                    if ("Component_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_FloatingNameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_StructureCompartment_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Port_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Comment_Shape_CN": {
                    if (!"Comment_BodyLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Constraint_Shape_CN": {
                    if ("Constraint_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Constraint_BodyLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_Shape_CN": {
                    if ("Interface_NameLabel_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_FloatingNameLabel_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Property_Shape": {
                    if ("Property_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Port_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_StructureCompartment": {
                    if ("Component_PackagedElementShape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Property_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_PackagedElementCompartment": {
                    if ("Interface_ClassifierShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_PackagedElementCompartment": {
                    if ("Interface_ClassifierShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Model_PackagedElementCompartment_CN": {
                    if ("Interface_ClassifierShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Package_PackagedElementCompartment_CN": {
                    if ("Interface_ClassifierShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Model_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Package_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Component_PackagedElementShape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Comment_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if ("Constraint_Shape_CN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Interface_Shape_CN".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_StructureCompartment_CCN": {
                    if ("Component_PackagedElementShape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Property_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Component_StructureCompartment_CN": {
                    if ("Component_PackagedElementShape_CCN".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Property_Shape".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_AttributeCompartment": {
                    if (!"Property_InterfaceAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_OperationCompartment": {
                    if ("Operation_InterfaceOperationLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Reception_InterfaceReceptionLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_AttributeCompartment_CN": {
                    if (!"Property_InterfaceAttributeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Interface_OperationCompartment_CN": {
                    if ("Operation_InterfaceOperationLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Reception_InterfaceReceptionLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Usage_Edge": {
                    if ("Usage_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Usage_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "InterfaceRealization_Edge": {
                    if ("InterfaceRealization_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"InterfaceRealization_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Generalization_Edge": {
                    if (!"Generalization_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Substitution_Edge": {
                    if ("Substitution_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Substitution_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Manifestation_Edge": {
                    if ("Manifestation_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Manifestation_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "ComponentRealization_Edge": {
                    if ("ComponentRealization_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"ComponentRealization_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Abstraction_Edge": {
                    if ("Abstraction_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Abstraction_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Dependency_Edge": {
                    if ("Dependency_NameLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Dependency_StereotypeLabel".equals(nodeVisualID)) break;
                    return true;
                }
                case "Connector_Edge": {
                    if ("Connector_StereotypeLabel".equals(nodeVisualID)) {
                        return true;
                    }
                    if (!"Connector_NameLabel".equals(nodeVisualID)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return "";
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass())) {
            return "Usage_Edge";
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass())) {
            return "InterfaceRealization_Edge";
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return "Generalization_Edge";
        }
        if (UMLPackage.eINSTANCE.getSubstitution().isSuperTypeOf(domainElement.eClass())) {
            return "Substitution_Edge";
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return "Manifestation_Edge";
        }
        if (UMLPackage.eINSTANCE.getComponentRealization().isSuperTypeOf(domainElement.eClass())) {
            return "ComponentRealization_Edge";
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass())) {
            return "Abstraction_Edge";
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return "Dependency_Edge";
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return "Dependency_BranchEdge";
        }
        if (UMLPackage.eINSTANCE.getConnector().isSuperTypeOf(domainElement.eClass())) {
            return "Connector_Edge";
        }
        return "";
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, String candidate) {
        if (candidate == null) {
            return false;
        }
        String basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return candidate.equals(basic);
    }

    public static boolean isCompartmentVisualID(String visualID) {
        block27: {
            if (visualID == null) break block27;
            switch (visualID) {
                case "Interface_AttributeCompartment": 
                case "Component_StructureCompartment": 
                case "Interface_OperationCompartment_CN": 
                case "Interface_OperationCompartment": 
                case "Package_PackagedElementCompartment": 
                case "Model_PackagedElementCompartment": 
                case "Model_PackagedElementCompartment_CN": 
                case "Component_StructureCompartment_CN": 
                case "Package_PackagedElementCompartment_CN": 
                case "Interface_AttributeCompartment_CN": 
                case "Component_StructureCompartment_CCN": {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(String visualID) {
        block32: {
            if (visualID == null) break block32;
            switch (visualID) {
                case "Package_ComponentDiagram": {
                    return false;
                }
                case "Port_Shape": 
                case "Constraint_Shape": 
                case "Dependency_Shape": 
                case "Interface_Shape_CN": 
                case "NamedElement_DefaultShape": 
                case "Comment_Shape": 
                case "Reception_InterfaceReceptionLabel": 
                case "Operation_InterfaceOperationLabel": 
                case "Property_InterfaceAttributeLabel": 
                case "Comment_Shape_CN": 
                case "Interface_Shape": 
                case "Constraint_Shape_CN": {
                    return true;
                }
            }
        }
        return false;
    }
}

