/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.modify.IFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class CompositeStructureInternalSourceToRepresentationDropBehaviorProvider
implements IInternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public Status drop(EObject droppedElement, EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (Status)new StructureCompositeDropOutsideRepresentationBehaviorProviderSwitch(oldContainer, newContainer, crossRef, editableChecker).doSwitch(droppedElement);
    }

    static class StructureCompositeDropOutsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<Status> {
        private static final String OWNED_ATTRIBUTE = UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().getName();
        private static final String NESTED_CLASSIFIER_REF = UMLPackage.eINSTANCE.getClass_NestedClassifier().getName();
        private static final String PACKAGED_ELEMENT_REF = UMLPackage.eINSTANCE.getPackage_PackagedElement().getName();
        private final EObject oldContainer;
        private final EObject newContainer;
        private final ECrossReferenceAdapter crossRef;
        private final IEditableChecker editableChecker;

        StructureCompositeDropOutsideRepresentationBehaviorProviderSwitch(EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
            this.oldContainer = oldContainer;
            this.newContainer = newContainer;
            this.crossRef = crossRef;
            this.editableChecker = editableChecker;
        }

        public Status caseClass(Class droppedClass) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedClass.eContainmentFeature().getName();
                Status dropStatus = modifier.removeValue(this.oldContainer, refName, droppedClass);
                if (State.DONE == dropStatus.getState()) {
                    if (this.newContainer instanceof Class) {
                        dropStatus = modifier.addValue(this.newContainer, NESTED_CLASSIFIER_REF, droppedClass);
                    } else if (this.newContainer instanceof Package) {
                        dropStatus = modifier.addValue(this.newContainer, PACKAGED_ELEMENT_REF, droppedClass);
                    }
                }
                return dropStatus;
            }
            return (Status)super.caseClass(droppedClass);
        }

        public Status caseCollaboration(Collaboration droppedCollaboration) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedCollaboration.eContainmentFeature().getName();
                Status dropStatus = modifier.removeValue(this.oldContainer, refName, droppedCollaboration);
                if (State.DONE == dropStatus.getState()) {
                    if (this.newContainer instanceof Class) {
                        dropStatus = modifier.addValue(this.newContainer, NESTED_CLASSIFIER_REF, droppedCollaboration);
                    } else if (this.newContainer instanceof Package) {
                        dropStatus = modifier.addValue(this.newContainer, PACKAGED_ELEMENT_REF, droppedCollaboration);
                    }
                }
                return dropStatus;
            }
            return (Status)super.caseCollaboration(droppedCollaboration);
        }

        public Status caseElement(Element droppedElement) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedElement.eContainmentFeature().getName();
                if (this.oldContainer.eClass().getEStructuralFeature(refName) != null && this.newContainer.eClass().getEStructuralFeature(refName) != null) {
                    Status dropStatus = modifier.removeValue(this.oldContainer, refName, droppedElement);
                    if (State.DONE == dropStatus.getState()) {
                        dropStatus = modifier.addValue(this.newContainer, refName, droppedElement);
                    }
                    return dropStatus;
                }
            }
            return (Status)super.caseElement(droppedElement);
        }

        public Status caseFunctionBehavior(FunctionBehavior functionBehavior) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                return this.handleBehavioredClassifier((BehavioredClassifier)functionBehavior, modifier);
            }
            return (Status)super.caseFunctionBehavior(functionBehavior);
        }

        public Status caseInformationItem(InformationItem droppedInformationItem) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedInformationItem.eContainmentFeature().getName();
                Status dropStatus = modifier.removeValue(this.oldContainer, refName, droppedInformationItem);
                if (State.DONE == dropStatus.getState()) {
                    if (this.newContainer instanceof Class) {
                        dropStatus = modifier.addValue(this.newContainer, NESTED_CLASSIFIER_REF, droppedInformationItem);
                    } else if (this.newContainer instanceof Package) {
                        dropStatus = modifier.addValue(this.newContainer, PACKAGED_ELEMENT_REF, droppedInformationItem);
                    }
                }
                return dropStatus;
            }
            return (Status)super.caseInformationItem(droppedInformationItem);
        }

        public Status caseInteraction(Interaction interaction) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                return this.handleBehavioredClassifier((BehavioredClassifier)interaction, modifier);
            }
            return (Status)super.caseInteraction(interaction);
        }

        public Status caseOpaqueBehavior(OpaqueBehavior opaqueBehavior) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                return this.handleBehavioredClassifier((BehavioredClassifier)opaqueBehavior, modifier);
            }
            return (Status)super.caseOpaqueBehavior(opaqueBehavior);
        }

        public Status caseParameter(Parameter parameter) {
            Status dropStatus = new Status(State.FAILED, null);
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = parameter.eContainmentFeature().getName();
                if (this.newContainer instanceof Behavior) {
                    dropStatus = modifier.addValue(this.newContainer, UMLPackage.eINSTANCE.getBehavior_OwnedParameter().getName(), parameter);
                }
                if (State.DONE == dropStatus.getState()) {
                    dropStatus = modifier.removeValue(this.oldContainer, refName, parameter);
                }
                return dropStatus;
            }
            return (Status)super.caseParameter(parameter);
        }

        public Status caseProperty(Property droppedProperty) {
            EObject oldSemanticContainer;
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer && (oldSemanticContainer = droppedProperty.eContainer()) != null) {
                String refName = droppedProperty.eContainingFeature().getName();
                EObject newSemanticContainer = this.getPropertyNewSemanticContainer();
                Status dropStatus = null;
                if (newSemanticContainer != null) {
                    dropStatus = modifier.removeValue(oldSemanticContainer, refName, droppedProperty);
                    if (State.DONE == dropStatus.getState()) {
                        dropStatus = modifier.addValue(newSemanticContainer, OWNED_ATTRIBUTE, droppedProperty);
                    }
                } else {
                    dropStatus = Status.createFailingStatus("Container should be a Structured Classifier or a Typed Property.");
                }
                return dropStatus;
            }
            return (Status)super.caseProperty(droppedProperty);
        }

        public Status caseProtocolStateMachine(ProtocolStateMachine protocolStateMachine) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                return this.handleBehavioredClassifier((BehavioredClassifier)protocolStateMachine, modifier);
            }
            return (Status)super.caseProtocolStateMachine(protocolStateMachine);
        }

        public Status caseStateMachine(StateMachine stateMachine) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                return this.handleBehavioredClassifier((BehavioredClassifier)stateMachine, modifier);
            }
            return (Status)super.caseStateMachine(stateMachine);
        }

        private Status handleBehavioredClassifier(BehavioredClassifier behavioredClassifier, IFeatureModifier modifier) {
            Status dropStatus = new Status(State.FAILED, null);
            String refName = behavioredClassifier.eContainmentFeature().getName();
            if (this.newContainer instanceof BehavioredClassifier && !(this.newContainer instanceof Collaboration)) {
                dropStatus = modifier.addValue(this.newContainer, UMLPackage.eINSTANCE.getBehavioredClassifier_OwnedBehavior().getName(), behavioredClassifier);
            } else if (this.newContainer instanceof Package) {
                dropStatus = modifier.addValue(this.newContainer, UMLPackage.eINSTANCE.getPackage_PackagedElement().getName(), behavioredClassifier);
            }
            if (State.DONE == dropStatus.getState()) {
                dropStatus = modifier.removeValue(this.oldContainer, refName, behavioredClassifier);
            }
            return dropStatus;
        }

        private EObject getPropertyNewSemanticContainer() {
            EObject newSemanticContainer = null;
            if (this.newContainer instanceof Property) {
                Type type = ((Property)this.newContainer).getType();
                if (type instanceof StructuredClassifier) {
                    newSemanticContainer = type;
                }
            } else if (this.newContainer instanceof StructuredClassifier) {
                newSemanticContainer = this.newContainer;
            }
            return newSemanticContainer;
        }
    }
}

