/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

public class EditorUtils {
    public static boolean saveEditorIfDirty(IEditorPart editor, String dialogTitle, String message) {
        if (editor.isDirty() && MessageDialog.openConfirm((Shell)editor.getEditorSite().getShell(), (String)dialogTitle, (String)message)) {
            IRunnableWithProgress saveRunnable = monitor -> editor.doSave(monitor);
            IWorkbenchWindow window = editor.getSite().getWorkbenchWindow();
            try {
                window.run(false, false, saveRunnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
        return !editor.isDirty();
    }

    public static final IFormPart findPartByClass(IManagedForm form, Class<? extends IFormPart> clazz) {
        IFormPart[] parts;
        IFormPart[] iFormPartArray = parts = form.getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part = iFormPartArray[n2];
            if (clazz.isInstance(part)) {
                return part;
            }
            ++n2;
        }
        return null;
    }

    public static final Action createHelpButton(final String url, String tooltipText) {
        Action btn = new Action("Help", 1){

            public void run() {
                Program.launch((String)url);
            }
        };
        btn.setEnabled(true);
        btn.setToolTipText(tooltipText);
        btn.setImageDescriptor(Resources.getImageDescriptor("help.svg"));
        return btn;
    }

    public static final ActionContributionItem createHelpButtonWithText(String url, String buttonText, String tooltipText) {
        Action btn = EditorUtils.createHelpButton(url, tooltipText);
        btn.setText(buttonText);
        ActionContributionItem helpContrib = new ActionContributionItem((IAction)btn);
        helpContrib.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        return helpContrib;
    }
}

