/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.tools.internal.uri.ViewpointProtocolParser;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class DiagramComponentizationHelper {
    private DiagramComponentizationHelper() {
    }

    public static Set<Layer> getContributedLayers(DiagramDescription diagramDescription, Collection<Viewpoint> viewpoints) {
        LinkedHashSet<Layer> result = new LinkedHashSet<Layer>();
        DiagramComponentizationHelper.processGetContributedLayers(diagramDescription, viewpoints, result, false);
        return Sets.newLinkedHashSet((Iterable)Iterables.filter(result, Layer.class));
    }

    private static void processGetContributedLayers(DiagramDescription diagramDescription, Collection<Viewpoint> viewpoints, Set<Layer> result, boolean addTransientLayers) {
        DiagramExtensionDescription diagramExtension;
        BasicEList foundDiagramContributors = new BasicEList();
        BasicEList newDiagramContributors = new BasicEList();
        for (Viewpoint viewpoint : viewpoints) {
            for (RepresentationExtensionDescription representationExtension : viewpoint.getOwnedRepresentationExtensions()) {
                if (!(representationExtension instanceof DiagramExtensionDescription) || !DiagramComponentizationHelper.match((RepresentationDescription)diagramDescription, (RepresentationExtensionDescription)(diagramExtension = (DiagramExtensionDescription)representationExtension))) continue;
                result.addAll((Collection<Layer>)diagramExtension.getLayers());
                foundDiagramContributors.add(diagramExtension);
            }
        }
        while (!foundDiagramContributors.isEmpty()) {
            for (Viewpoint viewpoint : viewpoints) {
                block4: for (RepresentationExtensionDescription representationExtension : viewpoint.getOwnedRepresentationExtensions()) {
                    if (!(representationExtension instanceof DiagramExtensionDescription)) continue;
                    diagramExtension = (DiagramExtensionDescription)representationExtension;
                    for (RepresentationExtensionDescription previouscontributorDiagramRepresentation : foundDiagramContributors) {
                        if (previouscontributorDiagramRepresentation == diagramExtension || !DiagramComponentizationHelper.match(previouscontributorDiagramRepresentation, (RepresentationExtensionDescription)diagramExtension)) continue;
                        result.addAll((Collection<Layer>)diagramExtension.getLayers());
                        newDiagramContributors.add(representationExtension);
                        continue block4;
                    }
                }
            }
            foundDiagramContributors.clear();
            foundDiagramContributors.addAll(newDiagramContributors);
            newDiagramContributors.clear();
        }
    }

    public static DiagramDescription getDiagramDescription(DiagramExtensionDescription diagramExtensionDescription, Collection<Viewpoint> viewpoints) {
        DiagramDescription diagramDescriptionFound = null;
        Iterator<Viewpoint> iterator = viewpoints.iterator();
        while (iterator.hasNext() && diagramDescriptionFound == null) {
            Viewpoint viewpoint = iterator.next();
            Iterator iterator2 = new ViewpointQuery(viewpoint).getAllRepresentationDescriptions().iterator();
            while (iterator2.hasNext() && diagramDescriptionFound == null) {
                RepresentationDescription representation = (RepresentationDescription)iterator2.next();
                if (!(representation instanceof DiagramDescription) || !DiagramComponentizationHelper.match(representation, (RepresentationExtensionDescription)diagramExtensionDescription)) continue;
                diagramDescriptionFound = (DiagramDescription)representation;
            }
            if (diagramDescriptionFound != null) continue;
            for (RepresentationExtensionDescription representation : new ViewpointQuery(viewpoint).getAllRepresentationExtensionDescriptions()) {
                DiagramExtensionDescription diagramExtensionDescription2;
                if (!(representation instanceof DiagramExtensionDescription) || !DiagramComponentizationHelper.match((RepresentationExtensionDescription)(diagramExtensionDescription2 = (DiagramExtensionDescription)representation), (RepresentationExtensionDescription)diagramExtensionDescription)) continue;
                diagramDescriptionFound = DiagramComponentizationHelper.getDiagramDescription(diagramExtensionDescription2, viewpoints);
            }
        }
        return diagramDescriptionFound;
    }

    private static boolean match(RepresentationExtensionDescription representationExtensionDescription, RepresentationExtensionDescription representationExtensionDescription2) {
        return DiagramComponentizationHelper.match((EObject)representationExtensionDescription, representationExtensionDescription.getName(), representationExtensionDescription2);
    }

    private static boolean match(RepresentationDescription representationDescription, RepresentationExtensionDescription representationExtensionDescription) {
        return DiagramComponentizationHelper.match((EObject)representationDescription, representationDescription.getName(), representationExtensionDescription);
    }

    private static boolean match(EObject desc, String descName, RepresentationExtensionDescription representationExtensionDescription) {
        EObject container = desc.eContainer();
        if (container != null) {
            String representationExtensionSiriusURI = representationExtensionDescription.getViewpointURI();
            if ((URI.decode((String)EcoreUtil.getURI((EObject)container).toString()).equals(representationExtensionSiriusURI) || ViewpointProtocolParser.match((URI)EcoreUtil.getURI((EObject)container), (String)representationExtensionSiriusURI)) && descName.matches(representationExtensionDescription.getRepresentationName())) {
                return true;
            }
        }
        return false;
    }
}

