/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.management;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.tools.api.management.ToolFilter;
import org.eclipse.sirius.diagram.tools.internal.management.ToolManagementRegistry;

public class ToolManagementRegistryListener
implements IRegistryEventListener {
    public static final String TOOL_MANAGEMENT_EXTENSION_POINT = "org.eclipse.sirius.diagram.toolManagement";
    private static final String TOOLFILTER_TAG_EXTENSION = "toolFilter";
    private static final String TOOLFILTER_CLASS_ATTRIBUTE = "class";

    public void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addListener((IRegistryEventListener)this, TOOL_MANAGEMENT_EXTENSION_POINT);
        this.parseInitialContributions();
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement elem = iConfigurationElementArray[n4];
                if (TOOLFILTER_TAG_EXTENSION.equals(elem.getName())) {
                    String extensionClassName = elem.getAttribute(TOOLFILTER_CLASS_ATTRIBUTE);
                    Collection<ToolFilter> providedToolFilters = ToolManagementRegistry.getInstance().getProvidedToolFilters();
                    for (ToolFilter toolFilter : providedToolFilters) {
                        if (!extensionClassName.equals(toolFilter.getClass().getName())) continue;
                        ToolManagementRegistry.getInstance().removeToolFilter(toolFilter);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(TOOL_MANAGEMENT_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                Object contribution = elem.createExecutableExtension(TOOLFILTER_CLASS_ATTRIBUTE);
                if (contribution instanceof ToolFilter) {
                    ToolManagementRegistry.getInstance().addToolFilter((ToolFilter)contribution);
                }
            }
            catch (CoreException e) {
                DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
    }

    public void dispose() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)this);
        ToolManagementRegistry.getInstance().dispose();
    }
}

