/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.core.ChannelHTTP;
import org.eclipse.tcf.core.ChannelPIPE;
import org.eclipse.tcf.core.ChannelTCP;
import org.eclipse.tcf.internal.core.ChannelLoop;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.ITransportProvider;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;

public class TransportManager {
    private static final Collection<AbstractChannel> channels = new LinkedList<AbstractChannel>();
    private static final Collection<Protocol.ChannelOpenListener> listeners = new LinkedList<Protocol.ChannelOpenListener>();
    private static final HashMap<String, ITransportProvider> transports = new HashMap();

    static {
        TransportManager.addTransportProvider(new ITransportProvider(){

            @Override
            public String getName() {
                return "TCP";
            }

            @Override
            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                Map<String, String> attrs = peer.getAttributes();
                String host = attrs.get("Host");
                String port = attrs.get("Port");
                if (host == null) {
                    throw new IllegalArgumentException("No host name");
                }
                return new ChannelTCP(peer, host, TransportManager.parsePort(port), false);
            }
        });
        TransportManager.addTransportProvider(new ITransportProvider(){

            @Override
            public String getName() {
                return "SSL";
            }

            @Override
            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                Map<String, String> attrs = peer.getAttributes();
                String host = attrs.get("Host");
                String port = attrs.get("Port");
                if (host == null) {
                    throw new IllegalArgumentException("No host name");
                }
                return new ChannelTCP(peer, host, TransportManager.parsePort(port), true);
            }
        });
        TransportManager.addTransportProvider(new ITransportProvider(){

            @Override
            public String getName() {
                return "PIPE";
            }

            @Override
            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                String name = peer.getAttributes().get("PipeName");
                if (name == null) {
                    name = "//./pipe/TCF-Agent";
                }
                return new ChannelPIPE(peer, name);
            }
        });
        TransportManager.addTransportProvider(new ITransportProvider(){

            @Override
            public String getName() {
                return "HTTP";
            }

            @Override
            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                Map<String, String> attrs = peer.getAttributes();
                String host = attrs.get("Host");
                String port = attrs.get("Port");
                if (host == null) {
                    throw new IllegalArgumentException("No host name");
                }
                return new ChannelHTTP(peer, host, TransportManager.parsePort(port));
            }
        });
        TransportManager.addTransportProvider(new ITransportProvider(){

            @Override
            public String getName() {
                return "Loop";
            }

            @Override
            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                return new ChannelLoop(peer);
            }
        });
    }

    private static int parsePort(String port) {
        if (port == null) {
            throw new Error("No port number");
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException x) {
            IllegalArgumentException y = new IllegalArgumentException("Invalid value of \"Port\" attribute. Must be decimal number.");
            y.initCause(x);
            throw y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTransportProvider(ITransportProvider transport) {
        String name = transport.getName();
        assert (name != null);
        HashMap<String, ITransportProvider> hashMap = transports;
        synchronized (hashMap) {
            if (transports.get(name) != null) {
                throw new Error("Already registered: " + name);
            }
            transports.put(name, transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTransportProvider(ITransportProvider transport) {
        String name = transport.getName();
        assert (name != null);
        HashMap<String, ITransportProvider> hashMap = transports;
        synchronized (hashMap) {
            if (transports.get(name) == transport) {
                transports.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IChannel openChannel(IPeer peer) {
        String name = peer.getTransportName();
        if (name == null) {
            throw new Error("No transport name");
        }
        ITransportProvider transport = null;
        HashMap<String, ITransportProvider> hashMap = transports;
        synchronized (hashMap) {
            transport = transports.get(name);
            if (transport == null) {
                throw new Error("Unknown transport name: " + name);
            }
        }
        return transport.openChannel(peer);
    }

    public static void channelOpened(AbstractChannel channel) {
        Protocol.ChannelOpenListener[] array;
        assert (!channels.contains(channel));
        channels.add(channel);
        Protocol.ChannelOpenListener[] channelOpenListenerArray = array = listeners.toArray(new Protocol.ChannelOpenListener[listeners.size()]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Protocol.ChannelOpenListener l = channelOpenListenerArray[n2];
            try {
                l.onChannelOpen(channel);
            }
            catch (Throwable x) {
                Protocol.log("Exception in channel listener", x);
            }
            ++n2;
        }
    }

    public static void channelClosed(AbstractChannel channel, Throwable x) {
        assert (channels.contains(channel));
        channels.remove(channel);
    }

    public static IChannel[] getOpenChannels() {
        return channels.toArray(new IChannel[channels.size()]);
    }

    public static void addChanelOpenListener(Protocol.ChannelOpenListener listener) {
        assert (listener != null);
        listeners.add(listener);
    }

    public static void removeChanelOpenListener(Protocol.ChannelOpenListener listener) {
        listeners.remove(listener);
    }

    public static void sendEvent(String service_name, String event_name, byte[] data) {
        for (AbstractChannel c : channels) {
            IService s;
            if (c.getState() != 1 || (s = c.getLocalService(service_name)) == null) continue;
            c.sendEvent(s, event_name, data);
        }
    }

    public static void sync(final Runnable done) {
        final HashSet<IToken> set = new HashSet<IToken>();
        ILocator.DoneSync done_sync = new ILocator.DoneSync(){

            @Override
            public void doneSync(IToken token) {
                if (!$assertionsDisabled && !set.contains(token)) {
                    throw new AssertionError();
                }
                set.remove(token);
                if (set.isEmpty()) {
                    done.run();
                }
            }
        };
        for (AbstractChannel c : channels) {
            ILocator s;
            if (c.getState() != 1 || (s = c.getRemoteService(ILocator.class)) == null) continue;
            set.add(s.sync(done_sync));
        }
        if (set.isEmpty()) {
            Protocol.invokeLater(done);
        }
    }
}

