/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.terminals.ui.launcher;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.terminals.core.interfaces.launcher.ITerminalsLauncher;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsLauncher;
import org.eclipse.tcf.te.tcf.terminals.ui.connector.TerminalsSettings;
import org.eclipse.tcf.te.tcf.terminals.ui.controls.TerminalsConfigurationPanel;
import org.eclipse.tcf.te.tcf.terminals.ui.launcher.TerminalsMementoHandler;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.tm.terminal.view.ui.internal.SettingsStore;
import org.eclipse.tm.terminal.view.ui.launcher.AbstractLauncherDelegate;

public class TerminalsLauncherDelegate
extends AbstractLauncherDelegate {
    private final IMementoHandler mementoHandler = new TerminalsMementoHandler();

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new TerminalsConfigurationPanel(container);
    }

    public boolean needsUserConfiguration() {
        return true;
    }

    public void execute(Map<String, Object> properties, final ITerminalService.Done done) {
        Object element;
        Assert.isNotNull(properties);
        ISelection selection = (ISelection)properties.get("selection");
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPeerNode) {
            final IPeerNode peerNode = (IPeerNode)element;
            final AtomicReference<IPeer> peer = new AtomicReference<IPeer>();
            if (Protocol.isDispatchThread()) {
                peer.set(peerNode.getPeer());
            } else {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        peer.set(peerNode.getPeer());
                    }
                });
            }
            if (peer.get() != null) {
                TerminalsLauncher launcher = new TerminalsLauncher();
                PropertiesContainer p = new PropertiesContainer();
                p.addProperties(properties);
                launcher.launch((IPeer)peer.get(), (IPropertiesContainer)p, (ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        done.done(status);
                    }
                });
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (IMementoHandler.class.equals((Object)adapter)) {
            return this.mementoHandler;
        }
        return super.getAdapter(adapter);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tcf.te.tcf.terminals.ui.TerminalsConnector";
        }
        OutputStream stdin = (OutputStream)properties.get("streams.stdin");
        InputStream stdout = (InputStream)properties.get("streams.stdout");
        InputStream stderr = (InputStream)properties.get("streams.stderr");
        Object value = properties.get("localEcho");
        boolean localEcho = value instanceof Boolean ? (Boolean)value : false;
        String lineSeparator = (String)properties.get("lineSeparator");
        ITerminalsLauncher launcher = (ITerminalsLauncher)properties.get("data");
        SettingsStore store = new SettingsStore();
        TerminalsSettings terminalsSettings = new TerminalsSettings();
        terminalsSettings.setStdinStream(stdin);
        terminalsSettings.setStdoutStream(stdout);
        terminalsSettings.setStderrStream(stderr);
        terminalsSettings.setLocalEcho(localEcho);
        terminalsSettings.setLineSeparator(lineSeparator);
        terminalsSettings.setTerminalsLauncher(launcher);
        terminalsSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.setDefaultSettings();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

