/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchModelCompareEditorInput;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriberMergeContext;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenInCompareAction
extends Action {
    private final ISynchronizePageConfiguration configuration;

    public OpenInCompareAction(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        Utils.initAction((IAction)this, "action.openInCompareEditor.");
    }

    public void run() {
        ISelection selection = this.configuration.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            if (!this.isOkToRun(selection)) {
                return;
            }
            boolean reuseEditorIfPossible = ((IStructuredSelection)selection).size() == 1;
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof SyncInfoModelElement) {
                    SyncInfo info = ((SyncInfoModelElement)obj).getSyncInfo();
                    if (info == null) continue;
                    OpenInCompareAction.openCompareEditorOnSyncInfo(this.configuration, info, !OpenStrategy.activateOnOpen(), reuseEditorIfPossible);
                    continue;
                }
                if (obj == null) continue;
                OpenInCompareAction.openCompareEditor(this.configuration, obj, !OpenStrategy.activateOnOpen(), reuseEditorIfPossible);
            }
        }
    }

    private boolean isOkToRun(ISelection selection) {
        Object[] elements = ((IStructuredSelection)selection).toArray();
        ISynchronizeParticipant participant = this.configuration.getParticipant();
        if (participant instanceof ModelSynchronizeParticipant) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (!msp.hasCompareInputFor(element)) {
                    return false;
                }
                ++n2;
            }
        } else {
            IResource[] resources;
            IResource[] iResourceArray = resources = Utils.getResources(elements);
            int n = resources.length;
            int n3 = 0;
            while (n3 < n) {
                IResource resource = iResourceArray[n3];
                if (resource.getType() != 1) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    public static IEditorInput openCompareEditor(ISynchronizePageConfiguration configuration, Object object, boolean keepFocus, boolean reuseEditorIfPossible) {
        SyncInfo info;
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)configuration);
        ISynchronizeParticipant participant = configuration.getParticipant();
        ISynchronizePageSite site = configuration.getSite();
        if (object instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)object).getSyncInfo()) != null) {
            return OpenInCompareAction.openCompareEditorOnSyncInfo(configuration, info, keepFocus, reuseEditorIfPossible);
        }
        if (participant instanceof ModelSynchronizeParticipant) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            ICompareInput input = msp.asCompareInput(object);
            IWorkbenchPage workbenchPage = OpenInCompareAction.getWorkbenchPage(site);
            if (input != null && workbenchPage != null && OpenInCompareAction.isOkToOpen(site, participant, input)) {
                if (OpenInCompareAction.isApplyPatchModelPresent(configuration)) {
                    return OpenInCompareAction.openCompareEditor(workbenchPage, new ApplyPatchModelCompareEditorInput(msp, input, workbenchPage, configuration), keepFocus, site, reuseEditorIfPossible);
                }
                return OpenInCompareAction.openCompareEditor(workbenchPage, new ModelCompareEditorInput(msp, input, workbenchPage, configuration), keepFocus, site, reuseEditorIfPossible);
            }
        }
        return null;
    }

    private static boolean isApplyPatchModelPresent(ISynchronizePageConfiguration configuration) {
        Object object = configuration.getProperty("org.eclipse.team.ui.synchronizationContext");
        return object instanceof ApplyPatchSubscriberMergeContext;
    }

    private static boolean isOkToOpen(ISynchronizePageSite site, ISynchronizeParticipant participant, ICompareInput input) {
        if (participant instanceof ModelSynchronizeParticipant && input instanceof ISynchronizationCompareInput) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            boolean[] result = new boolean[1];
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
                    try {
                        blArray[0] = msp.checkForBufferChange(site.getShell(), (ISynchronizationCompareInput)input, true, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                Utils.handleError(site.getShell(), e, null, null);
            }
            catch (InterruptedException e) {
                return false;
            }
            return result[0];
        }
        return true;
    }

    public static CompareEditorInput openCompareEditorOnSyncInfo(ISynchronizePageConfiguration configuration, SyncInfo info, boolean keepFocus, boolean reuseEditorIfPossible) {
        Assert.isNotNull((Object)info);
        Assert.isNotNull((Object)configuration);
        if (info.getLocal().getType() != 1) {
            return null;
        }
        SyncInfoCompareInput input = new SyncInfoCompareInput(configuration, info);
        return OpenInCompareAction.openCompareEditor(OpenInCompareAction.getWorkbenchPage(configuration.getSite()), input, keepFocus, configuration.getSite(), reuseEditorIfPossible);
    }

    public static CompareEditorInput openCompareEditor(ISynchronizeParticipant participant, SyncInfo info, ISynchronizePageSite site) {
        Assert.isNotNull((Object)info);
        Assert.isNotNull((Object)participant);
        if (info.getLocal().getType() != 1) {
            return null;
        }
        SyncInfoCompareInput input = new SyncInfoCompareInput(participant, info);
        return OpenInCompareAction.openCompareEditor(OpenInCompareAction.getWorkbenchPage(site), input, false, site, false);
    }

    private static CompareEditorInput openCompareEditor(IWorkbenchPage page, CompareEditorInput input, boolean keepFocus, ISynchronizePageSite site, boolean reuseEditorIfPossible) {
        if (page == null) {
            return null;
        }
        OpenInCompareAction.openCompareEditor(input, page, reuseEditorIfPossible);
        if (site != null && keepFocus) {
            site.setFocus();
        }
        return input;
    }

    private static IWorkbenchPage getWorkbenchPage(ISynchronizePageSite site) {
        IWorkbenchPage page = null;
        if (site == null || site.getWorkbenchSite() == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        } else {
            page = site.getWorkbenchSite().getPage();
        }
        return page;
    }

    public static void openCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        OpenInCompareAction.openCompareEditor(input, page, true);
    }

    public static void openCompareEditor(CompareEditorInput input, IWorkbenchPage page, boolean reuseEditorIfPossible) {
        if (page == null || input == null) {
            return;
        }
        IEditorPart editor = Utils.findReusableCompareEditor(input, page, new Class[]{SyncInfoCompareInput.class, ModelCompareEditorInput.class});
        if (editor != null && reuseEditorIfPossible) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals(input)) {
                page.activate((IWorkbenchPart)editor);
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                page.activate((IWorkbenchPart)editor);
            }
        } else {
            CompareUI.openCompareEditorOnPage((CompareEditorInput)input, (IWorkbenchPage)page);
        }
    }

    public static IEditorPart findOpenCompareEditor(IWorkbenchPartSite site, IResource resource) {
        IEditorReference[] editorRefs;
        IWorkbenchPage page = site.getPage();
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart part = editorRef.getEditor(false);
            if (part != null) {
                SyncInfo inputInfo;
                IEditorInput input = part.getEditorInput();
                if (part != null && input instanceof SyncInfoCompareInput && (inputInfo = ((SyncInfoCompareInput)input).getSyncInfo()).getLocal().equals((Object)resource)) {
                    return part;
                }
            }
            ++n2;
        }
        return null;
    }

    public static IEditorPart findOpenCompareEditor(IWorkbenchPartSite site, Object object, ISynchronizeParticipant participant) {
        IEditorReference[] editorRefs;
        if (object instanceof SyncInfoModelElement) {
            SyncInfoModelElement element = (SyncInfoModelElement)object;
            SyncInfo info = element.getSyncInfo();
            return OpenInCompareAction.findOpenCompareEditor(site, info.getLocal());
        }
        IWorkbenchPage page = site.getPage();
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorInput input;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart part = editorRef.getEditor(false);
            if (part != null && (input = part.getEditorInput()) instanceof ModelCompareEditorInput && ((ModelCompareEditorInput)input).matches(object, participant)) {
                return part;
            }
            ++n2;
        }
        return null;
    }
}

