/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.splash;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.splash.AbstractSplashHandler;

public abstract class BasicSplashHandler
extends AbstractSplashHandler {
    private static final String SPLASH_PROGRESS_PART_ID = "org-eclipse-ui-splash-progressPart";
    private static final String SPLASH_PROGRESS_INDICATOR_ID = "org-eclipse-ui-splash-progressIndicator";
    private static final String SPLASH_PROGRESS_TEXT_ID = "org-eclipse-ui-splash-progressText";
    private Color foreground = null;
    private AbsolutePositionProgressMonitorPart monitor;
    private Rectangle messageRect;
    private Rectangle progressRect;

    @Override
    public IProgressMonitor getBundleProgressMonitor() {
        if (this.monitor == null) {
            Composite parent = new Composite((Composite)this.getSplash(), Window.getDefaultOrientation());
            Point size = this.getSplash().getSize();
            parent.setBounds(new Rectangle(0, 0, size.x, size.y));
            this.monitor = new AbsolutePositionProgressMonitorPart(parent);
            this.monitor.setSize(size);
            if (this.progressRect != null) {
                this.monitor.getProgressIndicator().setBounds(this.progressRect);
            } else {
                this.monitor.getProgressIndicator().setVisible(false);
            }
            if (this.messageRect != null) {
                this.monitor.getProgressText().setBounds(this.messageRect);
            } else {
                this.monitor.getProgressText().setVisible(false);
            }
            if (this.foreground != null) {
                this.monitor.getProgressText().setForeground(this.foreground);
            }
            this.monitor.setBackgroundMode(2);
            this.monitor.setBackgroundImage(this.getSplash().getShell().getBackgroundImage());
        }
        return this.monitor;
    }

    protected void setForeground(RGB foregroundRGB) {
        if (this.monitor != null) {
            return;
        }
        this.foreground = new Color((Device)this.getSplash().getShell().getDisplay(), foregroundRGB);
    }

    protected Color getForeground() {
        return this.foreground;
    }

    protected void setMessageRect(Rectangle messageRect) {
        this.messageRect = messageRect;
    }

    protected void setProgressRect(Rectangle progressRect) {
        this.progressRect = progressRect;
    }

    protected Composite getContent() {
        return (Composite)this.getBundleProgressMonitor();
    }

    private void updateUI(final Runnable r) {
        Shell splashShell = this.getSplash();
        if (splashShell == null || splashShell.isDisposed()) {
            return;
        }
        Display display = splashShell.getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            StartupThreading.StartupRunnable startupRunnable = new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    r.run();
                }
            };
            display.asyncExec((Runnable)startupRunnable);
        }
    }

    class AbsolutePositionProgressMonitorPart
    extends ProgressMonitorPart {
        public AbsolutePositionProgressMonitorPart(Composite parent) {
            super(parent, null);
            this.setLayout(null);
            this.setCSSData();
        }

        private void setCSSData() {
            this.setData("org.eclipse.e4.ui.css.id", BasicSplashHandler.SPLASH_PROGRESS_PART_ID);
            this.fProgressIndicator.setData("org.eclipse.e4.ui.css.id", (Object)BasicSplashHandler.SPLASH_PROGRESS_INDICATOR_ID);
            this.fLabel.setData("org.eclipse.e4.ui.css.id", (Object)BasicSplashHandler.SPLASH_PROGRESS_TEXT_ID);
        }

        public ProgressIndicator getProgressIndicator() {
            return this.fProgressIndicator;
        }

        public Label getProgressText() {
            return this.fLabel;
        }

        public void beginTask(String name, int totalWork) {
            BasicSplashHandler.this.updateUI(() -> {
                if (this.isDisposed()) {
                    return;
                }
                AbsolutePositionProgressMonitorPart.super.beginTask(name, totalWork);
            });
        }

        public void done() {
            BasicSplashHandler.this.updateUI(() -> {
                if (this.isDisposed()) {
                    return;
                }
                AbsolutePositionProgressMonitorPart.super.done();
            });
        }

        public void internalWorked(double work) {
            BasicSplashHandler.this.updateUI(() -> {
                if (this.isDisposed()) {
                    return;
                }
                AbsolutePositionProgressMonitorPart.super.internalWorked(work);
            });
        }

        public void setFont(Font font) {
            BasicSplashHandler.this.updateUI(() -> {
                if (this.isDisposed()) {
                    return;
                }
                AbsolutePositionProgressMonitorPart.super.setFont(font);
            });
        }

        protected void updateLabel() {
            BasicSplashHandler.this.updateUI(() -> {
                if (this.isDisposed()) {
                    return;
                }
                AbsolutePositionProgressMonitorPart.super.updateLabel();
            });
        }
    }
}

