/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.modelmanipulation;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.AbstractModelManipulations;
import org.eclipse.viatra.transformation.runtime.emf.modelmanipulation.ModelManipulationException;

public class ModelManipulationWithEditingDomain
extends AbstractModelManipulations {
    EditingDomain domain;

    public ModelManipulationWithEditingDomain(ViatraQueryEngine engine, EditingDomain domain) {
        super(engine);
        this.domain = domain;
    }

    @Override
    protected int doCount(EObject container, EStructuralFeature feature) throws ModelManipulationException {
        ReadSlotCommand command = new ReadSlotCommand(container, feature, Collection::size);
        this.executeCommand((Command)command);
        return (Integer)command.getResult().iterator().next();
    }

    @Override
    protected Stream<? extends Object> doStream(EObject container, EStructuralFeature feature) throws ModelManipulationException {
        ReadSlotCommand command = new ReadSlotCommand(container, feature, Collection::stream);
        this.executeCommand((Command)command);
        return (Stream)command.getResult().iterator().next();
    }

    @Override
    protected boolean doIsSetTo(EObject container, EStructuralFeature feature, Object value) throws ModelManipulationException {
        ReadSlotCommand command = new ReadSlotCommand(container, feature, slotValues -> slotValues.contains(value));
        this.executeCommand((Command)command);
        return (Boolean)command.getResult().iterator().next();
    }

    @Override
    protected EObject doCreate(Resource res, EClass clazz) throws ModelManipulationException {
        EObject obj = EcoreUtil.create((EClass)clazz);
        AddCommand createCommand = new AddCommand(this.domain, res.getContents(), (Object)obj);
        this.executeCommand((Command)createCommand);
        return obj;
    }

    @Override
    protected EObject doCreate(EObject container, EReference reference, EClass clazz) throws ModelManipulationException {
        EObject obj = EcoreUtil.create((EClass)clazz);
        Command command = reference.isMany() ? AddCommand.create((EditingDomain)this.domain, (Object)container, (Object)reference, (Object)obj) : SetCommand.create((EditingDomain)this.domain, (Object)container, (Object)reference, (Object)obj);
        this.executeCommand(command);
        return obj;
    }

    @Override
    protected void doAdd(EObject container, EStructuralFeature feature, Collection<? extends Object> elements) throws ModelManipulationException {
        Command addCommand = AddCommand.create((EditingDomain)this.domain, (Object)container, (Object)feature, elements);
        this.executeCommand(addCommand);
    }

    @Override
    protected void doAdd(EObject container, EStructuralFeature feature, Object element, int index) throws ModelManipulationException {
        Command addCommand = AddCommand.create((EditingDomain)this.domain, (Object)container, (Object)feature, (Object)element, (int)index);
        this.executeCommand(addCommand);
    }

    @Override
    protected void doSet(EObject container, EStructuralFeature feature, Object value) throws ModelManipulationException {
        Command setCommand = SetCommand.create((EditingDomain)this.domain, (Object)container, (Object)feature, (Object)(value != null ? value : SetCommand.UNSET_VALUE));
        this.executeCommand(setCommand);
    }

    @Override
    protected void doRemove(EObject object) throws ModelManipulationException {
        Object removeCommand = null;
        removeCommand = object.eContainer() != null ? RemoveCommand.create((EditingDomain)this.domain, (Object)object.eContainer(), (Object)object.eContainingFeature(), (Object)object) : new RemoveCommand(this.domain, object.eResource().getContents(), (Object)object);
        this.executeCommand((Command)removeCommand);
    }

    @Override
    protected void doRemove(EObject container, EStructuralFeature feature, Object element) throws ModelManipulationException {
        Command removeCommand = RemoveCommand.create((EditingDomain)this.domain, (Object)container, (Object)feature, (Object)element);
        if (removeCommand.canExecute()) {
            this.executeCommand(removeCommand);
        }
    }

    @Override
    protected void doRemove(EObject container, EStructuralFeature feature, int index) throws ModelManipulationException {
        RemoveFromIndexCommand removeCommand = new RemoveFromIndexCommand(this.domain, container, feature, index);
        this.executeCommand((Command)removeCommand);
    }

    @Override
    protected void doRemove(EObject container, EStructuralFeature reference) throws ModelManipulationException {
        Collection list = (Collection)container.eGet(reference);
        Command removeCommand = RemoveCommand.create((EditingDomain)this.domain, (Object)container, (Object)reference, (Collection)list);
        this.executeCommand(removeCommand);
    }

    @Override
    protected void doMoveTo(EObject what, Resource newContainer) throws ModelManipulationException {
        MoveEObjectCommand moveCommand = new MoveEObjectCommand(this.domain, newContainer.getContents(), what);
        this.executeCommand((Command)moveCommand);
    }

    @Override
    protected void doMoveTo(EObject what, EObject newContainer, EReference reference, int index) throws ModelManipulationException {
        MoveEObjectCommand moveCommand = new MoveEObjectCommand(this.domain, newContainer, (EStructuralFeature)reference, what, index);
        this.executeCommand((Command)moveCommand);
    }

    @Override
    protected void doMoveTo(EObject what, EObject newContainer, EReference reference) throws ModelManipulationException {
        MoveEObjectCommand moveCommand = new MoveEObjectCommand(this.domain, newContainer, (EStructuralFeature)reference, what);
        this.executeCommand((Command)moveCommand);
    }

    @Override
    protected void doMoveTo(EObject what, Resource newContainer, int index) throws ModelManipulationException {
        MoveEObjectCommand moveCommand = new MoveEObjectCommand(this.domain, newContainer.getContents(), what, index);
        this.executeCommand((Command)moveCommand);
    }

    protected void executeCommand(Command command) throws ModelManipulationException {
        if (!command.canExecute()) {
            throw new ModelManipulationException("Cannot execute command");
        }
        this.domain.getCommandStack().execute(command);
    }

    @Override
    protected void doChangeIndex(EObject container, EStructuralFeature feature, int oldIndex, int newIndex) throws ModelManipulationException {
        ChangeIndexCommand changeIndexCommand = new ChangeIndexCommand(this.domain, container, feature, oldIndex, newIndex);
        this.executeCommand((Command)changeIndexCommand);
    }

    private class ChangeIndexCommand
    extends AbstractOverrideableCommand {
        EObject owner;
        EStructuralFeature feature;
        int oldIndex;
        int newIndex;

        public ChangeIndexCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, int oldIndex, int newIndex) {
            super(domain);
            this.oldIndex = -1;
            this.newIndex = -1;
            this.owner = owner;
            this.feature = feature;
            this.oldIndex = oldIndex;
            this.newIndex = newIndex;
        }

        public void doExecute() {
            EList featureValue = (EList)this.owner.eGet(this.feature);
            featureValue.move(this.newIndex, this.oldIndex);
        }

        public boolean doCanExecute() {
            return this.oldIndex != -1 && this.newIndex != -1 && this.feature != null && this.owner != null;
        }

        public void doUndo() {
            throw new UnsupportedOperationException("Undoing index change is not supported.");
        }

        public void doRedo() {
            throw new UnsupportedOperationException("Redoing index change is not supported.");
        }
    }

    private class MoveEObjectCommand
    extends AddCommand {
        public MoveEObjectCommand(EditingDomain domain, EList<?> list, Object value) {
            super(domain, list, value);
        }

        public MoveEObjectCommand(EditingDomain domain, EList<?> list, Object value, int index) {
            super(domain, list, value, index);
        }

        public MoveEObjectCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
            super(domain, owner, feature, value);
        }

        public MoveEObjectCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
            super(domain, owner, feature, value, index);
        }

        public void doExecute() {
            if (this.index == -1) {
                try {
                    for (Object obj : this.collection) {
                        ModelManipulationWithEditingDomain.this.getBaseEMFIndex().cheapMoveTo((EObject)obj, this.owner, (EReference)this.feature);
                    }
                }
                catch (ViatraQueryException e) {
                    throw new WrappedException((Exception)new ModelManipulationException(e));
                }
            } else {
                ((EList)this.owner.eGet(this.feature)).addAll(this.index, this.collection);
            }
        }

        public void doUndo() {
            throw new UnsupportedOperationException("Undoing VIATRA move is not supported.");
        }
    }

    private abstract class ReadCommand
    extends AbstractCommand {
        Collection<Object> result = Collections.emptySet();

        private ReadCommand() {
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
        }

        public Collection<?> getResult() {
            return this.result;
        }
    }

    private class ReadSlotCommand
    extends ReadCommand {
        EObject container;
        EStructuralFeature feature;
        Function<Collection<Object>, Object> extractResult;

        protected ReadSlotCommand(EObject container, EStructuralFeature feature, Function<Collection<Object>, Object> extractResult) {
            this.container = container;
            this.feature = feature;
            this.extractResult = extractResult;
        }

        public Collection<?> getAffectedObjects() {
            return Collections.singleton(this.container);
        }

        public void execute() {
            Collection<Object> slotValues = ModelManipulationWithEditingDomain.getSlotValuesInternal(this.container, this.feature);
            Object resultValue = this.extractResult.apply(slotValues);
            this.result = Collections.singleton(resultValue);
        }
    }

    private class RemoveFromIndexCommand
    extends RemoveCommand {
        int index;

        public RemoveFromIndexCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, int index) {
            super(domain, owner, feature, ((EList)owner.eGet(feature)).get(index));
            this.index = -1;
            this.index = index;
        }

        public void doExecute() {
            if (this.index == -1) {
                throw new IllegalArgumentException("Index is not specified");
            }
            ((EList)this.owner.eGet(this.feature)).remove(this.index);
        }

        public void doUndo() {
            throw new UnsupportedOperationException("Undoing remove index is not supported.");
        }
    }
}

