/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.transformation.batch;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ConflictSetIterator;
import org.eclipse.viatra.transformation.evm.api.IExecutor;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictSet;
import org.eclipse.viatra.transformation.evm.api.resolver.ScopedConflictSet;
import org.eclipse.viatra.transformation.runtime.emf.filters.MatchParameterFilter;
import org.eclipse.viatra.transformation.runtime.emf.rules.BatchTransformationRuleGroup;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformation;

public class BatchTransformationStatements {
    private static final String FIRE_ONE_TRANSACTION_FILTER_RULE_NAME = "Fire_one_transaction_filter_ruleName: ";
    private static final String FIRE_ONE_TRANSACTION_RULE_NAME = "Fire_one_transaction_ruleName: ";
    private static final String FIRE_UNTIL_TRANSACTION_CONDITION_RULE_NAME = "Fire_until_transaction_condition_ruleName: ";
    private static final String FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME = "Fire_until_transaction_filter_condition_ruleName: ";
    private static final String FIRE_UNTIL_TRANSACTION_CONDITION_RULE_GROUP = "Fire_until_transaction_condition_ruleGroup";
    private static final String FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_NAME = "Fire_while_possible_transaction_ruleName: ";
    private static final String FIRE_WHILE_POSSIBLE_TRANSACTION_FILTER_RULE_NAME = "Fire_while_possible_transaction_filter_ruleName: ";
    private static final String FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_GROUP = "Fire_while_possible_transaction_ruleGroup";
    private static final String FIRE_ALL_CURRENT_TRANSACTION_RULE_NAME = "Fire_all_current_transaction_ruleName: ";
    private static final String FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME = "Fire_all_current_transaction_filter_ruleName: ";
    private final ViatraQueryEngine queryEngine;
    private final RuleEngine ruleEngine;
    private final IExecutor executor;
    private final BatchTransformation transformation;

    BatchTransformationStatements(BatchTransformation transformation, IExecutor executor) {
        this.transformation = transformation;
        this.ruleEngine = transformation.ruleEngine;
        this.executor = executor;
        this.queryEngine = transformation.queryEngine;
    }

    public <Match extends IPatternMatch> void fireUntil(BatchTransformationRule<Match, ?> rule, Predicate<Match> breakCondition) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_NAME + rule.getName());
        this.fireUntil(rule.getRuleSpecification(), breakCondition, rule.getFilter());
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_NAME + rule.getName());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> void fireUntil(BatchTransformationRule<Match, ?> rule, Predicate<Match> breakCondition, Map.Entry<String, ?> ... filterParameters) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
        this.fireUntil(rule.getRuleSpecification(), breakCondition, new MatchParameterFilter(filterParameters));
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireUntil(BatchTransformationRule<Match, ?> rule, Predicate<Match> breakCondition, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
        this.fireUntil(rule.getRuleSpecification(), breakCondition, filter);
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_FILTER_CONDITION_RULE_NAME + rule.getName());
    }

    public void fireUntil(BatchTransformationRuleGroup rules, Predicate<IPatternMatch> breakCondition) {
        this.executor.startExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_GROUP);
        this.registerRulesInternal(rules);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(rules.getFilteredRuleMap());
        this.executor.execute((Iterator)new ConflictSetIterator((ConflictSet)conflictSet, breakCondition));
        conflictSet.dispose();
        this.executor.endExecution(FIRE_UNTIL_TRANSACTION_CONDITION_RULE_GROUP);
    }

    public void fireUntil(Predicate<IPatternMatch> breakCondition) {
        this.fireUntil(this.transformation.getTransformationRuleGroup(), breakCondition);
    }

    public <Match extends IPatternMatch> void fireWhilePossible(BatchTransformationRule<Match, ?> rule) {
        this.executor.startExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_NAME + rule.getName());
        this.fireUntil(rule, (Match it) -> false);
        this.executor.endExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireWhilePossible(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireUntil(rule, (Match it) -> false, filter);
        this.executor.endExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    public void fireWhilePossible(BatchTransformationRuleGroup rules) {
        this.executor.startExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_GROUP);
        this.fireUntil(rules, (IPatternMatch it) -> false);
        this.executor.endExecution(FIRE_WHILE_POSSIBLE_TRANSACTION_RULE_GROUP);
    }

    public void fireWhilePossible() {
        this.fireWhilePossible(this.transformation.getTransformationRuleGroup());
    }

    public <Match extends IPatternMatch> void fireAllCurrent(BatchTransformationRule<Match, ?> rule) {
        this.executor.startExecution(FIRE_ALL_CURRENT_TRANSACTION_RULE_NAME + rule.getName());
        this.fireAllCurrent(rule.getRuleSpecification(), rule.getFilter());
        this.executor.endExecution(FIRE_ALL_CURRENT_TRANSACTION_RULE_NAME + rule.getName());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> void fireAllCurrent(BatchTransformationRule<Match, ?> rule, Map.Entry<String, ?> ... parameterFilter) {
        this.executor.startExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireAllCurrent(rule.getRuleSpecification(), new MatchParameterFilter(parameterFilter));
        this.executor.endExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireAllCurrent(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireAllCurrent(rule.getRuleSpecification(), filter);
        this.executor.endExecution(FIRE_ALL_CURRENT_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    @Deprecated
    public <Match extends IPatternMatch> boolean registerRule(RuleSpecification<Match> ruleSpecification) {
        return this.registerRule(ruleSpecification, ruleSpecification.createEmptyFilter());
    }

    @Deprecated
    public <Match extends IPatternMatch> boolean registerRule(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        return this.registerRuleInternal(ruleSpecification, filter);
    }

    private <Match extends IPatternMatch> boolean registerRuleInternal(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        return this.ruleEngine.addRule(ruleSpecification, filter);
    }

    @Deprecated
    public void registerRules(BatchTransformationRuleGroup rules) {
        this.registerRulesInternal(rules);
    }

    private void registerRulesInternal(BatchTransformationRuleGroup rules) {
        rules.prepareQueryEngine(this.queryEngine);
        rules.stream().filter(Objects::nonNull).forEach(it -> {
            boolean bl = it.registerRule(this.ruleEngine);
        });
    }

    public <Match extends IPatternMatch> int countAllCurrent(BatchTransformationRule<Match, ?> rule) {
        return this.countAllCurrent(rule.getRuleSpecification(), rule.getFilter());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> int countAllCurrent(BatchTransformationRule<Match, ?> rule, Map.Entry<String, ?> ... parameterFilter) {
        return this.countAllCurrent(rule.getRuleSpecification(), new MatchParameterFilter(parameterFilter));
    }

    public <Match extends IPatternMatch> int countAllCurrent(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        return this.countAllCurrent(rule.getRuleSpecification(), filter);
    }

    public <Match extends IPatternMatch> boolean hasCurrent(BatchTransformationRule<Match, ?> rule) {
        return this.hasCurrent(rule, rule.getFilter());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> boolean hasCurrent(BatchTransformationRule<Match, ?> rule, Map.Entry<String, ?> ... parameterFilter) {
        return this.hasCurrent(rule, new MatchParameterFilter(parameterFilter));
    }

    public <Match extends IPatternMatch> boolean hasCurrent(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        return this.queryEngine.getMatcher(rule.getPrecondition()).streamAllMatches().anyMatch(arg_0 -> filter.isProcessable(arg_0));
    }

    public boolean hasCurrent(BatchTransformationRuleGroup rules) {
        return rules.stream().anyMatch(this::hasCurrent);
    }

    public boolean hasCurrent() {
        return this.transformation.getTransformationRuleGroup().stream().anyMatch(this::hasCurrent);
    }

    @Deprecated
    public <Match extends IPatternMatch> boolean disposeRule(RuleSpecification<Match> ruleSpecification) {
        return this.disposeRuleInternal(ruleSpecification, ruleSpecification.createEmptyFilter());
    }

    @Deprecated
    public <Match extends IPatternMatch> boolean disposeRule(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        return this.disposeRuleInternal(ruleSpecification, filter);
    }

    private <Match extends IPatternMatch> boolean disposeRuleInternal(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        return this.ruleEngine.removeRule(ruleSpecification, filter);
    }

    private void disposeRulesInternal(BatchTransformationRuleGroup rules) {
        for (BatchTransformationRule rule : rules) {
            rule.unregisterRule(this.ruleEngine);
        }
    }

    @Deprecated
    public void disposeRules(BatchTransformationRuleGroup rules) {
        rules.stream().filter(Objects::nonNull).forEach(it -> {
            boolean bl = it.unregisterRule(this.ruleEngine);
        });
    }

    public <Match extends IPatternMatch> void fireOne(BatchTransformationRule<Match, ?> rule) {
        this.executor.startExecution(FIRE_ONE_TRANSACTION_RULE_NAME + rule.getName());
        this.fireOne(rule.getRuleSpecification(), rule.getFilter());
        this.executor.endExecution(FIRE_ONE_TRANSACTION_RULE_NAME + rule.getName());
    }

    @SafeVarargs
    public final <Match extends IPatternMatch> void fireOne(BatchTransformationRule<Match, ?> rule, Map.Entry<String, ?> ... parameterFilter) {
        this.executor.startExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireOne(rule.getRuleSpecification(), new MatchParameterFilter(parameterFilter));
        this.executor.endExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    public <Match extends IPatternMatch> void fireOne(BatchTransformationRule<Match, ?> rule, EventFilter<? super Match> filter) {
        this.executor.startExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
        this.fireOne(rule.getRuleSpecification(), filter);
        this.executor.endExecution(FIRE_ONE_TRANSACTION_FILTER_RULE_NAME + rule.getName());
    }

    private <Match extends IPatternMatch> boolean fireOne(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        this.registerRuleInternal(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        conflictSet.getConflictingActivations().stream().findFirst().ifPresent(head -> this.executor.execute(Collections.singleton(head).iterator()));
        conflictSet.dispose();
        return this.disposeRuleInternal(ruleSpecification, filter);
    }

    private <Match extends IPatternMatch> boolean fireAllCurrent(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        this.registerRuleInternal(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        this.executor.execute(conflictSet.getConflictingActivations().iterator());
        conflictSet.dispose();
        return this.disposeRuleInternal(ruleSpecification, filter);
    }

    public void fireAllCurrent(BatchTransformationRuleGroup rules) {
        this.registerRulesInternal(rules);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(rules.getFilteredRuleMap());
        this.executor.execute(conflictSet.getConflictingActivations().iterator());
        conflictSet.dispose();
        this.disposeRulesInternal(rules);
    }

    public void fireAllCurrent() {
        this.fireAllCurrent(this.transformation.getTransformationRuleGroup());
    }

    private <Match extends IPatternMatch> int countAllCurrent(RuleSpecification<Match> ruleSpecification, EventFilter<? super Match> filter) {
        this.registerRuleInternal(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        int count = conflictSet.getConflictingActivations().size();
        conflictSet.dispose();
        this.disposeRuleInternal(ruleSpecification, filter);
        return count;
    }

    private <Match extends IPatternMatch> boolean fireUntil(RuleSpecification<Match> ruleSpecification, Predicate<Match> breakCondition, EventFilter<? super Match> filter) {
        this.registerRuleInternal(ruleSpecification, filter);
        ScopedConflictSet conflictSet = this.ruleEngine.createScopedConflictSet(ruleSpecification, filter);
        this.executor.execute((Iterator)new ConflictSetIterator((ConflictSet)this.ruleEngine.createScopedConflictSet(ruleSpecification, filter), breakCondition));
        conflictSet.dispose();
        return this.disposeRuleInternal(ruleSpecification, filter);
    }
}

