/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.views.traceability.generic;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.transformation.views.traceability.generic.GenericReferencedPQuery;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace;

public class GenericTracedPQuery
extends GenericReferencedPQuery {
    private GenericReferencedPQuery referencedQuery;
    private static final String DEFAULT_SUBPACKAGE = "traced";
    private static final String DEFAULT_POSTFIX = "<traced>";
    public static final String TRACE_PARAMETER = "<trace>";
    final PParameter traceParameter = new PParameter("<trace>");
    private Multimap<PParameter, PParameter> traceSources;
    private String traceabilityId;

    public GenericTracedPQuery(GenericReferencedPQuery referencedQuery, Multimap<PParameter, PParameter> traceSources) {
        super(referencedQuery);
        this.referencedQuery = referencedQuery;
        this.traceSources = traceSources;
        this.traceabilityId = referencedQuery.getTraceabilityId();
        this.ensureInitialized();
    }

    @Override
    protected Set<PBody> doGetContainedBodies() {
        PBody body = super.doGetContainedBodies().iterator().next();
        PVariable var_trace = body.getOrCreateVariableByName(TRACE_PARAMETER);
        PVariable var_id = body.getOrCreateVariableByName(this.referencedQuery.getFullyQualifiedName());
        PVariable var_su = body.getOrCreateVariableByName("_");
        PVariable var_traceability = body.newConstantVariable((Object)this.traceabilityId);
        List symbolicParameters = body.getSymbolicParameters();
        Collection baseParameters = this.traceSources.values().stream().map(PParameter::getName).collect(Collectors.toList());
        symbolicParameters.add(new ExportedParameter(body, var_trace, this.traceParameter));
        this.getParameters().add(new PParameter(var_trace.getName()));
        body.setSymbolicParameters(symbolicParameters);
        for (ExportedParameter parameter : symbolicParameters) {
            if (!baseParameters.contains(parameter.getParameterName())) continue;
            new PositivePatternCall(body, Tuples.wideFlatTupleOf((Object[])new Object[]{parameter.getParameterVariable(), var_id, var_su, var_trace, var_traceability}), Trace.instance().getInternalQueryRepresentation());
        }
        return Collections.singleton(body);
    }

    @Override
    public List<PParameter> getParameters() {
        ArrayList parameters = Lists.newArrayList(super.getParameters());
        parameters.add(this.traceParameter);
        return parameters;
    }

    @Override
    public String getFullyQualifiedName() {
        String fqn = this.referencedQuery.getFullyQualifiedName();
        int i = fqn.lastIndexOf(46);
        if (i == -1) {
            return String.format("%s.%s%s<%s>", DEFAULT_SUBPACKAGE, fqn, DEFAULT_POSTFIX, this.traceabilityId);
        }
        String prefix = fqn.substring(0, i);
        String name = fqn.substring(i);
        return String.format("%s.%s%s%s<%s>", prefix, DEFAULT_SUBPACKAGE, name, DEFAULT_POSTFIX, this.traceabilityId);
    }

    public void setTraceabilityId(String id) {
        this.traceabilityId = id;
    }
}

