/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class BundleResourceProvider {
    private static final Map<String, BundleResourceProvider> m_providers = new HashMap<String, BundleResourceProvider>();
    private final String m_id;
    private final Bundle m_bundle;
    private final Map<String, Image> m_pathToImage = new TreeMap<String, Image>();
    private final Map<String, ImageDescriptor> m_pathToImageDescriptor = new TreeMap<String, ImageDescriptor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleResourceProvider get(String id) {
        Map<String, BundleResourceProvider> map = m_providers;
        synchronized (map) {
            BundleResourceProvider provider = m_providers.get(id);
            if (provider == null) {
                provider = new BundleResourceProvider(id);
                m_providers.put(id, provider);
            }
            return provider;
        }
    }

    public static BundleResourceProvider get(Bundle bundle) {
        String id = bundle.getSymbolicName();
        return BundleResourceProvider.get(id);
    }

    public static void configureCleanUp(BundleContext context) {
        context.addBundleListener(event -> {
            if (event.getType() == 16) {
                BundleResourceProvider provider;
                Map<String, BundleResourceProvider> map = m_providers;
                synchronized (map) {
                    String id = event.getBundle().getSymbolicName();
                    provider = m_providers.remove(id);
                }
                if (provider != null) {
                    Display.getDefault().asyncExec(() -> provider.disposeImages());
                }
            }
        });
    }

    private BundleResourceProvider(String id) {
        this.m_id = id;
        this.m_bundle = Platform.getBundle((String)id);
        Assert.isNotNull(this.m_bundle, "Unable for find bundle %s", id);
    }

    public String getFileString(String path) {
        return ExecutionUtils.runObject(() -> {
            InputStream inputStream = this.getFile(path);
            return IOUtils2.readString(inputStream);
        });
    }

    public InputStream getFile(String path) {
        path = BundleResourceProvider.normalizePath(path);
        return this.getFile0(path);
    }

    private InputStream getFile0(String path) {
        return ExecutionUtils.runObject(() -> this.getFile1(path).openStream(), "Unable to open file %s from %s", path, this.m_id);
    }

    private URL getFile1(String path) {
        return ExecutionUtils.runObject(() -> this.m_bundle.getEntry(path), "Unable to open file %s from %s", path, this.m_id);
    }

    private static String normalizePath(String path) {
        while (((String)path).indexOf("//") != -1) {
            path = StringUtils.replace((String)path, (String)"//", (String)"/");
        }
        if (((String)path).length() != 0 && ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        return path;
    }

    public Image getImage(String path) {
        Image image = this.m_pathToImage.get(path = BundleResourceProvider.normalizePath(path));
        if (image == null) {
            ImageDescriptor imageDescriptor = this.getImageDescriptor(path);
            image = imageDescriptor.createImage();
            this.m_pathToImage.put(path, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = this.m_pathToImageDescriptor.get(path = BundleResourceProvider.normalizePath(path));
        if (descriptor == null) {
            URL fileUrl = this.getFile1(path);
            descriptor = ImageDescriptor.createFromURL((URL)fileUrl);
            this.m_pathToImageDescriptor.put(path, descriptor);
        }
        return descriptor;
    }

    private void disposeImages() {
        for (Image image : this.m_pathToImage.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
    }
}

