/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.QuickAssistLightBulbUpdater;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLTextPresenter;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.JavaScriptTextTools;

public class JavaCorrectionAssistant
extends QuickAssistAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;
    private Annotation[] fCurrentAnnotations;
    private QuickAssistLightBulbUpdater fLightBulbUpdater;

    public JavaCorrectionAssistant(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        JavaCorrectionProcessor processor = new JavaCorrectionProcessor(this);
        this.setQuickAssistProcessor(processor);
        this.setInformationControlCreator(this.getInformationControlCreator());
        JavaScriptTextTools textTools = JavaScriptPlugin.getDefault().getJavaTextTools();
        IColorManager manager = textTools.getColorManager();
        IPreferenceStore store = JavaScriptPlugin.getDefault().getPreferenceStore();
        Color c = JavaCorrectionAssistant.getColor(store, "content_assist_proposals_foreground", manager);
        this.setProposalSelectorForeground(c);
        c = JavaCorrectionAssistant.getColor(store, "content_assist_proposals_background", manager);
        this.setProposalSelectorBackground(c);
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
            }
        };
    }

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public void install(ISourceViewer sourceViewer) {
        super.install(sourceViewer);
        this.fViewer = sourceViewer;
        this.fLightBulbUpdater = new QuickAssistLightBulbUpdater(this.fEditor, (ITextViewer)sourceViewer);
        this.fLightBulbUpdater.install();
    }

    public void uninstall() {
        if (this.fLightBulbUpdater != null) {
            this.fLightBulbUpdater.uninstall();
            this.fLightBulbUpdater = null;
        }
        super.uninstall();
    }

    public String showPossibleQuickAssists() {
        this.fPosition = null;
        this.fCurrentAnnotations = null;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleQuickAssists();
        }
        ArrayList resultingAnnotations = new ArrayList(20);
        try {
            Point selectedRange = this.fViewer.getSelectedRange();
            int currOffset = selectedRange.x;
            int currLength = selectedRange.y;
            boolean goToClosest = currLength == 0;
            int newOffset = JavaCorrectionAssistant.collectQuickFixableAnnotations(this.fEditor, currOffset, goToClosest, resultingAnnotations);
            if (newOffset != currOffset) {
                this.storePosition(currOffset, currLength);
                this.fViewer.setSelectedRange(newOffset, 0);
                this.fViewer.revealRange(newOffset, 0);
            }
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
        this.fCurrentAnnotations = resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
        return super.showPossibleQuickAssists();
    }

    private static IRegion getRegionOfInterest(ITextEditor editor, int invocationLocation) throws BadLocationException {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document.getLineInformationOfOffset(invocationLocation);
    }

    /*
     * Unable to fully structure code
     */
    public static int collectQuickFixableAnnotations(ITextEditor editor, int invocationLocation, boolean goToClosest, ArrayList resultingAnnotations) throws BadLocationException {
        model = JavaScriptUI.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        if (model == null) {
            return invocationLocation;
        }
        JavaCorrectionAssistant.ensureUpdatedAnnotations(editor);
        iter = model.getAnnotationIterator();
        if (!goToClosest) ** GOTO lbl39
        lineInfo = JavaCorrectionAssistant.getRegionOfInterest(editor, invocationLocation);
        if (lineInfo == null) {
            return invocationLocation;
        }
        rangeStart = lineInfo.getOffset();
        rangeEnd = rangeStart + lineInfo.getLength();
        allAnnotations = new ArrayList<Annotation>();
        allPositions = new ArrayList<Position>();
        bestOffset = 0x7FFFFFFF;
        while (iter.hasNext()) {
            annot = (Annotation)iter.next();
            if (!JavaCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !JavaCorrectionAssistant.isInside(pos.offset, rangeStart, rangeEnd)) continue;
            allAnnotations.add(annot);
            allPositions.add(pos);
            bestOffset = JavaCorrectionAssistant.processAnnotation(annot, pos, invocationLocation, bestOffset);
        }
        if (bestOffset == 0x7FFFFFFF) {
            return invocationLocation;
        }
        i = 0;
        while (i < allPositions.size()) {
            pos = (Position)allPositions.get(i);
            if (JavaCorrectionAssistant.isInside(bestOffset, pos.offset, pos.offset + pos.length)) {
                resultingAnnotations.add(allAnnotations.get(i));
            }
            ++i;
        }
        return bestOffset;
lbl-1000:
        // 1 sources

        {
            annot = (Annotation)iter.next();
            if (!JavaCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !JavaCorrectionAssistant.isInside(invocationLocation, pos.offset, pos.offset + pos.length)) continue;
            resultingAnnotations.add(annot);
lbl39:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl40:
        // 1 sources

        return invocationLocation;
    }

    private static void ensureUpdatedAnnotations(ITextEditor editor) {
        Object inputElement = editor.getEditorInput().getAdapter(IJavaScriptElement.class);
        if (inputElement instanceof IJavaScriptUnit) {
            JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)((IJavaScriptUnit)inputElement), ASTProvider.WAIT_ACTIVE_ONLY, null);
        }
    }

    private static int processAnnotation(Annotation annot, Position pos, int invocationLocation, int bestOffset) {
        int newClosestPosition;
        int posBegin = pos.offset;
        int posEnd = posBegin + pos.length;
        if (JavaCorrectionAssistant.isInside(invocationLocation, posBegin, posEnd)) {
            return invocationLocation;
        }
        if (bestOffset != invocationLocation && (newClosestPosition = JavaCorrectionAssistant.computeBestOffset(posBegin, invocationLocation, bestOffset)) != -1 && newClosestPosition != bestOffset && JavaCorrectionProcessor.hasCorrections(annot)) {
            return newClosestPosition;
        }
        return bestOffset;
    }

    private static boolean isInside(int offset, int start, int end) {
        return offset == start || offset == end || offset > start && offset < end;
    }

    private static int computeBestOffset(int newOffset, int invocationLocation, int bestOffset) {
        if (newOffset <= invocationLocation) {
            if (bestOffset > invocationLocation) {
                return newOffset;
            }
            if (bestOffset <= newOffset) {
                return newOffset;
            }
            return -1;
        }
        if (newOffset <= bestOffset) {
            return newOffset;
        }
        return -1;
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private void storePosition(int currOffset, int currLength) {
        this.fPosition = new Position(currOffset, currLength);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }

    public Annotation[] getAnnotationsAtOffset() {
        return this.fCurrentAnnotations;
    }
}

