/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.document.impl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.document.DocumentWriter;
import org.w3c.dom.Document;

public abstract class DocumentWriterImpl
implements DocumentWriter {
    protected Writer writer = null;

    @Override
    public Document getDocument() throws UnsupportedOperationException {
        return null;
    }

    @Override
    public void setWriter(String documentLocation) throws UnsupportedEncodingException, FileNotFoundException {
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(documentLocation), "UTF-8"));
    }

    @Override
    public synchronized void write(Reader reader) throws WSIException, IllegalStateException {
        if (this.writer == null) {
            throw new IllegalStateException("Could not write document since writer was not set.");
        }
        this.write(reader, this.writer);
    }

    @Override
    public synchronized void write(Reader reader, Writer writer) throws WSIException {
        BufferedReader bufReader = new BufferedReader(reader);
        PrintWriter printWriter = new PrintWriter(writer);
        String nextLine = null;
        try {
            while ((nextLine = bufReader.readLine()) != null) {
                printWriter.println(nextLine);
            }
        }
        catch (Exception e) {
            throw new WSIException("Could not write document.", e);
        }
        printWriter.flush();
    }

    @Override
    public void close() throws WSIException, IllegalStateException {
        if (this.writer == null) {
            throw new IllegalStateException("Could not write log file since writer was not set.");
        }
        try {
            this.writer.close();
        }
        catch (IOException ioe) {
            throw new WSIException(ioe.toString(), ioe);
        }
    }
}

