/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.internal.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.xwt.XWTException;

public class DocumentRoot {
    public static final int TYPE_FILE = 0;
    public static final int TYPE_PATH = 1;
    public static final int FORMAT_ZIP = 2;
    public static final int FORMAT_GZIP = 3;
    public static final int FORMAT_NONE = 4;
    private int type = 1;
    private int format = 4;
    private String basePath;
    private URL baseURL;
    private String baseFile;
    private static URL DOCUMENT_ROOT;

    static {
        try {
            DOCUMENT_ROOT = new File(System.getProperty("user.dir")).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            DOCUMENT_ROOT = null;
        }
    }

    public DocumentRoot() {
        this.reset();
    }

    public int getFormat() {
        return this.format;
    }

    public int getType() {
        return this.type;
    }

    public URL getPath() {
        return this.baseURL;
    }

    public String getFile() {
        return this.baseFile;
    }

    public InputStream openStream() throws IOException {
        switch (this.format) {
            case 3: {
                return new GZIPInputStream(new URL(this.basePath + "/" + this.baseFile).openStream());
            }
        }
        if (this.basePath != null && this.basePath.length() > 0) {
            return new URL(this.baseURL, this.basePath + "/" + this.baseFile).openStream();
        }
        return new URL(this.baseURL, this.baseFile).openStream();
    }

    public InputStream openStream(String path) throws IOException {
        assert (path != null);
        InputStream in = null;
        if (path.indexOf(58) < 0) {
            if (this.format == 2) {
                file = new File(this.basePath + "/" + path);
                in = new FileInputStream(file);
            } else {
                switch (this.type) {
                    case 0: {
                        file = path.startsWith("/") ? new File(path) : new File(this.basePath + "/" + path);
                        in = new FileInputStream(file);
                        break;
                    }
                    case 1: {
                        URL url = new URL(this.basePath + "/" + path);
                        in = url.openStream();
                    }
                }
            }
        } else if (path.startsWith("classpath:")) {
            String p = path.substring(10);
            in = this.getClass().getResourceAsStream(p);
            if (in == null) {
                in = String.class.getResourceAsStream(p);
            }
            if (in == null) {
                in = Thread.currentThread().getClass().getResourceAsStream(p);
            }
            if (in == null) {
                throw new IOException("File not found in classpath: " + p);
            }
        } else {
            file = new File(path);
            in = file.exists() ? new FileInputStream(file) : new URL(path).openStream();
        }
        PushbackInputStream pis = new PushbackInputStream(in, 4);
        if (Format.isGZIP(pis)) {
            return new GZIPInputStream(pis);
        }
        if (Format.isZIP(pis)) {
            ZipInputStream zis = new ZipInputStream(pis);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null && (entry.isDirectory() || entry.getName().indexOf(47) != -1)) {
                entry = zis.getNextEntry();
            }
            return zis;
        }
        return pis;
    }

    protected void init(InputStream inputStream, URL url) throws IOException {
        File file = null;
        try {
            file = "file".equals(url.getProtocol()) ? new File(url.toURI()) : null;
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (inputStream == null && file != null && file.exists()) {
            this.init(file);
        } else {
            this.basePath = null;
            this.baseURL = url;
            PushbackInputStream pis = null;
            boolean shouldClose_pis = false;
            if (inputStream instanceof PushbackInputStream) {
                pis = (PushbackInputStream)inputStream;
            } else if (inputStream == null) {
                pis = new PushbackInputStream(this.baseURL.openStream(), 4);
                shouldClose_pis = true;
            } else {
                pis = new PushbackInputStream(inputStream, 4);
            }
            if (Format.isGZIP(pis)) {
                this.format = 3;
            } else if (Format.isZIP(pis)) {
                this.format = 2;
                File tempDir = this.extractZipToTemporary(pis);
                this.basePath = "file:/" + tempDir.getAbsolutePath();
                this.baseFile = this.getMainFile(tempDir);
            }
            if (shouldClose_pis) {
                pis.close();
            }
            if (this.basePath == null) {
                String path = url.getPath();
                while (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                int lastIndex = path.lastIndexOf("/");
                if (lastIndex > 0) {
                    this.basePath = path.substring(0, lastIndex);
                    this.baseFile = path.substring(lastIndex + 1);
                    this.baseURL = new URL(url, this.basePath);
                } else if ("file".equals(url.getProtocol())) {
                    this.basePath = System.getProperty("user.dir");
                    this.baseURL = new File(this.basePath).toURI().toURL();
                    this.baseFile = path;
                } else {
                    this.basePath = "";
                    this.baseFile = path;
                    this.baseURL = new URL(url, this.basePath);
                }
            }
            this.type = 1;
        }
    }

    protected void reset() {
        this.type = 1;
        this.format = 4;
        this.baseURL = DOCUMENT_ROOT;
        this.basePath = DOCUMENT_ROOT.toString();
        this.baseFile = null;
    }

    private void init(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        PushbackInputStream pis = new PushbackInputStream(fis, 4);
        this.baseURL = file.getParentFile().toURI().toURL();
        this.basePath = this.baseURL.toString();
        this.baseFile = file.getName();
        if (Format.isGZIP(pis)) {
            this.format = 3;
        } else if (Format.isZIP(pis)) {
            this.format = 2;
            File tempDir = this.extractZipToTemporary(pis);
            this.basePath = "file:/" + tempDir.getAbsolutePath();
            this.baseFile = this.getMainFile(tempDir);
            this.baseURL = file.toURI().toURL();
        }
        this.type = 0;
    }

    private String getMainFile(File tempDir) {
        File[] tempFiles;
        File[] fileArray = tempFiles = tempDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase().endsWith(".xwt");
            }
        });
        if (tempFiles.length != 0) {
            File tempFile = fileArray[0];
            return tempFile.getName();
        }
        return null;
    }

    private File extractZipToTemporary(InputStream stream) throws IOException {
        ZipEntry z;
        File file = new File(System.getProperty("java.io.tmpdir") + "/cb" + System.currentTimeMillis() + Math.random());
        if (!file.mkdir()) {
            throw new XWTException("Folder creation fails: " + file.toString());
        }
        file.deleteOnExit();
        String directory = file.getAbsolutePath();
        ZipInputStream in = new ZipInputStream(stream);
        while ((z = in.getNextEntry()) != null) {
            if (z.isDirectory()) {
                String name = z.getName();
                File f = new File(directory + File.separator + (name = name.substring(0, name.length() - 1)));
                if (!f.mkdir()) {
                    throw new XWTException("Folder creation fails: " + f.toString());
                }
                f.deleteOnExit();
                continue;
            }
            File f = new File(directory + File.separator + z.getName());
            if (!f.createNewFile()) {
                throw new XWTException("File creation fails: " + f.toString());
            }
            f.deleteOnExit();
            FileOutputStream out = new FileOutputStream(f);
            byte[] cache = new byte[4096];
            int i = in.read(cache);
            while (i != -1) {
                out.write(cache, 0, i);
                i = in.read(cache);
            }
            out.close();
        }
        in.close();
        return file;
    }

    static class Format {
        Format() {
        }

        public static boolean isGZIP(PushbackInputStream stream) throws IOException {
            assert (stream != null);
            byte[] cachedBytes = new byte[2];
            if (stream.read(cachedBytes) != cachedBytes.length) {
                throw new RuntimeException("data content wrong.");
            }
            stream.unread(cachedBytes);
            return (cachedBytes[0] & 0xFF) == 31 && (cachedBytes[1] & 0xFF) == 139;
        }

        public static boolean isGZIP(File file) throws IOException {
            assert (file != null);
            FileInputStream fis = new FileInputStream(file);
            PushbackInputStream pis = new PushbackInputStream(fis, 2);
            boolean returnValue = Format.isGZIP(pis);
            pis.close();
            return returnValue;
        }

        public static boolean isZIP(PushbackInputStream stream) throws IOException {
            assert (stream != null);
            byte[] cachedBytes = new byte[4];
            if (stream.read(cachedBytes) != cachedBytes.length) {
                throw new RuntimeException("data content wrong.");
            }
            stream.unread(cachedBytes);
            return (cachedBytes[0] & 0xFF) == 80 && (cachedBytes[1] & 0xFF) == 75 && (cachedBytes[2] & 0xFF) == 3 && (cachedBytes[3] & 0xFF) == 4;
        }

        public static boolean isZIP(File file) throws IOException {
            assert (file != null);
            FileInputStream fis = new FileInputStream(file);
            PushbackInputStream pis = new PushbackInputStream(fis, 4);
            boolean returnValue = Format.isZIP(pis);
            pis.close();
            return returnValue;
        }
    }
}

