/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.xsd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.axis.model.xsd.XSDDiagnostic;
import org.apache.axis.model.xsd.XSDDiagnosticSeverity;
import org.apache.axis.model.xsd.XSDFactory;
import org.apache.axis.model.xsd.XSDPlugin;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler {
    protected List xsdDiagnostics = new ArrayList();
    protected XSDFactory xsdFactory = XSDFactory.eINSTANCE;

    public void fatalError(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void error(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void warning(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.WARNING_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public Collection getDiagnostics() {
        return this.xsdDiagnostics;
    }
}

