/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.burningwave.core.Executable;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfig;
import org.burningwave.core.classes.SourceGenerator;

public abstract class ExecuteConfig<C extends ExecuteConfig<C>>
extends LoadOrBuildAndDefineConfig.ForCodeExecutorAbst<C> {
    ClassLoader parentClassLoader;
    boolean useDefaultClassLoaderAsParentIfParentClassLoaderIsNull = true;
    List<Object> params;
    boolean useDefaultClassLoaderAsParentIfParentClassLoaderIsNullHasBeenCalled;

    ExecuteConfig(String name, BodySourceGenerator bodySG) {
        super(name, bodySG);
    }

    public C useAsParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return (C)this;
    }

    public C useDefaultClassLoaderAsParent(boolean flag) {
        this.useDefaultClassLoaderAsParentIfParentClassLoaderIsNull = flag;
        this.useDefaultClassLoaderAsParentIfParentClassLoaderIsNullHasBeenCalled = true;
        return (C)this;
    }

    public C withParameter(Object ... parameters) {
        if (this.params == null) {
            this.params = new ArrayList<Object>();
        }
        if (parameters != null) {
            for (Object param : parameters) {
                this.params.add(param);
            }
        } else {
            this.params.add(null);
        }
        return (C)this;
    }

    ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    boolean isUseDefaultClassLoaderAsParentIfParentClassLoaderIsNull() {
        return this.useDefaultClassLoaderAsParentIfParentClassLoaderIsNull;
    }

    @Override
    public C useClassLoader(ClassLoader classLoader) {
        if (!this.useDefaultClassLoaderAsParentIfParentClassLoaderIsNullHasBeenCalled) {
            this.useDefaultClassLoaderAsParentIfParentClassLoaderIsNull = false;
        }
        return (C)((ExecuteConfig)super.useClassLoader(classLoader));
    }

    Object[] getParams() {
        return this.params != null ? this.params.toArray(new Object[this.params.size()]) : null;
    }

    public static ForProperties fromDefaultProperties() {
        return new ForProperties();
    }

    public static ForProperties forProperties(Properties properties) {
        ForProperties fromProperties = new ForProperties();
        fromProperties.properties = properties;
        return fromProperties;
    }

    public static ForProperties forProperty(String propertyName) {
        ForProperties fromProperties = new ForProperties();
        fromProperties.propertyName = propertyName;
        return fromProperties;
    }

    public static ForProperties forPropertiesFile(String filePath) {
        ForProperties fromProperties = new ForProperties();
        fromProperties.filePath = filePath;
        return fromProperties;
    }

    public static ForBodySourceGenerator forBodySourceGenerator() {
        return ExecuteConfig.forBodySourceGenerator(BodySourceGenerator.createSimple());
    }

    public static ForBodySourceGenerator forBodySourceGenerator(BodySourceGenerator body) {
        return new ForBodySourceGenerator(body);
    }

    public static class ForProperties
    extends ExecuteConfig<ForProperties> {
        private Map<?, ?> properties;
        private String propertyName;
        private String filePath;
        private boolean isAbsoluteFilePath = false;
        private boolean indentCodeActive = true;
        private Map<?, ?> defaultValues;

        private ForProperties() {
            super(Executable.class.getPackage().getName() + ".CodeExecutor_" + UUID.randomUUID().toString().replaceAll("-", ""), BodySourceGenerator.createSimple());
            this.virtualizeClasses(false);
        }

        public ForProperties setPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public ForProperties setFilePathAsAbsolute(boolean flag) {
            this.isAbsoluteFilePath = flag;
            return this;
        }

        public ForProperties withDefaultPropertyValue(String key, String value) {
            if (this.defaultValues == null) {
                this.defaultValues = new HashMap();
            }
            this.defaultValues.put(key, value);
            return this;
        }

        public ForProperties withDefaultPropertyValues(Map<?, ?> defaultValues) {
            if (this.defaultValues == null && defaultValues != null) {
                this.defaultValues = new HashMap();
            }
            this.defaultValues.putAll(defaultValues);
            return this;
        }

        Map<?, ?> getProperties() {
            return this.properties;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        String getFilePath() {
            return this.filePath;
        }

        boolean isAbsoluteFilePath() {
            return this.isAbsoluteFilePath;
        }

        Map<?, ?> getDefaultValues() {
            return this.defaultValues;
        }

        public ForProperties indentCodeActive(boolean flag) {
            this.indentCodeActive = flag;
            return this;
        }

        boolean isIndentCodeActive() {
            return this.indentCodeActive;
        }
    }

    public static class ForBodySourceGenerator
    extends ExecuteConfig<ForBodySourceGenerator> {
        private ForBodySourceGenerator(BodySourceGenerator body) {
            super(Executable.class.getPackage().getName() + ".CodeExecutor_" + UUID.randomUUID().toString().replaceAll("-", ""), body);
            this.virtualizeClasses(false);
        }

        public ForBodySourceGenerator addCodeLine(String ... lineOfCode) {
            this.body.addCodeLine(lineOfCode);
            return this;
        }

        public ForBodySourceGenerator addCode(String ... code) {
            this.body.addCode(code);
            return this;
        }

        public ForBodySourceGenerator addCode(SourceGenerator ... generators) {
            this.body.addElement(generators);
            return this;
        }

        public ForBodySourceGenerator useType(Class<?> ... classes) {
            this.body.useType(classes);
            return this;
        }
    }
}

