/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.function;

import java.util.Objects;

@FunctionalInterface
public interface ThrowingPredicate<T, E extends Throwable> {
    public boolean test(T var1) throws E;

    default public ThrowingPredicate<T, E> and(ThrowingPredicate<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public ThrowingPredicate<T, E> negate() {
        return t -> !this.test(t);
    }

    default public ThrowingPredicate<T, E> or(ThrowingPredicate<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T, E extends Throwable> ThrowingPredicate<T, E> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
    }
}

