/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.commands;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoPom;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.TreeSelection;

public class CreatePomCommandHandler
extends AbstractHandler {
    private static final String PARENT_SUFFIX = ".parent";
    private static final String LS = System.getProperty("line.separator");
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private boolean enabled;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = event.getApplicationContext();
        if (applicationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)applicationContext;
            Object defaultVariable = context.getDefaultVariable();
            ArrayList<IProject> projects = new ArrayList<IProject>();
            if (defaultVariable instanceof List) {
                List variables = (List)defaultVariable;
                for (Object object : variables) {
                    if (object instanceof IProject) {
                        IProject project = (IProject)object;
                        projects.add(project);
                        continue;
                    }
                    if (object instanceof IJavaProject) {
                        IJavaProject javaProject = (IJavaProject)object;
                        projects.add(javaProject.getProject());
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
                }
            } else if (defaultVariable instanceof TreeSelection && ((TreeSelection)defaultVariable).size() > 0) {
                TreeSelection selection = (TreeSelection)defaultVariable;
                List list = selection.toList();
                for (Object object : list) {
                    if (object instanceof IProject) {
                        IProject project = (IProject)object;
                        projects.add(project);
                        continue;
                    }
                    if (object instanceof IJavaProject) {
                        IJavaProject javaProject = (IJavaProject)object;
                        projects.add(javaProject.getProject());
                        continue;
                    }
                    if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                    projects.add((IProject)Platform.getAdapterManager().getAdapter(object, IProject.class));
                }
            }
            for (IProject iProject : projects) {
                try {
                    if (!iProject.isAccessible() || !iProject.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) continue;
                    this.generatePom(iProject);
                }
                catch (CoreException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
            }
        }
        return applicationContext;
    }

    private void generatePom(IProject project) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        AcceleoPom acceleoPom = AcceleowizardmodelFactory.eINSTANCE.createAcceleoPom();
        acceleoPom.setArtifactId(project.getName());
        boolean areNotificationsForcedDisabled = AcceleoPreferences.areNotificationsForcedDisabled();
        if (!areNotificationsForcedDisabled) {
            AcceleoPreferences.switchForceDeactivationNotifications((boolean)true);
        }
        this.generateFeatureProject(project, acceleoPom, (IProgressMonitor)monitor);
        this.generateUpdateSiteProject(project, acceleoPom, (IProgressMonitor)monitor);
        this.generateParentProject(project, acceleoPom, (IProgressMonitor)monitor);
        AcceleoUIGenerator.getDefault().generatePomChild(acceleoPom, (IContainer)project, String.valueOf(project.getName()) + PARENT_SUFFIX);
        AcceleoPreferences.switchForceDeactivationNotifications((boolean)areNotificationsForcedDisabled);
    }

    private void generateFeatureProject(IProject project, AcceleoPom acceleoPom, IProgressMonitor monitor) {
        IProject featureProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + ".feature");
        if (!featureProject.exists()) {
            try {
                featureProject.create(monitor);
                featureProject.open(monitor);
                IProjectDescription description = featureProject.getDescription();
                String[] oldNatureIds = description.getNatureIds();
                String[] newNatureIds = new String[oldNatureIds.length + 1];
                System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
                newNatureIds[oldNatureIds.length] = "org.eclipse.pde.FeatureNature";
                description.setNatureIds(newNatureIds);
                featureProject.setDescription(description, monitor);
                IFile buildProperties = featureProject.getFile("build.properties");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(("bin.includes = feature.xml" + LS).getBytes());
                buildProperties.create((InputStream)inputStream, true, monitor);
                IFile featureXML = featureProject.getFile("feature.xml");
                StringBuffer buffer = new StringBuffer(XML_HEADER + LS);
                buffer.append("<feature" + LS);
                buffer.append("      id=\"" + project.getName() + ".feature\"" + LS);
                buffer.append("      label=\"Feature\"" + LS);
                buffer.append("      version=\"1.0.0.qualifier\">" + LS);
                buffer.append(LS);
                buffer.append("   <description url=\"http://www.example.com/description\">" + LS);
                buffer.append("      [Enter Feature Description here.]" + LS);
                buffer.append("   </description>" + LS);
                buffer.append(LS);
                buffer.append("   <copyright url=\"http://www.example.com/copyright\">" + LS);
                buffer.append("      [Enter Copyright Description here.]" + LS);
                buffer.append("   </copyright>" + LS);
                buffer.append(LS);
                buffer.append("   <license url=\"http://www.example.com/license\">" + LS);
                buffer.append("      [Enter License Description here.]" + LS);
                buffer.append("   </license>" + LS);
                buffer.append(LS);
                buffer.append("   <plugin" + LS);
                buffer.append("         id=\"" + project.getName() + "\"" + LS);
                buffer.append("         download-size=\"0\"" + LS);
                buffer.append("         install-size=\"0\"" + LS);
                buffer.append("         version=\"0.0.0\"" + LS);
                buffer.append("         unpack=\"false\"/>" + LS);
                buffer.append(LS);
                buffer.append("</feature>" + LS);
                inputStream = new ByteArrayInputStream(buffer.toString().getBytes());
                featureXML.create((InputStream)inputStream, true, monitor);
                AcceleoUIGenerator.getDefault().generatePomFeature(acceleoPom, (IContainer)featureProject, String.valueOf(project.getName()) + PARENT_SUFFIX);
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
    }

    private void generateUpdateSiteProject(IProject project, AcceleoPom acceleoPom, IProgressMonitor monitor) {
        IProject updateSiteProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + ".updatesite");
        if (!updateSiteProject.exists()) {
            try {
                updateSiteProject.create(monitor);
                updateSiteProject.open(monitor);
                IProjectDescription description = updateSiteProject.getDescription();
                String[] oldNatureIds = description.getNatureIds();
                String[] newNatureIds = new String[oldNatureIds.length + 1];
                System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
                newNatureIds[oldNatureIds.length] = "org.eclipse.pde.UpdateSiteNature";
                description.setNatureIds(newNatureIds);
                updateSiteProject.setDescription(description, monitor);
                IFile categoryXML = updateSiteProject.getFile("category.xml");
                StringBuffer buffer = new StringBuffer(XML_HEADER + LS);
                buffer.append("<site>" + LS);
                buffer.append("   <feature url=\"features/" + project.getName() + ".feature_1.0.0.qualifier.jar\" id=\"" + project.getName() + ".feature\" version=\"1.0.0.qualifier\">" + LS);
                buffer.append("      <category name=\"" + project.getName() + ".category.id\"/>" + LS);
                buffer.append("   </feature>" + LS);
                buffer.append("   <category-def name=\"" + project.getName() + ".category.id\" label=\"Acceleo\"/>" + LS);
                buffer.append("</site>" + LS);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.toString().getBytes());
                categoryXML.create((InputStream)inputStream, true, monitor);
                IFile siteXML = updateSiteProject.getFile("site.xml");
                buffer = new StringBuffer(XML_HEADER + LS);
                buffer.append("<site>" + LS);
                buffer.append("</site>" + LS);
                siteXML.create((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), true, monitor);
                AcceleoUIGenerator.getDefault().generatePomUpdateSite(acceleoPom, (IContainer)updateSiteProject, String.valueOf(project.getName()) + PARENT_SUFFIX);
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
    }

    private void generateParentProject(IProject project, AcceleoPom acceleoPom, IProgressMonitor monitor) {
        IProject parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + PARENT_SUFFIX);
        if (!parentProject.exists()) {
            try {
                parentProject.create(monitor);
                parentProject.open(monitor);
                AcceleoUIGenerator.getDefault().generatePom(acceleoPom, (IContainer)parentProject, String.valueOf(project.getName()) + PARENT_SUFFIX);
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)evaluationContext;
            Object defaultVariable = context.getDefaultVariable();
            if (defaultVariable instanceof List && ((List)defaultVariable).size() > 0) {
                List variables = (List)defaultVariable;
                for (Object object : variables) {
                    try {
                        IProject project;
                        if (object instanceof IProject) {
                            project = (IProject)object;
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (object instanceof IJavaProject) {
                            project = ((IJavaProject)object).getProject();
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                        project = (IProject)Platform.getAdapterManager().getAdapter(object, IProject.class);
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                }
            } else if (defaultVariable instanceof TreeSelection && ((TreeSelection)defaultVariable).size() > 0) {
                TreeSelection selection = (TreeSelection)defaultVariable;
                List list = selection.toList();
                for (Object object : list) {
                    try {
                        IProject project;
                        if (object instanceof IProject) {
                            project = (IProject)object;
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (object instanceof IJavaProject) {
                            project = ((IJavaProject)object).getProject();
                            this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                            continue;
                        }
                        if (!(Platform.getAdapterManager().getAdapter(object, IProject.class) instanceof IProject)) continue;
                        project = (IProject)Platform.getAdapterManager().getAdapter(object, IProject.class);
                        this.enabled = project.isAccessible() && project.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                }
            }
        } else {
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

