/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.format.ClangFormatValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;

public class ClangFormatFileMonitor {
    public static final String CLANG_FORMAT_FILE = ".clang-format";
    public static final String CLANG_FORMAT_CHECK_FILE = "clang-format-check";
    private final ConcurrentLinkedQueue<IFile> pendingFiles = new ConcurrentLinkedQueue();
    private final IWorkspace workspace;
    private final ClangFormatValidator validator = new ClangFormatValidator();
    private final ServiceCaller<ClangdConfiguration> configuration = new ServiceCaller(this.getClass(), ClangdConfiguration.class);
    private final IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getDelta() != null && event.getType() == 1) {
                try {
                    event.getDelta().accept(delta -> {
                        IResource iResource;
                        if ((delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) && ClangFormatFileMonitor.CLANG_FORMAT_FILE.equals(delta.getResource().getName()) && (iResource = delta.getResource()) instanceof IFile) {
                            IFile file = (IFile)iResource;
                            ClangFormatFileMonitor.this.pendingFiles.add(file);
                            ClangFormatFileMonitor.this.checkJob.schedule(100L);
                        }
                        return true;
                    });
                }
                catch (CoreException e) {
                    Platform.getLog(this.getClass()).log(e.getStatus());
                }
            }
        }
    };
    private final WorkspaceJob checkJob = new WorkspaceJob("Check .clang-format file"){

        /*
         * Unable to fully structure code
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            clangdPath = ClangFormatFileMonitor.this.getClangdPath();
            if (!clangdPath.isEmpty()) ** GOTO lbl29
            msg = "Cannot determine clangd path for .clang-format file validation";
            Platform.getLog(this.getClass()).error(msg);
            return Status.error((String)msg);
lbl-1000:
            // 1 sources

            {
                block6: {
                    emptyFile = null;
                    clangFormatFile = ClangFormatFileMonitor.this.pendingFiles.poll();
                    emptyFile = ClangFormatFileMonitor.this.createEmptyFile(clangFormatFile);
                    if (emptyFile != null) break block6;
                    Platform.getLog(this.getClass()).error("Cannot create empty file");
                    ClangFormatFileMonitor.this.deleteEmptyFile(emptyFile);
                }
                try {
                    try {
                        ClangFormatFileMonitor.this.validator.validateFile(ClangFormatFileMonitor.this.getCommandLine(emptyFile, clangdPath), clangFormatFile);
                    }
                    catch (IOException e) {
                        Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                        var6_7 = Status.error((String)e.getMessage());
                        ClangFormatFileMonitor.this.deleteEmptyFile(emptyFile);
                        return var6_7;
                    }
                }
                catch (Throwable var5_8) {
                    ClangFormatFileMonitor.this.deleteEmptyFile(emptyFile);
                    throw var5_8;
                }
                ClangFormatFileMonitor.this.deleteEmptyFile(emptyFile);
lbl29:
                // 3 sources

                ** while (ClangFormatFileMonitor.this.pendingFiles.peek() != null)
            }
lbl30:
            // 1 sources

            return Status.OK_STATUS;
        }
    };

    public ClangFormatFileMonitor(IWorkspace workspace) {
        this.workspace = workspace;
    }

    private IFile createEmptyFile(IFile clangFormatFile) {
        IContainer parent = clangFormatFile.getParent();
        if (parent instanceof IContainer) {
            IContainer folder = parent;
            try {
                IFile file = folder.getFile((IPath)new Path(CLANG_FORMAT_CHECK_FILE));
                if (!file.exists()) {
                    file.create(new byte[0], true, false, null);
                }
                return file;
            }
            catch (CoreException e) {
                Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private void deleteEmptyFile(IFile emptyFile) {
        try {
            if (emptyFile != null && emptyFile.exists()) {
                emptyFile.delete(true, null);
            }
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> getCommandLine(IFile emptyFile, String clangdPath) {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(clangdPath);
        list.add("--check=" + emptyFile.getLocation().toOSString());
        list.add("--log=error");
        return list;
    }

    private String getClangdPath() {
        ArrayList result = new ArrayList();
        this.configuration.call(c -> {
            boolean bl = result.addAll(c.commands(null).stream().map(ClangFormatFileMonitor::resolveVariables).collect(Collectors.toList()));
        });
        return result.isEmpty() ? "" : (String)result.get(0);
    }

    private static String resolveVariables(String cmd) {
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(cmd);
        }
        catch (CoreException e) {
            return cmd;
        }
    }

    public ClangFormatFileMonitor start() {
        this.workspace.addResourceChangeListener(this.listener);
        return this;
    }

    public void stop() {
        this.workspace.removeResourceChangeListener(this.listener);
    }
}

