/*******************************************************************************
 * Copyright (c) 2000, 2017 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.ui.viewsupport;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;


public class FilterUpdater implements IResourceChangeListener {

	private StructuredViewer fViewer;

	public FilterUpdater(StructuredViewer viewer) {
		fViewer= viewer;
	}

	@Override
	public void resourceChanged(IResourceChangeEvent event) {
		IResourceDelta delta= event.getDelta();
		if (delta == null)
			return;

		IResourceDelta[] projDeltas = delta.getAffectedChildren(IResourceDelta.CHANGED);
		for (int i= 0; i < projDeltas.length; i++) {
			IResourceDelta pDelta= projDeltas[i];
			if ((pDelta.getFlags() & IResourceDelta.DESCRIPTION) != 0) {
				final Control ctrl= fViewer.getControl();
				if (ctrl != null && !ctrl.isDisposed()) {
					// async is needed due to bug 33783
					ctrl.getDisplay().asyncExec(() -> {
						if (!ctrl.isDisposed())
							fViewer.refresh(false);
					});
				}
			}
		}
	}
}
