/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;

public class Autocomplete {
    public static void installOn(ComboViewer comboViewer) {
        final Combo combo = comboViewer.getCombo();
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Autocomplete.setClosestMatch(combo);
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 8) {
                    Point pt = combo.getSelection();
                    combo.setSelection(new Point(Math.max(0, pt.x - 1), pt.y));
                }
            }
        });
        combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                combo.setSelection(new Point(0, combo.getText().length()));
            }

            public void focusGained(FocusEvent e) {
                combo.setSelection(new Point(0, combo.getText().length()));
            }
        });
        combo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                combo.setSelection(new Point(0, combo.getText().length()));
            }
        });
    }

    private static void setClosestMatch(Combo combo) {
        String[] items = combo.getItems();
        if (items.length == 0) {
            return;
        }
        String str = combo.getText();
        Pattern pattern = Pattern.compile(str + ".*", 2);
        int index = -1;
        int length = 0;
        int i = 0;
        while (i < items.length) {
            Matcher m = pattern.matcher(items[i]);
            if (m.matches() && (index == -1 || items[i].length() < length)) {
                length = items[i].length();
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            index = 0;
        }
        Point pt = combo.getSelection();
        String selectedText = items[index];
        combo.select(index);
        combo.setText(selectedText);
        combo.setSelection(new Point(pt.x, selectedText.length()));
    }
}

