/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.editors;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.editors.AbstractExecutionDataContentProvider;
import org.eclipse.eclemma.internal.ui.editors.ExecutionDataContent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.jacoco.core.data.SessionInfo;

class SessionDataPage
extends FormPage {
    private final ExecutionDataContent content;
    private final DateFormat dateTimeFormat;

    public SessionDataPage(FormEditor parent, ExecutionDataContent content) {
        super(parent, "sessions", UIMessages.ExecutionDataEditorSessionsPage_title);
        this.content = content;
        this.dateTimeFormat = DateFormat.getDateTimeInstance(2, 2);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(UIMessages.ExecutionDataEditorSessionsPage_title);
        toolkit.decorateFormHeading(form.getForm());
        Composite body = form.getBody();
        GridLayoutFactory.swtDefaults().applyTo(body);
        Table sessionTable = toolkit.createTable(body, 68096);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sessionTable);
        sessionTable.setHeaderVisible(true);
        sessionTable.setLinesVisible(true);
        TableViewer sessionTableViewer = new TableViewer(sessionTable);
        TableViewerColumn sessionIdColumnViewer = new TableViewerColumn(sessionTableViewer, 0);
        sessionIdColumnViewer.setLabelProvider((CellLabelProvider)new SessionIdColumnLabelProvider());
        TableColumn sessionIdColumn = sessionIdColumnViewer.getColumn();
        sessionIdColumn.setText(UIMessages.ExecutionDataEditorSessionsPageColumnSessionId_label);
        sessionIdColumn.setWidth(300);
        TableViewerColumn startTimeColumnViewer = new TableViewerColumn(sessionTableViewer, 0);
        startTimeColumnViewer.setLabelProvider((CellLabelProvider)new StartTimeColumnLabelProvider());
        TableColumn startTimeColumn = startTimeColumnViewer.getColumn();
        startTimeColumn.setText(UIMessages.ExecutionDataEditorSessionsPageColumnStartTime_label);
        startTimeColumn.setWidth(200);
        TableViewerColumn dumpTimeColumnViewer = new TableViewerColumn(sessionTableViewer, 0);
        dumpTimeColumnViewer.setLabelProvider((CellLabelProvider)new DumpTimeColumnLabelProvider());
        TableColumn dumpTimeColumn = dumpTimeColumnViewer.getColumn();
        dumpTimeColumn.setText(UIMessages.ExecutionDataEditorSessionsPageColumnDumpTime_label);
        dumpTimeColumn.setWidth(200);
        sessionTable.setSortColumn(startTimeColumn);
        sessionTable.setSortDirection(128);
        sessionTableViewer.setContentProvider((IContentProvider)new AbstractExecutionDataContentProvider(){

            public Object[] getElements(ExecutionDataContent content) {
                return content.getSessionInfos();
            }
        });
        sessionTableViewer.setInput((Object)this.content);
    }

    private final class DumpTimeColumnLabelProvider
    extends ColumnLabelProvider {
        private DumpTimeColumnLabelProvider() {
        }

        public String getText(Object element) {
            return SessionDataPage.this.dateTimeFormat.format(new Date(((SessionInfo)element).getDumpTimeStamp()));
        }
    }

    private static final class SessionIdColumnLabelProvider
    extends ColumnLabelProvider {
        private SessionIdColumnLabelProvider() {
        }

        public String getText(Object element) {
            return ((SessionInfo)element).getId();
        }
    }

    private final class StartTimeColumnLabelProvider
    extends ColumnLabelProvider {
        private StartTimeColumnLabelProvider() {
        }

        public String getText(Object element) {
            return SessionDataPage.this.dateTimeFormat.format(new Date(((SessionInfo)element).getStartTimeStamp()));
        }
    }
}

