/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.command.MatchMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class NameMatchMappingCommand
extends MatchMappingCommand {
    public static Command create(MappingDomain domain, Mapping mapping) {
        return domain.createCommand(NameMatchMappingCommand.class, new CommandParameter((Object)mapping));
    }

    public NameMatchMappingCommand(MappingDomain domain, Mapping mapping) {
        super(domain, mapping);
    }

    @Override
    protected boolean match(Object inputObject, Object outputObject, Collection<Object> mappedObjects) {
        String inputName = this.domain.getName(inputObject);
        String outputName = this.domain.getName(outputObject);
        if (inputName != null && outputName != null) {
            List<String> parsedInputName = this.domain.parseInputName(inputName);
            List<String> parsedOutputName = this.domain.parseOutputName(outputName);
            if (this.concatName(parsedInputName).equalsIgnoreCase(this.concatName(parsedOutputName))) {
                mappedObjects.add(inputObject);
            }
        }
        boolean multipleMatchesAllowed = (this.domain.getMappingEnablementFlags() & 1) != 0;
        return !multipleMatchesAllowed;
    }

    protected String concatName(List<String> parsedName) {
        StringBuilder result = new StringBuilder();
        for (String nameComponent : parsedName) {
            result.append(nameComponent);
        }
        return result.toString();
    }

    public void execute() {
        super.execute();
        for (Command command : new ArrayList(this.commandList)) {
            this.appendAndExecute(NameMatchMappingCommand.create(this.domain, (Mapping)command.getResult().iterator().next()));
        }
    }
}

