/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.List;
import java.util.function.Predicate;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.handlers.AbstractSnapTo;
import org.eclipse.gef.mvc.fx.handlers.ISnapToStrategy;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;

public class SnapToGeometry
extends AbstractSnapTo
implements ISnapToStrategy {
    public static final String TARGET_SNAPPING_LOCATION_PROVIDER = "SnapToGeometryTargetSnappingLocationProvider";
    public static final String SOURCE_SNAPPING_LOCATION_PROVIDER = "SnapToGeometrySourceSnappingLocationProvider";
    protected Predicate<IContentPart<? extends Node>> IS_VISIBLE = p -> {
        InfiniteCanvas canvas = (InfiniteCanvas)this.getSnappedPart().getViewer().getCanvas();
        Bounds boundsInCanvas = canvas.sceneToLocal(p.getVisual().localToScene(p.getVisual().getLayoutBounds()));
        return !(boundsInCanvas.getMinX() > canvas.getWidth() || boundsInCanvas.getMinY() > canvas.getHeight() || boundsInCanvas.getMaxX() < 0.0) && !(boundsInCanvas.getMaxY() < 0.0);
    };
    protected Predicate<IContentPart<? extends Node>> IS_LEAF = p -> p.getChildrenUnmodifiable().isEmpty();

    @Override
    protected String getTargetLocationProviderRole() {
        return TARGET_SNAPPING_LOCATION_PROVIDER;
    }

    @Override
    public String getSourceLocationProviderRole() {
        return SOURCE_SNAPPING_LOCATION_PROVIDER;
    }

    @Override
    protected boolean isRelevant(IContentPart<? extends Node> part) {
        return this.IS_VISIBLE.test(part) && this.IS_LEAF.test(part);
    }

    @Override
    public Dimension snap(Orientation orientation, double positionInScene) {
        double minDistance = 0.0;
        SnappingModel.SnappingLocation snappingLocation = null;
        if (orientation != Orientation.HORIZONTAL && orientation != Orientation.VERTICAL) {
            throw new IllegalArgumentException("Wrong Orientation");
        }
        boolean horizontal = orientation == Orientation.HORIZONTAL;
        List<SnappingModel.SnappingLocation> testLocations = horizontal ? this.getHorizontalTargetLocations() : this.getVerticalTargetLocations();
        for (SnappingModel.SnappingLocation sl : testLocations) {
            double location = sl.getPositionInScene();
            double distance = positionInScene - location;
            if (snappingLocation != null && !(Math.abs(distance) < Math.abs(minDistance))) continue;
            minDistance = distance;
            snappingLocation = sl;
        }
        if (snappingLocation == null) {
            return null;
        }
        double d = snappingLocation.getPositionInScene() - positionInScene;
        return horizontal ? new Dimension(d, 0.0) : new Dimension(0.0, d);
    }
}

