/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ConnectionLayerEx;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;

public class GraphicalNodeEditPolicy
extends org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy {
    private IAdaptable _viewAdapter;
    private static final String CREATE_CONNECTION_COMMAND_LABEL = DiagramUIMessages.GraphicalNodeEditPolicy_createRelationshipCommand_label;

    protected Connection createDummyConnection(Request req) {
        PolylineConnection c = (PolylineConnection)super.createDummyConnection(req);
        c.setLineStyle(4);
        c.setForegroundColor(this.getHost().getFigure().getForegroundColor());
        return c;
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest arg0) {
        GraphicalEditPart ep = this.getHost();
        if (ep instanceof IGraphicalEditPart) {
            ConnectionLayer cLayer;
            IGraphicalEditPart gep = (IGraphicalEditPart)ep;
            Routing routingVal = Routing.MANUAL_LITERAL;
            if (gep.getNotationView() != null) {
                Diagram dgrm = gep.getNotationView().getDiagram();
                EditPart epfromReg = (EditPart)gep.getViewer().getEditPartRegistry().get(dgrm);
                if (epfromReg != null) {
                    routingVal = (Routing)epfromReg.getAdapter(Routing.class);
                }
            } else {
                IPreferenceStore store = (IPreferenceStore)((IGraphicalEditPart)ep).getDiagramPreferencesHint().getPreferenceStore();
                routingVal = Routing.get((int)store.getInt("Connectors.lineStyle"));
            }
            if ((cLayer = (ConnectionLayer)this.getLayer("Connection Layer")) instanceof ConnectionLayerEx) {
                ConnectionLayerEx cLayerEx = (ConnectionLayerEx)cLayer;
                if (routingVal == Routing.MANUAL_LITERAL) {
                    return cLayerEx.getObliqueRouter();
                }
                if (routingVal == Routing.RECTILINEAR_LITERAL) {
                    return cLayerEx.getRectilinearRouter();
                }
                if (routingVal == Routing.TREE_LITERAL) {
                    return cLayerEx.getTreeRouter();
                }
            }
        }
        return super.getDummyConnectionRouter(arg0);
    }

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        EditPart source = request.getSourceEditPart();
        return source instanceof INodeEditPart ? ((INodeEditPart)source).getSourceConnectionAnchor((Request)request) : null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        EditPart target = request.getTargetEditPart();
        return target instanceof INodeEditPart ? ((INodeEditPart)target).getTargetConnectionAnchor((Request)request) : null;
    }

    protected INodeEditPart getConnectableEditPart() {
        return (INodeEditPart)this.getHost();
    }

    protected INodeEditPart getConnectionCompleteEditPart(Request request) {
        if (this.getHost() instanceof INodeEditPart) {
            return (INodeEditPart)this.getHost();
        }
        return null;
    }

    protected ConnectionAnchor getConnectionTargetAnchor(Request request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node != null) {
            return node.getTargetConnectionAnchor(request);
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected String getSemanticHint(Request request) {
        String hint = null;
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewAndElementRequest ccvr = (CreateConnectionViewAndElementRequest)request;
            CreateElementRequestAdapter requestAdapter = ccvr.getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
            CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
            hint = PackageUtil.getID((ENamedElement)createElementRequest.getElementType().getEClass());
        } else if (request instanceof ReconnectRequest) {
            ReconnectRequest rr = (ReconnectRequest)request;
            hint = ViewUtil.getSemanticElementClassId((View)((View)rr.getConnectionEditPart().getModel()));
        } else if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest ccvr = (CreateConnectionViewRequest)request;
            hint = ccvr.getConnectionViewDescriptor().getSemanticHint();
        }
        return hint;
    }

    protected Command getRoutingAdjustment(IAdaptable connection, String connectionHint, Routing currentRouterType, EditPart target) {
        SetPropertyCommand spc;
        Command cmdRouter;
        Command cmd = null;
        if (connectionHint == null || target == null || target.getModel() == null || ((View)target.getModel()).getElement() == null) {
            return null;
        }
        String targetHint = ViewUtil.getSemanticElementClassId((View)((View)target.getModel()));
        Routing newRouterType = null;
        if (target instanceof ITreeBranchEditPart && connectionHint.equals(targetHint)) {
            newRouterType = Routing.TREE_LITERAL;
            ChangePropertyValueRequest cpvr = new ChangePropertyValueRequest("", Properties.ID_ROUTING, newRouterType);
            cmdRouter = target.getCommand((Request)cpvr);
            if (cmdRouter != null) {
                cmd = cmd == null ? cmdRouter : cmd.chain(cmdRouter);
            }
        } else if (currentRouterType.equals(Routing.TREE_LITERAL)) {
            IPreferenceStore store = (IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore();
            newRouterType = Routing.get((int)store.getInt("Connectors.lineStyle"));
        }
        if (newRouterType != null && (cmdRouter = new ICommandProxy((ICommand)(spc = new SetPropertyCommand(this.getEditingDomain(), connection, Properties.ID_ROUTING, "", (Object)newRouterType)))) != null) {
            cmd = cmd == null ? cmdRouter : cmd.chain(cmdRouter);
        }
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command cmdRouter;
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        ConnectionAnchor targetAnchor = this.getConnectionTargetAnchor((Request)request);
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Target);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        ICommandProxy cmd = new ICommandProxy((ICommand)cc);
        ConnectionEditPart cep = request.getConnectionEditPart();
        RoutingStyle style = (RoutingStyle)((View)cep.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        Routing currentRouter = Routing.MANUAL_LITERAL;
        if (style != null) {
            currentRouter = style.getRouting();
        }
        if ((cmdRouter = this.getRoutingAdjustment((IAdaptable)request.getConnectionEditPart(), this.getSemanticHint((Request)request), currentRouter, request.getTarget())) != null) {
            cmd = cmd == null ? cmdRouter : cmd.chain(cmdRouter);
            ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
            PointList pointList = new PointList();
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
            SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
            sbbCommand.setEdgeAdapter((IAdaptable)request.getConnectionEditPart());
            sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
            ICommandProxy cmdBP = new ICommandProxy((ICommand)sbbCommand);
            if (cmdBP != null) {
                cmd = cmd == null ? cmdBP : cmd.chain(cmdBP);
            }
        }
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)node.getModel())));
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        scaCommand.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        return new ICommandProxy((ICommand)cc);
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        if (proxy == null) {
            return null;
        }
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor((Request)request);
        Iterator commandItr = cc.iterator();
        commandItr.next();
        SetConnectionEndsCommand sceCommand = (SetConnectionEndsCommand)commandItr.next();
        sceCommand.setNewTargetAdaptor((IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)((Object)targetEP)).getNotationView()));
        SetConnectionAnchorsCommand scaCommand = (SetConnectionAnchorsCommand)commandItr.next();
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        this.setViewAdapter(sceCommand.getEdgeAdaptor());
        INodeEditPart sourceEditPart = (INodeEditPart)request.getSourceEditPart();
        ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(scaCommand.getNewSourceTerminal());
        PointList pointList = new PointList();
        if (request.getLocation() == null) {
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
        } else {
            pointList.addPoint(sourceAnchor.getLocation(request.getLocation()));
            pointList.addPoint(targetAnchor.getLocation(request.getLocation()));
        }
        SetConnectionBendpointsCommand sbbCommand = (SetConnectionBendpointsCommand)((Object)commandItr.next());
        sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
        return request.getStartCommand();
    }

    protected final void setViewAdapter(IAdaptable viewAdapter) {
        this._viewAdapter = viewAdapter;
    }

    protected final IAdaptable getViewAdapter() {
        return this._viewAdapter;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (!(request instanceof CreateConnectionViewRequest)) {
            return null;
        }
        CreateConnectionViewRequest req = (CreateConnectionViewRequest)request;
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_CreateCommand_Connection_Label);
        Diagram diagramView = ((View)this.getHost().getModel()).getDiagram();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        CreateCommand createCommand = new CreateCommand(editingDomain, req.getConnectionViewDescriptor(), (View)diagramView.getDiagram());
        this.setViewAdapter((IAdaptable)createCommand.getCommandResult().getReturnValue());
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor(this.getViewAdapter());
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)this.getView()));
        ConnectionAnchor sourceAnchor = this.getConnectableEditPart().getSourceConnectionAnchor((Request)request);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor(this.getViewAdapter());
        scaCommand.setNewSourceTerminal(this.getConnectableEditPart().mapConnectionAnchorToTerminal(sourceAnchor));
        SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter(this.getViewAdapter());
        cc.compose((IUndoableOperation)createCommand);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        cc.compose((IUndoableOperation)sbbCommand);
        ICommandProxy c = new ICommandProxy((ICommand)cc);
        request.setStartCommand((Command)c);
        return c;
    }

    public Command getCommand(Request request) {
        if ("connection start".equals(request.getType())) {
            if (request instanceof CreateConnectionViewAndElementRequest) {
                return this.getConnectionAndRelationshipCreateCommand((CreateConnectionViewAndElementRequest)request);
            }
            if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                return this.getUnspecifiedConnectionCreateCommand((CreateUnspecifiedTypeConnectionRequest)request);
            }
        } else if ("connection end".equals(request.getType())) {
            if (request instanceof CreateConnectionViewAndElementRequest) {
                return this.getConnectionAndRelationshipCompleteCommand((CreateConnectionViewAndElementRequest)request);
            }
            if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
                return this.getUnspecifiedConnectionCompleteCommand((CreateUnspecifiedTypeConnectionRequest)request);
            }
        }
        return super.getCommand(request);
    }

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        CreateElementRequestAdapter requestAdapter = request.getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
        View sourceView = (View)this.getHost().getModel();
        createElementRequest.setSource(ViewUtil.resolveSemanticElement((View)sourceView));
        Command createElementCommand = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class)), request.getExtendedData()));
        if (createElementCommand == null || !createElementCommand.canExecute()) {
            return createElementCommand;
        }
        return this.getConnectionCreateCommand(request);
    }

    private Command getUnspecifiedConnectionCreateCommand(CreateUnspecifiedTypeConnectionRequest request) {
        if (request.isDirectionReversed()) {
            return new Command(){

                public boolean canExecute() {
                    return true;
                }
            };
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Request individualRequest : request.getAllRequests()) {
            Command cmd = null;
            if (individualRequest instanceof CreateConnectionViewAndElementRequest) {
                cmd = this.getConnectionAndRelationshipCreateCommand((CreateConnectionViewAndElementRequest)individualRequest);
            } else if (individualRequest instanceof CreateConnectionViewRequest) {
                cmd = this.getConnectionCreateCommand((CreateConnectionViewRequest)individualRequest);
            }
            if (cmd == null || !cmd.canExecute()) continue;
            commands.add(cmd);
        }
        if (commands.isEmpty()) {
            return null;
        }
        return new Command(){};
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        CreateElementRequestAdapter requestAdapter = request.getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
        createElementRequest.setPrompt(!request.isUISupressed());
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        View sourceView = (View)request.getSourceEditPart().getModel();
        View targetView = (View)targetEP.getModel();
        EObject source = ViewUtil.resolveSemanticElement((View)sourceView);
        if (source == null) {
            source = sourceView;
        }
        createElementRequest.setSource(source);
        EObject target = ViewUtil.resolveSemanticElement((View)targetView);
        if (target == null) {
            target = targetView;
        }
        createElementRequest.setTarget(target);
        Command createElementCommand = targetEP.getCommand(new EditCommandRequestWrapper((IEditCommandRequest)((CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class)), request.getExtendedData()));
        if (createElementCommand == null) {
            return null;
        }
        SemanticCreateCommand semanticCommand = new SemanticCreateCommand(requestAdapter, createElementCommand);
        Command viewCommand = this.getConnectionCompleteCommand(request);
        if (viewCommand == null) {
            return null;
        }
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        return new ICommandProxy((ICommand)cc);
    }

    protected Command getUnspecifiedConnectionCompleteCommand(CreateUnspecifiedTypeConnectionRequest request) {
        if (request.isDirectionReversed()) {
            return this.getReversedUnspecifiedConnectionCompleteCommand(request);
        }
        List menuContent = this.getConnectionMenuContent(request);
        if (menuContent.isEmpty()) {
            return null;
        }
        if (menuContent.size() == 1) {
            return this.getConnectionCompleteCommand(menuContent.get(0), request);
        }
        return new ICommandProxy(this.getPromptAndCreateConnectionCommand(menuContent, request));
    }

    protected ICommand getPromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
        return new PromptAndCreateConnectionCommand(content, request);
    }

    protected Command getConnectionCompleteCommand(Object connectionType, CreateConnectionRequest request) {
        CreateRequest createRequest;
        if (connectionType instanceof IElementType && request instanceof CreateUnspecifiedTypeConnectionRequest && (createRequest = ((CreateUnspecifiedTypeConnectionRequest)request).getRequestForType((IElementType)connectionType)) != null) {
            return this.getHost().getCommand((Request)createRequest);
        }
        return null;
    }

    protected List getConnectionMenuContent(CreateConnectionRequest request) {
        ArrayList<IElementType> validRelTypes = new ArrayList<IElementType>();
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest unspecifiedRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List allRequests = unspecifiedRequest.getAllRequests();
            if (allRequests.isEmpty()) {
                return null;
            }
            IGraphicalEditPart sourceEP = (IGraphicalEditPart)((CreateConnectionRequest)allRequests.get(0)).getSourceEditPart();
            IGraphicalEditPart targetEP = (IGraphicalEditPart)((CreateConnectionRequest)allRequests.get(0)).getTargetEditPart();
            List allRelTypes = unspecifiedRequest.useModelingAssistantService() ? ModelingAssistantService.getInstance().getRelTypesOnSourceAndTarget((IAdaptable)sourceEP, (IAdaptable)targetEP) : unspecifiedRequest.getElementTypes();
            for (IElementType type : allRelTypes) {
                Command individualCmd = null;
                CreateRequest createConnectionRequest = unspecifiedRequest.getRequestForType(type);
                if (createConnectionRequest != null) {
                    individualCmd = this.getHost().getCommand((Request)createConnectionRequest);
                    if (individualCmd == null || !individualCmd.canExecute()) continue;
                    validRelTypes.add(type);
                    continue;
                }
                CreateConnectionViewRequest connectionRequest = CreateViewRequestFactory.getCreateConnectionRequest(type, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
                connectionRequest.setSourceEditPart(null);
                connectionRequest.setTargetEditPart((EditPart)sourceEP);
                connectionRequest.setType("connection start");
                sourceEP.getCommand((Request)connectionRequest);
                connectionRequest.setSourceEditPart((EditPart)sourceEP);
                connectionRequest.setTargetEditPart((EditPart)targetEP);
                connectionRequest.setType("connection end");
                individualCmd = targetEP.getCommand((Request)connectionRequest);
                if (individualCmd == null || !individualCmd.canExecute()) continue;
                validRelTypes.add(type);
                unspecifiedRequest.addRequest(type, (Request)connectionRequest);
            }
        }
        return validRelTypes;
    }

    protected Command getReversedUnspecifiedConnectionCompleteCommand(CreateUnspecifiedTypeConnectionRequest request) {
        EditPart realSourceEP = request.getTargetEditPart();
        EditPart realTargetEP = request.getSourceEditPart();
        for (CreateConnectionRequest connectionRequest : request.getAllRequests()) {
            connectionRequest.setSourceEditPart(null);
            connectionRequest.setTargetEditPart(realSourceEP);
            connectionRequest.setType((Object)"connection start");
            realSourceEP.getCommand((Request)connectionRequest);
            connectionRequest.setSourceEditPart(realSourceEP);
            connectionRequest.setTargetEditPart(realTargetEP);
            connectionRequest.setType((Object)"connection end");
        }
        request.setDirectionReversed(false);
        Command command = realTargetEP.getCommand((Request)request);
        return command;
    }

    private TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected class PromptAndCreateConnectionCommand
    extends CreateOrSelectElementCommand {
        private CreateConnectionRequest request;
        private Command createCommand;

        public PromptAndCreateConnectionCommand(List content, CreateConnectionRequest request) {
            super(CREATE_CONNECTION_COMMAND_LABEL, Display.getCurrent().getActiveShell(), content);
            this.request = request;
        }

        @Override
        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
            if (!cmdResult.getStatus().isOK()) {
                return cmdResult;
            }
            Object connectionType = cmdResult.getReturnValue();
            Command cmd = GraphicalNodeEditPolicy.this.getConnectionCompleteCommand(connectionType, this.getRequest());
            Assert.isTrue((cmd != null && cmd.canExecute() ? 1 : 0) != 0);
            cmd.execute();
            this.createCommand = cmd;
            if (connectionType instanceof IElementType) {
                CreateRequest createRequest = ((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType((IElementType)connectionType);
                Object newObject = createRequest.getNewObject();
                return CommandResult.newOKCommandResult((Object)newObject);
            }
            return CommandResult.newOKCommandResult();
        }

        @Override
        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.createCommand != null) {
                this.createCommand.undo();
            }
            return super.doUndoWithResult(progressMonitor, info);
        }

        @Override
        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.createCommand != null) {
                this.createCommand.redo();
            }
            return super.doRedoWithResult(progressMonitor, info);
        }

        private CreateConnectionRequest getRequest() {
            return this.request;
        }
    }
}

